/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.util.List;
import org.drools.base.ClassObjectType;
import org.drools.common.InternalRuleBase;
import org.drools.common.InternalWorkingMemory;
import org.drools.core.util.BitMaskUtil;
import org.drools.core.util.ClassUtils;
import org.drools.reteoo.ObjectTypeNode;
import org.drools.rule.TypeDeclaration;
import org.drools.spi.ObjectType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertySpecificUtil {
    public static long calculatePositiveMask(List<String> listenedProperties, List<String> settableProperties) {
        return PropertySpecificUtil.calculatePatternMask(listenedProperties, settableProperties, true);
    }

    public static long calculateNegativeMask(List<String> listenedProperties, List<String> settableProperties) {
        return PropertySpecificUtil.calculatePatternMask(listenedProperties, settableProperties, false);
    }

    private static long calculatePatternMask(List<String> listenedProperties, List<String> settableProperties, boolean isPositive) {
        long mask = 0L;
        if (listenedProperties == null) {
            return mask;
        }
        for (String propertyName : listenedProperties) {
            int pos;
            if (propertyName.equals(isPositive ? "*" : "!*")) {
                return Long.MAX_VALUE;
            }
            if (propertyName.startsWith("!") ^ !isPositive) continue;
            if (!isPositive) {
                propertyName = propertyName.substring(1);
            }
            if ((pos = settableProperties.indexOf(propertyName)) < 0) {
                throw new RuntimeException("Unknown property: " + propertyName);
            }
            mask = BitMaskUtil.set(mask, pos);
        }
        return mask;
    }

    public static List<String> getSettableProperties(InternalWorkingMemory workingMemory, ObjectTypeNode objectTypeNode) {
        return PropertySpecificUtil.getSettableProperties((InternalRuleBase)workingMemory.getRuleBase(), objectTypeNode);
    }

    public static List<String> getSettableProperties(InternalRuleBase ruleBase, ObjectTypeNode objectTypeNode) {
        return PropertySpecificUtil.getSettableProperties(ruleBase, PropertySpecificUtil.getNodeClass(objectTypeNode));
    }

    public static List<String> getSettableProperties(InternalRuleBase ruleBase, Class<?> nodeClass) {
        if (nodeClass == null) {
            return null;
        }
        TypeDeclaration typeDeclaration = ruleBase.getTypeDeclaration(nodeClass);
        if (typeDeclaration == null) {
            return ClassUtils.getSettableProperties(nodeClass);
        }
        typeDeclaration.setTypeClass(nodeClass);
        return typeDeclaration.getSettableProperties();
    }

    public static Class<?> getNodeClass(ObjectTypeNode objectTypeNode) {
        if (objectTypeNode == null) {
            return null;
        }
        ObjectType objectType = objectTypeNode.getObjectType();
        return objectType != null && objectType instanceof ClassObjectType ? ((ClassObjectType)objectType).getClassType() : null;
    }
}

