/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule.builder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.RecognitionException;
import org.drools.base.ClassObjectType;
import org.drools.base.DroolsQuery;
import org.drools.base.EvaluatorWrapper;
import org.drools.base.FieldFactory;
import org.drools.base.ValueType;
import org.drools.base.evaluators.EvaluatorDefinition;
import org.drools.base.evaluators.Operator;
import org.drools.base.mvel.ActivationPropertyHandler;
import org.drools.base.mvel.MVELCompilationUnit;
import org.drools.base.mvel.MVELCompileable;
import org.drools.common.AgendaItem;
import org.drools.compiler.AnalysisResult;
import org.drools.compiler.BoundIdentifiers;
import org.drools.compiler.DescrBuildError;
import org.drools.compiler.Dialect;
import org.drools.compiler.DrlExprParser;
import org.drools.compiler.DroolsParserException;
import org.drools.compiler.PackageRegistry;
import org.drools.core.util.ClassUtils;
import org.drools.core.util.StringUtils;
import org.drools.factmodel.ClassDefinition;
import org.drools.factmodel.FieldDefinition;
import org.drools.facttemplates.FactTemplate;
import org.drools.facttemplates.FactTemplateFieldExtractor;
import org.drools.facttemplates.FactTemplateObjectType;
import org.drools.lang.DRLLexer;
import org.drools.lang.MVELDumper;
import org.drools.lang.descr.AnnotationDescr;
import org.drools.lang.descr.AtomicExprDescr;
import org.drools.lang.descr.BaseDescr;
import org.drools.lang.descr.BehaviorDescr;
import org.drools.lang.descr.BindingDescr;
import org.drools.lang.descr.ConstraintConnectiveDescr;
import org.drools.lang.descr.ExprConstraintDescr;
import org.drools.lang.descr.LiteralRestrictionDescr;
import org.drools.lang.descr.OperatorDescr;
import org.drools.lang.descr.PatternDescr;
import org.drools.lang.descr.PredicateDescr;
import org.drools.lang.descr.RelationalExprDescr;
import org.drools.lang.descr.ReturnValueRestrictionDescr;
import org.drools.reteoo.RuleTerminalNode;
import org.drools.rule.Behavior;
import org.drools.rule.Declaration;
import org.drools.rule.From;
import org.drools.rule.MVELDialectRuntimeData;
import org.drools.rule.Package;
import org.drools.rule.Pattern;
import org.drools.rule.PatternSource;
import org.drools.rule.PredicateConstraint;
import org.drools.rule.Query;
import org.drools.rule.ReturnValueRestriction;
import org.drools.rule.Rule;
import org.drools.rule.RuleConditionElement;
import org.drools.rule.SlidingLengthWindow;
import org.drools.rule.SlidingTimeWindow;
import org.drools.rule.TypeDeclaration;
import org.drools.rule.UnificationRestriction;
import org.drools.rule.VariableRestriction;
import org.drools.rule.builder.ConstraintBuilder;
import org.drools.rule.builder.PredicateBuilder;
import org.drools.rule.builder.QueryElementBuilder;
import org.drools.rule.builder.ReturnValueBuilder;
import org.drools.rule.builder.RuleBuildContext;
import org.drools.rule.builder.RuleConditionBuilder;
import org.drools.rule.builder.dialect.DialectUtil;
import org.drools.rule.builder.dialect.java.JavaDialect;
import org.drools.rule.builder.dialect.mvel.MVELDialect;
import org.drools.rule.constraint.MvelConstraint;
import org.drools.spi.AcceptsClassObjectType;
import org.drools.spi.AcceptsReadAccessor;
import org.drools.spi.Constraint;
import org.drools.spi.Evaluator;
import org.drools.spi.FieldValue;
import org.drools.spi.InternalReadAccessor;
import org.drools.spi.ObjectType;
import org.drools.spi.PatternExtractor;
import org.drools.time.TimeUtils;
import org.drools.type.DateFormats;
import org.mvel2.MVEL;
import org.mvel2.ParserConfiguration;
import org.mvel2.ParserContext;
import org.mvel2.integration.PropertyHandler;
import org.mvel2.integration.PropertyHandlerFactory;
import org.mvel2.util.PropertyTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatternBuilder
implements RuleConditionBuilder {
    private static final java.util.regex.Pattern evalRegexp = java.util.regex.Pattern.compile("^eval\\s*\\(", 8);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RuleConditionElement build(RuleBuildContext context, BaseDescr descr) {
        boolean typeSafe = context.isTypesafe();
        try {
            RuleConditionElement ruleConditionElement = this.build(context, descr, null);
            return ruleConditionElement;
        }
        finally {
            context.setTypesafe(typeSafe);
        }
    }

    @Override
    public RuleConditionElement build(RuleBuildContext context, BaseDescr descr, Pattern prefixPattern) {
        PropertyHandler handler;
        Pattern pattern;
        PatternDescr patternDescr = (PatternDescr)descr;
        if (patternDescr.getObjectType() == null || patternDescr.getObjectType().equals("")) {
            context.addError(new DescrBuildError(context.getParentDescr(), patternDescr, null, "ObjectType not correctly defined"));
            return null;
        }
        FactTemplateObjectType objectType = null;
        FactTemplate factTemplate = context.getPkg().getFactTemplate(patternDescr.getObjectType());
        if (factTemplate != null) {
            objectType = new FactTemplateObjectType(factTemplate);
        } else {
            try {
                Class userProvidedClass = context.getDialect().getTypeResolver().resolveType(patternDescr.getObjectType());
                PackageRegistry pkgr = context.getPackageBuilder().getPackageRegistry(ClassUtils.getPackage((Class)userProvidedClass));
                Package pkg = pkgr == null ? context.getPkg() : pkgr.getPackage();
                boolean isEvent = pkg.isEvent(userProvidedClass);
                objectType = new ClassObjectType(userProvidedClass, isEvent);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        if (objectType == null) {
            RuleConditionElement rce = null;
            if (context.getRule().getName().equals(patternDescr.getObjectType())) {
                QueryElementBuilder qeBuilder = new QueryElementBuilder();
                rce = qeBuilder.build(context, descr, prefixPattern, (Query)context.getRule());
            }
            if (rce == null) {
                Rule rule = context.getPkg().getRule(patternDescr.getObjectType());
                if (rule != null && rule instanceof Query) {
                    QueryElementBuilder qeBuilder = new QueryElementBuilder();
                    rce = qeBuilder.build(context, descr, prefixPattern, (Query)rule);
                }
                for (String importName : context.getDialect().getTypeResolver().getImports()) {
                    int pos = (importName = importName.trim()).indexOf(42);
                    if (pos < 0) continue;
                    String pkgName = importName.substring(0, pos - 1);
                    PackageRegistry pkgReg = context.getPackageBuilder().getPackageRegistry(pkgName);
                    if (pkgReg == null || (rule = pkgReg.getPackage().getRule(patternDescr.getObjectType())) == null || !(rule instanceof Query)) continue;
                    QueryElementBuilder qeBuilder = new QueryElementBuilder();
                    rce = qeBuilder.build(context, descr, prefixPattern, (Query)rule);
                    break;
                }
            }
            if (rce == null) {
                context.addError(new DescrBuildError(context.getParentDescr(), patternDescr, null, "Unable to resolve ObjectType '" + patternDescr.getObjectType() + "'"));
            }
            return rce;
        }
        boolean duplicateBindings = context.getDeclarationResolver().isDuplicated(context.getRule(), patternDescr.getIdentifier());
        if (!StringUtils.isEmpty((CharSequence)patternDescr.getIdentifier()) && !duplicateBindings) {
            pattern = new Pattern(context.getNextPatternId(), 0, (ObjectType)objectType, patternDescr.getIdentifier(), patternDescr.isInternalFact());
            if (objectType instanceof ClassObjectType) {
                context.getPkg().getClassFieldAccessorStore().getClassObjectType((ClassObjectType)objectType, (AcceptsClassObjectType)((PatternExtractor)pattern.getDeclaration().getExtractor()));
            }
        } else {
            pattern = new Pattern(context.getNextPatternId(), 0, (ObjectType)objectType, null);
        }
        if (ClassObjectType.Activation_ObjectType.isAssignableFrom(pattern.getObjectType()) && (handler = PropertyHandlerFactory.getPropertyHandler(AgendaItem.class)) == null) {
            MVELCompilationUnit.PropertyHandlerFactoryFixer.getPropertyHandlerClass().put(AgendaItem.class, new ActivationPropertyHandler());
        }
        if (duplicateBindings) {
            if (patternDescr.isUnification()) {
                this.build(context, patternDescr, pattern, patternDescr, "this == " + patternDescr.getIdentifier());
            } else {
                context.addError(new DescrBuildError(context.getParentDescr(), patternDescr, null, "Duplicate declaration for variable '" + patternDescr.getIdentifier() + "' in the rule '" + context.getRule().getName() + "'"));
            }
        }
        if (objectType instanceof ClassObjectType) {
            context.getPkg().getClassFieldAccessorStore().getClassObjectType((ClassObjectType)objectType, (AcceptsClassObjectType)pattern);
        }
        context.getBuildStack().push((RuleConditionElement)pattern);
        if (pattern.getObjectType() instanceof ClassObjectType) {
            Class cls = ((ClassObjectType)pattern.getObjectType()).getClassType();
            TypeDeclaration typeDeclr = context.getPackageBuilder().getAndRegisterTypeDeclaration(cls, context.getPkg().getName());
            if (typeDeclr != null) {
                context.setTypesafe(typeDeclr.isTypesafe());
            } else {
                context.setTypesafe(true);
            }
        }
        this.processConstraintsAndBinds(context, patternDescr, pattern);
        this.processAnnotations(context, patternDescr, pattern);
        if (patternDescr.getSource() != null) {
            RuleConditionBuilder builder = (RuleConditionBuilder)context.getDialect().getBuilder(patternDescr.getSource().getClass());
            PatternSource source = (PatternSource)builder.build(context, patternDescr.getSource());
            if (source instanceof From) {
                ((From)source).setResultPattern(pattern);
            }
            pattern.setSource(source);
        }
        for (BehaviorDescr behaviorDescr : patternDescr.getBehaviors()) {
            if (pattern.getObjectType().isEvent()) {
                SlidingTimeWindow window;
                if (Behavior.BehaviorType.TIME_WINDOW.matches(behaviorDescr.getSubType())) {
                    window = new SlidingTimeWindow(TimeUtils.parseTimeString((String)behaviorDescr.getParameters().get(0)));
                    pattern.addBehavior((Behavior)window);
                    continue;
                }
                if (!Behavior.BehaviorType.LENGTH_WINDOW.matches(behaviorDescr.getSubType())) continue;
                window = new SlidingLengthWindow(Integer.valueOf(behaviorDescr.getParameters().get(0)).intValue());
                pattern.addBehavior((Behavior)window);
                continue;
            }
            context.addError(new DescrBuildError(context.getParentDescr(), patternDescr, null, "A Sliding Window behavior can only be assigned to patterns declared with @role( event ). The pattern '" + pattern.getObjectType() + "' in the rule '" + context.getRule().getName() + "' is not declared as an Event."));
        }
        context.getBuildStack().pop();
        return pattern;
    }

    private void processAnnotations(RuleBuildContext context, PatternDescr patternDescr, Pattern pattern) {
        Map<String, AnnotationDescr> annotationMap = patternDescr.getAnnotations();
        if (annotationMap == null) {
            return;
        }
        this.processListenedPropertiesAnnotation(context, patternDescr, pattern, annotationMap);
    }

    private void processListenedPropertiesAnnotation(RuleBuildContext context, PatternDescr patternDescr, Pattern pattern, Map<String, AnnotationDescr> annotationMap) {
        AnnotationDescr listenedProps = annotationMap.get("watch");
        if (listenedProps != null) {
            List<String> settableProperties = this.getSettableProperties(context, patternDescr, pattern);
            ArrayList<String> listenedProperties = new ArrayList<String>();
            for (String propertyName : listenedProps.getValue().toString().split(",")) {
                if ((propertyName = propertyName.trim()).equals("*") || propertyName.equals("!*")) {
                    if (listenedProperties.contains("*") || listenedProperties.contains("!*")) {
                        context.addError(new DescrBuildError(context.getParentDescr(), patternDescr, null, "Duplicate usage of wildcard * in @watch annotation"));
                        continue;
                    }
                    listenedProperties.add(propertyName);
                    continue;
                }
                boolean isNegative = propertyName.startsWith("!");
                String string = propertyName = isNegative ? propertyName.substring(1).trim() : propertyName;
                if (settableProperties != null && !settableProperties.contains(propertyName)) {
                    context.addError(new DescrBuildError(context.getParentDescr(), patternDescr, null, "Unknown property " + propertyName + " in @" + "watch" + " annotation"));
                    continue;
                }
                if (listenedProperties.contains(propertyName) || listenedProperties.contains("!" + propertyName)) {
                    context.addError(new DescrBuildError(context.getParentDescr(), patternDescr, null, "Duplicate property " + propertyName + " in @" + "watch" + " annotation"));
                    continue;
                }
                listenedProperties.add(isNegative ? "!" + propertyName : propertyName);
            }
            pattern.setListenedProperties(listenedProperties);
        }
    }

    private List<String> getSettableProperties(RuleBuildContext context, PatternDescr patternDescr, Pattern pattern) {
        ObjectType patternType = pattern.getObjectType();
        if (!(patternType instanceof ClassObjectType)) {
            return null;
        }
        Class patternClass = ((ClassObjectType)patternType).getClassType();
        TypeDeclaration typeDeclaration = context.getPackageBuilder().getTypeDeclaration(patternClass);
        if (!typeDeclaration.isPropertySpecific()) {
            context.addError(new DescrBuildError(context.getParentDescr(), patternDescr, null, "Wrong usage of @watch annotation on class " + patternClass.getName() + " that is not annotated as @PropertyReactive"));
        }
        typeDeclaration.setTypeClass(patternClass);
        return typeDeclaration.getSettableProperties();
    }

    private void processConstraintsAndBinds(RuleBuildContext context, PatternDescr patternDescr, Pattern pattern) {
        for (BaseDescr baseDescr : patternDescr.getDescrs()) {
            String expression;
            boolean isPositional = false;
            if (baseDescr instanceof BindingDescr) {
                BindingDescr bind = (BindingDescr)baseDescr;
                expression = bind.getVariable() + (bind.isUnification() ? " := " : " : ") + bind.getExpression();
            } else if (baseDescr instanceof ExprConstraintDescr) {
                ExprConstraintDescr descr = (ExprConstraintDescr)baseDescr;
                expression = descr.getExpression();
                isPositional = descr.getType() == ExprConstraintDescr.Type.POSITIONAL;
            } else {
                expression = baseDescr.getText();
            }
            ConstraintConnectiveDescr result = this.parseExpression(context, patternDescr, baseDescr, expression);
            if (result == null) {
                return;
            }
            if (result.getDescrs().size() == 1 && result.getDescrs().get(0) instanceof BindingDescr) {
                this.buildRuleBindings(context, patternDescr, pattern, (BindingDescr)result.getDescrs().get(0));
                continue;
            }
            if (isPositional) {
                this.processPositional(context, patternDescr, pattern, (ExprConstraintDescr)baseDescr);
                continue;
            }
            this.build(context, patternDescr, pattern, result);
        }
        this.combineConstraints(context, pattern);
    }

    private void combineConstraints(RuleBuildContext context, Pattern pattern) {
        List combinableConstraints = pattern.getCombinableConstraints();
        if (combinableConstraints.size() < 2) {
            return;
        }
        ArrayList<Declaration> declarations = new ArrayList<Declaration>();
        HashSet<String> declarationNames = new HashSet<String>();
        boolean isFirst = true;
        String packageName = null;
        StringBuilder expressionBuilder = new StringBuilder(combinableConstraints.size() * 25);
        for (MvelConstraint constraint : combinableConstraints) {
            boolean isComplex;
            pattern.removeConstraint((Constraint)constraint);
            if (isFirst) {
                packageName = constraint.getPackageName();
                isFirst = false;
            } else {
                expressionBuilder.append(" && ");
            }
            String constraintExpression = constraint.getExpression();
            boolean bl = isComplex = constraintExpression.contains("&&") || constraintExpression.contains("||");
            if (isComplex) {
                expressionBuilder.append("( ");
            }
            expressionBuilder.append(constraintExpression);
            if (isComplex) {
                expressionBuilder.append(" )");
            }
            for (Declaration declaration : constraint.getRequiredDeclarations()) {
                if (!declarationNames.add(declaration.getBindingName())) continue;
                declarations.add(declaration);
            }
        }
        String expression = expressionBuilder.toString();
        MVELCompilationUnit compilationUnit = ConstraintBuilder.buildCompilationUnit(context, pattern, expression);
        MvelConstraint combinedConstraint = new MvelConstraint(packageName, expression, declarations.toArray(new Declaration[declarations.size()]), compilationUnit, false, null, null, false);
        pattern.addConstraint((Constraint)combinedConstraint);
    }

    private void processPositional(RuleBuildContext context, PatternDescr patternDescr, Pattern pattern, ExprConstraintDescr descr) {
        if (descr.getType() == ExprConstraintDescr.Type.POSITIONAL && pattern.getObjectType() instanceof ClassObjectType) {
            Class klazz = ((ClassObjectType)pattern.getObjectType()).getClassType();
            TypeDeclaration tDecl = context.getPackageBuilder().getTypeDeclaration(klazz);
            if (tDecl == null) {
                context.addError(new DescrBuildError(context.getParentDescr(), descr, klazz, "Unable to find @positional definitions for :" + klazz + "\n"));
                return;
            }
            ClassDefinition clsDef = tDecl.getTypeClassDef();
            if (clsDef == null) {
                context.addError(new DescrBuildError(context.getParentDescr(), descr, null, "Unable to find @positional field " + descr.getPosition() + " for class " + tDecl.getTypeName() + "\n"));
                return;
            }
            FieldDefinition field = clsDef.getField(descr.getPosition());
            if (field == null) {
                context.addError(new DescrBuildError(context.getParentDescr(), descr, null, "Unable to find @positional field " + descr.getPosition() + " for class " + tDecl.getTypeName() + "\n"));
                return;
            }
            DRLLexer lex = new DRLLexer((CharStream)new ANTLRStringStream(descr.getExpression()));
            boolean isSimpleIdentifier = false;
            try {
                lex.mID();
                isSimpleIdentifier = lex.getCharIndex() >= descr.getExpression().length();
            }
            catch (RecognitionException e) {
                // empty catch block
            }
            if (isSimpleIdentifier) {
                BindingDescr binder = new BindingDescr();
                binder.setUnification(true);
                binder.setExpression(field.getName());
                binder.setVariable(descr.getExpression());
                this.buildRuleBindings(context, patternDescr, pattern, binder);
            } else {
                this.build(context, patternDescr, pattern, descr, field.getName() + " == " + descr.getExpression());
            }
        }
    }

    private void build(RuleBuildContext context, PatternDescr patternDescr, Pattern pattern, BaseDescr original, String expr) {
        ConstraintConnectiveDescr result = this.parseExpression(context, patternDescr, original, expr);
        if (result == null) {
            return;
        }
        result.copyLocation(original);
        this.build(context, patternDescr, pattern, result);
    }

    private void build(RuleBuildContext context, PatternDescr patternDescr, Pattern pattern, ConstraintConnectiveDescr descr) {
        for (BaseDescr d : descr.getDescrs()) {
            d.copyLocation(descr);
            if (d instanceof BindingDescr) {
                this.buildRuleBindings(context, patternDescr, pattern, (BindingDescr)d);
                continue;
            }
            MVELDumper.MVELDumperContext mvelCtx = new MVELDumper.MVELDumperContext();
            String expr = new MVELDumper().dump(d, mvelCtx);
            Map<String, OperatorDescr> aliases = mvelCtx.getAliases();
            for (BindingDescr bind : mvelCtx.getBindings()) {
                this.buildRuleBindings(context, patternDescr, pattern, bind);
            }
            if (this.processAtomicExpression(context, pattern, d, expr, aliases)) continue;
            this.buildExpression(context, pattern, d, expr, aliases);
        }
    }

    private void buildExpression(RuleBuildContext context, Pattern pattern, BaseDescr d, String expr, Map<String, OperatorDescr> aliases) {
        RelationalExprDescr relDescr = d instanceof RelationalExprDescr ? (RelationalExprDescr)d : null;
        boolean simple = this.isSimpleExpr(relDescr);
        if (simple && !ClassObjectType.Map_ObjectType.isAssignableFrom(pattern.getObjectType()) && !ClassObjectType.Activation_ObjectType.isAssignableFrom(pattern.getObjectType())) {
            this.buildRelationalExpression(context, pattern, relDescr, expr, aliases);
        } else {
            this.createAndBuildPredicate(context, pattern, d, expr, aliases);
        }
    }

    private void buildRelationalExpression(RuleBuildContext context, Pattern pattern, RelationalExprDescr relDescr, String expr, Map<String, OperatorDescr> aliases) {
        String value1;
        boolean usesThisRef;
        String value2;
        BaseDescr rdescr;
        if (relDescr.getRight() instanceof AtomicExprDescr) {
            rdescr = (AtomicExprDescr)relDescr.getRight();
            value2 = ((AtomicExprDescr)rdescr).getExpression().trim();
            usesThisRef = "this".equals(value2) || value2.startsWith("this.");
        } else {
            rdescr = (BindingDescr)relDescr.getRight();
            value2 = ((BindingDescr)rdescr).getExpression().trim();
            boolean bl = usesThisRef = "this".equals(value2) || value2.startsWith("this.");
        }
        if (relDescr.getLeft() instanceof AtomicExprDescr) {
            AtomicExprDescr ldescr = (AtomicExprDescr)relDescr.getLeft();
            value1 = ldescr.getExpression();
            usesThisRef = usesThisRef || "this".equals(value1) || value1.startsWith("this.");
        } else {
            value1 = ((BindingDescr)relDescr.getLeft()).getExpression();
            usesThisRef = usesThisRef || "this".equals(value1) || value1.startsWith("this.");
        }
        ExprBindings value1Expr = new ExprBindings();
        this.setInputs(context, value1Expr, pattern.getObjectType() instanceof ClassObjectType ? ((ClassObjectType)pattern.getObjectType()).getClassType() : FactTemplate.class, value1);
        ExprBindings value2Expr = new ExprBindings();
        this.setInputs(context, value2Expr, pattern.getObjectType() instanceof ClassObjectType ? ((ClassObjectType)pattern.getObjectType()).getClassType() : FactTemplate.class, value2);
        if (!usesThisRef && value1Expr.isConstant() || !this.addConstraintToPattern(context, pattern, relDescr, expr, value1, value2, value2Expr.isConstant())) {
            this.createAndBuildPredicate(context, pattern, relDescr, expr, aliases);
        }
    }

    private boolean addConstraintToPattern(RuleBuildContext context, Pattern pattern, RelationalExprDescr relDescr, String expr, String value1, String value2, boolean isConstant) {
        String[] parts;
        Constraint constraint;
        FieldValue field;
        InternalReadAccessor extractor;
        int dotPos = value1.indexOf(46);
        if (dotPos > 0) {
            String part0 = value1.substring(0, dotPos).trim();
            if ("this".equals(part0.trim())) {
                value1 = value1.substring(dotPos + 1);
            } else if (pattern.getDeclaration() != null && part0.equals(pattern.getDeclaration().getIdentifier())) {
                value1 = value1.substring(dotPos + 1);
                expr = expr.substring(dotPos + 1);
            }
        }
        if ((extractor = PatternBuilder.getFieldReadAccessor(context, relDescr, pattern.getObjectType(), value1, null, false)) == null) {
            return false;
        }
        ValueType vtype = extractor.getValueType();
        String operator = relDescr.getOperator().trim();
        LiteralRestrictionDescr restrictionDescr = this.buildLiteralRestrictionDescr(context, relDescr, value2, operator, isConstant);
        if (restrictionDescr != null && (field = this.getFieldValue(context, vtype, restrictionDescr)) != null && (constraint = ConstraintBuilder.buildLiteralConstraint(context, pattern, vtype, field, expr, value1, operator, value2, extractor, restrictionDescr)) != null) {
            pattern.addConstraint(constraint);
            return true;
        }
        ReturnValueRestriction restriction = null;
        Declaration[] declarations = null;
        Declaration declr = null;
        if (value2.indexOf(40) < 0 && value2.indexOf(46) < 0 && value2.indexOf(91) < 0 && (declr = context.getDeclarationResolver().getDeclaration(context.getRule(), value2)) == null) {
            Pattern thisPattern = (Pattern)context.getBuildStack().peek();
            declr = PatternBuilder.createDeclarationObject(context, value2, thisPattern);
            if (declr == null) {
                try {
                    Class cls = context.getDialect().getTypeResolver().resolveType(value2);
                    restrictionDescr = new LiteralRestrictionDescr(operator, relDescr.isNegated(), relDescr.getParameters(), cls.getName(), 3);
                    restriction = ConstraintBuilder.buildLiteralRestriction(context, extractor, restrictionDescr, this.getFieldValue(context, vtype, restrictionDescr), vtype);
                }
                catch (ClassNotFoundException cnfe) {
                    return false;
                }
            }
        }
        if (declr == null && (parts = value2.split("\\.")).length == 2) {
            if ("this".equals(parts[0].trim())) {
                declr = PatternBuilder.createDeclarationObject(context, parts[1].trim(), (Pattern)context.getBuildStack().peek());
                value2 = parts[1].trim();
            } else {
                declr = context.getDeclarationResolver().getDeclaration(context.getRule(), parts[0].trim());
                if (declr != null) {
                    if (declr.isPatternDeclaration()) {
                        declarations = new Declaration[]{declr};
                        declr = PatternBuilder.createDeclarationObject(context, parts[1].trim(), declr.getPattern());
                        value2 = parts[1].trim();
                    } else {
                        return false;
                    }
                }
            }
        }
        if (declr != null) {
            EvaluatorDefinition.Target right = ConstraintBuilder.getRightTarget(extractor);
            EvaluatorDefinition.Target left = declr.isPatternDeclaration() && !Date.class.isAssignableFrom(declr.getExtractor().getExtractToClass()) && !Number.class.isAssignableFrom(declr.getExtractor().getExtractToClass()) ? EvaluatorDefinition.Target.HANDLE : EvaluatorDefinition.Target.FACT;
            Evaluator evaluator = ConstraintBuilder.getEvaluator(context, relDescr, extractor.getValueType(), operator, relDescr.isNegated(), relDescr.getParametersText(), left, right);
            if (evaluator == null) {
                return false;
            }
            restriction = new VariableRestriction(extractor, declr, evaluator);
            if (declr.getPattern().getObjectType().equals(new ClassObjectType(DroolsQuery.class)) && Operator.EQUAL.getOperatorString().equals(operator)) {
                restriction = new UnificationRestriction((VariableRestriction)restriction);
            }
        }
        if (restriction == null) {
            Dialect dialect = context.getDialect();
            if (!value2.startsWith("(")) {
                MVELDialect mvelDialect = (MVELDialect)context.getDialect("mvel");
                context.setDialect(mvelDialect);
            }
            restriction = this.buildRestriction(context, (Pattern)context.getBuildStack().peek(), extractor, new ReturnValueRestrictionDescr(operator, relDescr.isNegated(), relDescr.getParametersText(), value2));
            context.setDialect(dialect);
        }
        if (restriction == null) {
            return false;
        }
        if (declarations == null) {
            if (declr == null) {
                ReturnValueRestriction returnValueRestriction = restriction;
                Declaration[] requiredDeclarations = restriction.getRequiredDeclarations();
                String[] requiredGlobals = returnValueRestriction.getRequiredGlobals();
                declarations = new Declaration[(requiredDeclarations != null ? requiredDeclarations.length : 0) + (requiredGlobals != null ? requiredGlobals.length : 0)];
                int i = 0;
                if (requiredDeclarations != null) {
                    for (Declaration declaration : requiredDeclarations) {
                        declarations[i++] = declaration;
                    }
                }
                if (requiredGlobals != null) {
                    for (String string : requiredGlobals) {
                        declarations[i++] = context.getDeclarationResolver().getDeclaration(context.getRule(), string);
                    }
                }
            } else {
                declarations = new Declaration[]{declr};
            }
        }
        pattern.addConstraint(ConstraintBuilder.buildVariableConstraint(context, pattern, expr, declarations, value1, operator, value2, extractor, restriction));
        return true;
    }

    private LiteralRestrictionDescr buildLiteralRestrictionDescr(RuleBuildContext context, RelationalExprDescr exprDescr, String rightValue, String operator, boolean isRightLiteral) {
        if (isRightLiteral) {
            return new LiteralRestrictionDescr(operator, exprDescr.isNegated(), exprDescr.getParameters(), rightValue, 3);
        }
        int dotPos = rightValue.lastIndexOf(46);
        if (dotPos >= 0) {
            String mainPart = rightValue.substring(0, dotPos);
            String lastPart = rightValue.substring(dotPos + 1);
            try {
                context.getDialect().getTypeResolver().resolveType(mainPart);
                if (lastPart.indexOf(40) < 0 && lastPart.indexOf(46) < 0 && lastPart.indexOf(91) < 0) {
                    return new LiteralRestrictionDescr(operator, exprDescr.isNegated(), exprDescr.getParameters(), rightValue, 3);
                }
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        return null;
    }

    private boolean processAtomicExpression(RuleBuildContext context, Pattern pattern, BaseDescr d, String expr, Map<String, OperatorDescr> aliases) {
        Matcher m;
        if (d instanceof AtomicExprDescr && (m = evalRegexp.matcher(((AtomicExprDescr)d).getExpression())).find()) {
            PredicateDescr pdescr = new PredicateDescr(context.getRuleDescr().getResource(), expr);
            pdescr.copyLocation(d);
            this.buildEval(context, pattern, pdescr, aliases, expr, true);
            return true;
        }
        return false;
    }

    private boolean isSimpleExpr(RelationalExprDescr relDescr) {
        boolean simple = false;
        if (relDescr != null && (relDescr.getLeft() instanceof AtomicExprDescr || relDescr.getLeft() instanceof BindingDescr) && (relDescr.getRight() instanceof AtomicExprDescr || relDescr.getRight() instanceof BindingDescr)) {
            simple = true;
        }
        return simple;
    }

    private void createAndBuildPredicate(RuleBuildContext context, Pattern pattern, BaseDescr base, String expr, Map<String, OperatorDescr> aliases) {
        Dialect dialect = context.getDialect();
        MVELDialect mvelDialect = (MVELDialect)context.getDialect("mvel");
        context.setDialect(mvelDialect);
        PredicateDescr pdescr = new PredicateDescr(context.getRuleDescr().getResource(), expr);
        pdescr.copyLocation(base);
        this.buildEval(context, pattern, pdescr, aliases, expr, false);
        context.setDialect(dialect);
    }

    private void setInputs(RuleBuildContext context, ExprBindings descrBranch, Class<?> thisClass, String expr) {
        MVELDialectRuntimeData data = (MVELDialectRuntimeData)context.getPkg().getDialectRuntimeRegistry().getDialectData("mvel");
        ParserConfiguration conf = data.getParserConfiguration();
        conf.setClassLoader((ClassLoader)context.getPackageBuilder().getRootClassLoader());
        ParserContext pctx = new ParserContext(conf);
        pctx.setStrictTypeEnforcement(false);
        pctx.setStrongTyping(false);
        pctx.addInput("this", thisClass);
        pctx.addInput("empty", Boolean.TYPE);
        MVEL.COMPILER_OPT_ALLOW_NAKED_METH_CALL = true;
        MVEL.COMPILER_OPT_ALLOW_OVERRIDE_ALL_PROPHANDLING = true;
        MVEL.COMPILER_OPT_ALLOW_RESOLVE_INNERCLASSES_WITH_DOTNOTATION = true;
        MVEL.COMPILER_OPT_SUPPORT_JAVA_STYLE_CLASS_LITERALS = true;
        try {
            MVEL.analysisCompile((String)expr, (ParserContext)pctx);
        }
        catch (Exception e) {
            return;
        }
        if (!pctx.getInputs().isEmpty()) {
            for (String v : pctx.getInputs().keySet()) {
                if ("this".equals(v) || PropertyTools.getFieldOrAccessor(thisClass, (String)v) != null && expr.matches("(^|.*\\W)empty($|\\W.*)")) {
                    descrBranch.getFieldAccessors().add(v);
                    continue;
                }
                if ("empty".equals(v)) continue;
                if (!context.getPkg().getGlobals().containsKey(v)) {
                    descrBranch.getRuleBindings().add(v);
                    continue;
                }
                descrBranch.getGlobalBindings().add(v);
            }
        }
    }

    private void buildRuleBindings(RuleBuildContext context, PatternDescr patternDescr, Pattern pattern, BindingDescr fieldBindingDescr) {
        if (context.getDeclarationResolver().isDuplicated(context.getRule(), fieldBindingDescr.getVariable())) {
            if (fieldBindingDescr.isUnification()) {
                this.build(context, patternDescr, pattern, fieldBindingDescr, fieldBindingDescr.getExpression() + " == " + fieldBindingDescr.getVariable());
                return;
            }
            context.addError(new DescrBuildError(context.getParentDescr(), fieldBindingDescr, null, "Duplicate declaration for variable '" + fieldBindingDescr.getVariable() + "' in the rule '" + context.getRule().getName() + "'"));
        }
        Declaration declr = pattern.addDeclaration(fieldBindingDescr.getVariable());
        InternalReadAccessor extractor = PatternBuilder.getFieldReadAccessor(context, fieldBindingDescr, pattern.getObjectType(), fieldBindingDescr.getExpression(), (AcceptsReadAccessor)declr, true);
        declr.setReadAccessor(extractor);
    }

    private void buildEval(RuleBuildContext context, Pattern pattern, PredicateDescr predicateDescr, Map<String, OperatorDescr> aliases, String expr, boolean isEvalExpression) {
        boolean isJavaEval;
        AnalysisResult analysis = PatternBuilder.buildAnalysis(context, pattern, predicateDescr, aliases);
        if (analysis == null) {
            return;
        }
        Declaration[][] usedDeclarations = PatternBuilder.getUsedDeclarations(context, pattern, analysis);
        Declaration[] previousDeclarations = usedDeclarations[0];
        Declaration[] localDeclarations = usedDeclarations[1];
        BoundIdentifiers usedIdentifiers = analysis.getBoundIdentifiers();
        String[] requiredGlobals = usedIdentifiers.getGlobals().keySet().toArray(new String[usedIdentifiers.getGlobals().size()]);
        String[] requiredOperators = usedIdentifiers.getOperators().keySet().toArray(new String[usedIdentifiers.getOperators().size()]);
        Arrays.sort(previousDeclarations, RuleTerminalNode.SortDeclarations.instance);
        Arrays.sort(localDeclarations, RuleTerminalNode.SortDeclarations.instance);
        boolean usePredicateConstraint = isJavaEval = isEvalExpression && context.getDialect() instanceof JavaDialect;
        if (usePredicateConstraint) {
            PredicateConstraint predicateConstraint = new PredicateConstraint(null, previousDeclarations, localDeclarations, requiredGlobals, requiredOperators);
            PredicateBuilder builder = context.getDialect().getPredicateBuilder();
            builder.build(context, usedIdentifiers, previousDeclarations, localDeclarations, predicateConstraint, predicateDescr, analysis);
            pattern.addConstraint((Constraint)predicateConstraint);
        } else {
            MVELCompilationUnit compilationUnit = ConstraintBuilder.buildCompilationUnit(context, previousDeclarations, localDeclarations, predicateDescr, analysis);
            Declaration[] mvelDeclarations = new Declaration[previousDeclarations.length + localDeclarations.length + requiredGlobals.length];
            int i = 0;
            for (Declaration declaration : previousDeclarations) {
                mvelDeclarations[i++] = declaration;
            }
            for (Declaration declaration : localDeclarations) {
                mvelDeclarations[i++] = declaration;
            }
            for (String string : requiredGlobals) {
                mvelDeclarations[i++] = context.getDeclarationResolver().getDeclaration(context.getRule(), string);
            }
            boolean bl = requiredOperators.length > 0 || ClassObjectType.Activation_ObjectType.isAssignableFrom(pattern.getObjectType()) || !context.getPackageBuilder().getTypeDeclaration(((ClassObjectType)pattern.getObjectType()).getClassType()).isTypesafe();
            MvelConstraint constraint = new MvelConstraint(context.getPkg().getName(), expr, mvelDeclarations, compilationUnit, bl);
            pattern.addConstraint((Constraint)constraint);
        }
    }

    public static Declaration[][] getUsedDeclarations(RuleBuildContext context, Pattern pattern, AnalysisResult analysis) {
        BoundIdentifiers usedIdentifiers = analysis.getBoundIdentifiers();
        ArrayList<Declaration> tupleDeclarations = new ArrayList<Declaration>();
        ArrayList<Declaration> factDeclarations = new ArrayList<Declaration>();
        for (String id : usedIdentifiers.getDeclrClasses().keySet()) {
            Declaration decl = context.getDeclarationResolver().getDeclaration(context.getRule(), id);
            if (decl.getPattern() == pattern) {
                factDeclarations.add(decl);
                continue;
            }
            tupleDeclarations.add(decl);
        }
        PatternBuilder.createImplicitBindings(context, pattern, analysis.getNotBoundedIdentifiers(), analysis.getBoundIdentifiers(), factDeclarations);
        Declaration[][] usedDeclarations = new Declaration[][]{tupleDeclarations.toArray(new Declaration[tupleDeclarations.size()]), factDeclarations.toArray(new Declaration[factDeclarations.size()])};
        return usedDeclarations;
    }

    public static AnalysisResult buildAnalysis(RuleBuildContext context, Pattern pattern, PredicateDescr predicateDescr, Map<String, OperatorDescr> aliases) {
        Map<String, Class<?>> declarations = PatternBuilder.getDeclarationsMap(predicateDescr, context, true);
        Map<String, Class<?>> globals = context.getPackageBuilder().getGlobals();
        HashMap<String, EvaluatorWrapper> operators = aliases == null ? new HashMap<String, EvaluatorWrapper>() : PatternBuilder.buildOperators(context, pattern, predicateDescr, aliases);
        Class thisClass = null;
        if (pattern.getObjectType() instanceof ClassObjectType) {
            thisClass = ((ClassObjectType)pattern.getObjectType()).getClassType();
        }
        return context.getDialect().analyzeExpression(context, predicateDescr, predicateDescr.getContent(), new BoundIdentifiers(declarations, globals, operators, thisClass));
    }

    private static Map<String, EvaluatorWrapper> buildOperators(RuleBuildContext context, Pattern pattern, PredicateDescr predicateDescr, Map<String, OperatorDescr> aliases) {
        HashMap<String, EvaluatorWrapper> operators = new HashMap<String, EvaluatorWrapper>();
        for (Map.Entry<String, OperatorDescr> entry : aliases.entrySet()) {
            Declaration rightDecl;
            OperatorDescr op = entry.getValue();
            String leftStr = op.getLeftString();
            String rightStr = op.getRightString();
            Declaration leftDecl = context.getDeclarationResolver().getDeclaration(context.getRule(), leftStr);
            if (leftDecl == null && "this".equals(leftStr)) {
                leftDecl = PatternBuilder.createDeclarationObject(context, "this", pattern);
            }
            if ((rightDecl = context.getDeclarationResolver().getDeclaration(context.getRule(), rightStr)) == null && "this".equals(rightStr)) {
                rightDecl = PatternBuilder.createDeclarationObject(context, "this", pattern);
            }
            EvaluatorDefinition.Target left = leftDecl != null && leftDecl.isPatternDeclaration() ? EvaluatorDefinition.Target.HANDLE : EvaluatorDefinition.Target.FACT;
            EvaluatorDefinition.Target right = rightDecl != null && rightDecl.isPatternDeclaration() ? EvaluatorDefinition.Target.HANDLE : EvaluatorDefinition.Target.FACT;
            op.setLeftIsHandle(left == EvaluatorDefinition.Target.HANDLE);
            op.setRightIsHandle(right == EvaluatorDefinition.Target.HANDLE);
            Evaluator evaluator = ConstraintBuilder.getEvaluator(context, predicateDescr, ValueType.OBJECT_TYPE, op.getOperator(), false, op.getParametersText(), left, right);
            EvaluatorWrapper wrapper = new EvaluatorWrapper(evaluator, (Declaration)(left == EvaluatorDefinition.Target.HANDLE ? leftDecl : null), (Declaration)(right == EvaluatorDefinition.Target.HANDLE ? rightDecl : null));
            operators.put(entry.getKey(), wrapper);
        }
        return operators;
    }

    private static Map<String, Class<?>> getDeclarationsMap(BaseDescr baseDescr, RuleBuildContext context, boolean reportError) {
        HashMap declarations = new HashMap();
        for (Map.Entry entry : context.getDeclarationResolver().getDeclarations(context.getRule()).entrySet()) {
            if (((Declaration)entry.getValue()).getExtractor() == null) {
                if (!reportError) continue;
                context.addError(new DescrBuildError(context.getParentDescr(), baseDescr, null, "Field Reader does not exist for declaration '" + (String)entry.getKey() + "' in '" + baseDescr + "' in the rule '" + context.getRule().getName() + "'"));
                continue;
            }
            declarations.put((String)entry.getKey(), ((Declaration)entry.getValue()).getExtractor().getExtractToClass());
        }
        return declarations;
    }

    private static void createImplicitBindings(RuleBuildContext context, Pattern pattern, Set<String> unboundIdentifiers, BoundIdentifiers boundIdentifiers, List<Declaration> factDeclarations) {
        Iterator<String> it = unboundIdentifiers.iterator();
        while (it.hasNext()) {
            String identifier = it.next();
            Declaration declaration = PatternBuilder.createDeclarationObject(context, identifier, pattern);
            if (declaration == null) continue;
            factDeclarations.add(declaration);
            if (boundIdentifiers.getDeclarations() == null) {
                boundIdentifiers.setDeclarations(new HashMap<String, Declaration>());
            }
            boundIdentifiers.getDeclarations().put(identifier, declaration);
            boundIdentifiers.getDeclrClasses().put(identifier, declaration.getExtractor().getExtractToClass());
            it.remove();
        }
    }

    private static Declaration createDeclarationObject(RuleBuildContext context, String identifier, Pattern pattern) {
        return PatternBuilder.createDeclarationObject(context, identifier, identifier, pattern);
    }

    private static Declaration createDeclarationObject(RuleBuildContext context, String identifier, String expr, Pattern pattern) {
        BindingDescr implicitBinding = new BindingDescr(identifier, expr);
        Declaration declaration = new Declaration(identifier, null, pattern, true);
        InternalReadAccessor extractor = PatternBuilder.getFieldReadAccessor(context, implicitBinding, pattern.getObjectType(), implicitBinding.getExpression(), (AcceptsReadAccessor)declaration, false);
        if (extractor == null) {
            return null;
        }
        declaration.setReadAccessor(extractor);
        return declaration;
    }

    private FieldValue getFieldValue(RuleBuildContext context, ValueType vtype, LiteralRestrictionDescr literalRestrictionDescr) {
        FieldValue field = null;
        try {
            String value = literalRestrictionDescr.getText().trim();
            MVEL.COMPILER_OPT_ALLOW_NAKED_METH_CALL = true;
            MVEL.COMPILER_OPT_ALLOW_OVERRIDE_ALL_PROPHANDLING = true;
            MVEL.COMPILER_OPT_ALLOW_RESOLVE_INNERCLASSES_WITH_DOTNOTATION = true;
            MVEL.COMPILER_OPT_SUPPORT_JAVA_STYLE_CLASS_LITERALS = true;
            MVELDialectRuntimeData data = (MVELDialectRuntimeData)context.getPkg().getDialectRuntimeRegistry().getDialectData("mvel");
            ParserConfiguration pconf = data.getParserConfiguration();
            ParserContext pctx = new ParserContext(pconf);
            Object o = MVEL.executeExpression((Object)MVEL.compileExpression((String)value, (ParserContext)pctx));
            if (o != null && vtype == null) {
                vtype = ValueType.determineValueType(o.getClass());
            }
            field = FieldFactory.getFieldValue((Object)o, (ValueType)vtype, (DateFormats)context.getPackageBuilder().getDateFormats());
        }
        catch (Exception e) {
            // empty catch block
        }
        return field;
    }

    private ReturnValueRestriction buildRestriction(RuleBuildContext context, Pattern pattern, InternalReadAccessor extractor, ReturnValueRestrictionDescr returnValueRestrictionDescr) {
        Map<String, Class<?>> declarations = PatternBuilder.getDeclarationsMap(returnValueRestrictionDescr, context, true);
        Class thisClass = null;
        if (pattern.getObjectType() instanceof ClassObjectType) {
            thisClass = ((ClassObjectType)pattern.getObjectType()).getClassType();
        }
        Map<String, Class<?>> globals = context.getPackageBuilder().getGlobals();
        AnalysisResult analysis = context.getDialect().analyzeExpression(context, returnValueRestrictionDescr, returnValueRestrictionDescr.getContent(), new BoundIdentifiers(declarations, globals, null, thisClass));
        if (analysis == null) {
            return null;
        }
        BoundIdentifiers usedIdentifiers = analysis.getBoundIdentifiers();
        ArrayList<Declaration> tupleDeclarations = new ArrayList<Declaration>();
        ArrayList<Declaration> factDeclarations = new ArrayList<Declaration>();
        for (String id : usedIdentifiers.getDeclrClasses().keySet()) {
            Declaration decl = context.getDeclarationResolver().getDeclaration(context.getRule(), id);
            if (decl.getPattern() == pattern) {
                factDeclarations.add(decl);
                continue;
            }
            tupleDeclarations.add(decl);
        }
        PatternBuilder.createImplicitBindings(context, pattern, analysis.getNotBoundedIdentifiers(), usedIdentifiers, factDeclarations);
        EvaluatorDefinition.Target right = ConstraintBuilder.getRightTarget(extractor);
        EvaluatorDefinition.Target left = EvaluatorDefinition.Target.FACT;
        Evaluator evaluator = ConstraintBuilder.getEvaluator(context, returnValueRestrictionDescr, extractor.getValueType(), returnValueRestrictionDescr.getEvaluator(), returnValueRestrictionDescr.isNegated(), returnValueRestrictionDescr.getParameterText(), left, right);
        if (evaluator == null) {
            return null;
        }
        Declaration[] previousDeclarations = tupleDeclarations.toArray(new Declaration[tupleDeclarations.size()]);
        Declaration[] localDeclarations = factDeclarations.toArray(new Declaration[factDeclarations.size()]);
        Arrays.sort(previousDeclarations, RuleTerminalNode.SortDeclarations.instance);
        Arrays.sort(localDeclarations, RuleTerminalNode.SortDeclarations.instance);
        String[] requiredGlobals = usedIdentifiers.getGlobals().keySet().toArray(new String[usedIdentifiers.getGlobals().size()]);
        ReturnValueRestriction returnValueRestriction = new ReturnValueRestriction(extractor, previousDeclarations, localDeclarations, requiredGlobals, evaluator);
        ReturnValueBuilder builder = context.getDialect().getReturnValueBuilder();
        builder.build(context, usedIdentifiers, previousDeclarations, localDeclarations, returnValueRestriction, returnValueRestrictionDescr, analysis);
        return returnValueRestriction;
    }

    public static void registerReadAccessor(RuleBuildContext context, ObjectType objectType, String fieldName, AcceptsReadAccessor target) {
        if (!ValueType.FACTTEMPLATE_TYPE.equals((Object)objectType.getValueType())) {
            context.getPkg().getClassFieldAccessorStore().getReader(((ClassObjectType)objectType).getClassName(), fieldName, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InternalReadAccessor getFieldReadAccessor(RuleBuildContext context, BaseDescr descr, ObjectType objectType, String fieldName, AcceptsReadAccessor target, boolean reportError) {
        FactTemplateFieldExtractor reader;
        if (ValueType.FACTTEMPLATE_TYPE.equals((Object)objectType.getValueType())) {
            FactTemplate factTemplate = ((FactTemplateObjectType)objectType).getFactTemplate();
            reader = new FactTemplateFieldExtractor(factTemplate, factTemplate.getFieldTemplateIndex(fieldName));
            if (target != null) {
                target.setReadAccessor((InternalReadAccessor)reader);
            }
        } else if (fieldName.indexOf(46) > -1 || fieldName.indexOf(91) > -1 || fieldName.indexOf(40) > -1) {
            Dialect dialect = context.getDialect();
            try {
                MVELDialect mvelDialect = (MVELDialect)context.getDialect("mvel");
                context.setDialect(mvelDialect);
                Map<String, Class<?>> declarations = PatternBuilder.getDeclarationsMap(descr, context, false);
                Map<String, Class<?>> globals = context.getPackageBuilder().getGlobals();
                AnalysisResult analysis = context.getDialect().analyzeExpression(context, descr, fieldName, new BoundIdentifiers(declarations, globals, null, ((ClassObjectType)objectType).getClassType()));
                if (analysis == null) {
                    if (reportError) {
                        context.addError(new DescrBuildError(context.getParentDescr(), descr, null, "Unable to analyze expression '" + fieldName + "'"));
                    }
                    InternalReadAccessor internalReadAccessor = null;
                    return internalReadAccessor;
                }
                BoundIdentifiers usedIdentifiers = analysis.getBoundIdentifiers();
                if (!usedIdentifiers.getDeclrClasses().isEmpty()) {
                    if (reportError) {
                        context.addError(new DescrBuildError(context.getParentDescr(), descr, null, "Variables can not be used inside bindings. Variable " + usedIdentifiers.getDeclrClasses().keySet() + " is being used in binding '" + fieldName + "'"));
                    }
                    InternalReadAccessor internalReadAccessor = null;
                    return internalReadAccessor;
                }
                reader = context.getPkg().getClassFieldAccessorStore().getMVELReader(context.getPkg().getName(), ((ClassObjectType)objectType).getClassName(), fieldName, context.isTypesafe());
                MVELDialectRuntimeData data = (MVELDialectRuntimeData)context.getPkg().getDialectRuntimeRegistry().getDialectData("mvel");
                ((MVELCompileable)reader).compile(data);
                data.addCompileable((MVELCompileable)reader);
            }
            catch (Exception e) {
                if (reportError) {
                    DialectUtil.copyErrorLocation(e, descr);
                    context.addError(new DescrBuildError(context.getParentDescr(), descr, e, "Unable to create reader for '" + fieldName + "':" + e.getMessage()));
                }
                reader = null;
            }
            finally {
                context.setDialect(dialect);
            }
        } else {
            try {
                reader = context.getPkg().getClassFieldAccessorStore().getReader(((ClassObjectType)objectType).getClassName(), fieldName, target);
            }
            catch (Exception e) {
                if (reportError) {
                    DialectUtil.copyErrorLocation(e, descr);
                    context.addError(new DescrBuildError(context.getParentDescr(), descr, e, "Unable to create Field Extractor for '" + fieldName + "'" + e.getMessage()));
                }
                reader = null;
            }
        }
        return reader;
    }

    private ConstraintConnectiveDescr parseExpression(RuleBuildContext context, PatternDescr patternDescr, BaseDescr original, String expression) {
        DrlExprParser parser = new DrlExprParser();
        ConstraintConnectiveDescr result = parser.parse(expression);
        result.copyLocation(original);
        if (parser.hasErrors()) {
            for (DroolsParserException error : parser.getErrors()) {
                context.addError(new DescrBuildError(context.getParentDescr(), patternDescr, null, "Unable to parser pattern expression:\n" + error.getMessage()));
            }
            return null;
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ExprBindings {
        private Set<String> globalBindings = new HashSet<String>();
        private Set<String> ruleBindings = new HashSet<String>();
        private Set<String> fieldAccessors = new HashSet<String>();

        public Set<String> getGlobalBindings() {
            return this.globalBindings;
        }

        public Set<String> getRuleBindings() {
            return this.ruleBindings;
        }

        public Set<String> getFieldAccessors() {
            return this.fieldAccessors;
        }

        public boolean isConstant() {
            return this.globalBindings.isEmpty() && this.ruleBindings.isEmpty() && this.fieldAccessors.size() <= 1;
        }
    }
}

