/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.journal;

import bitronix.tm.journal.CorruptedTransactionLogException;
import bitronix.tm.journal.TransactionLogRecord;
import bitronix.tm.utils.Uid;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionLogCursor {
    private static final Logger log = LoggerFactory.getLogger(TransactionLogCursor.class);
    private final RandomAccessFile randomAccessFile;
    private long endPosition;

    public TransactionLogCursor(File file) throws IOException {
        this.randomAccessFile = new RandomAccessFile(file, "r");
        this.randomAccessFile.seek(13L);
        this.endPosition = this.randomAccessFile.readLong();
    }

    public TransactionLogRecord readLog() throws IOException {
        return this.readLog(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransactionLogRecord readLog(boolean skipCrcCheck) throws IOException {
        RandomAccessFile randomAccessFile = this.randomAccessFile;
        synchronized (randomAccessFile) {
            long currentPosition = this.randomAccessFile.getFilePointer();
            if (currentPosition >= this.endPosition) {
                if (log.isDebugEnabled()) {
                    log.debug("end of transaction log file reached at " + this.randomAccessFile.getFilePointer());
                }
                return null;
            }
            int status = this.randomAccessFile.readInt();
            int recordLength = this.randomAccessFile.readInt();
            long savedPos = this.randomAccessFile.getFilePointer();
            this.randomAccessFile.skipBytes(recordLength - 4);
            if (this.randomAccessFile.getFilePointer() + 4L > this.endPosition) {
                this.randomAccessFile.skipBytes(4);
                throw new CorruptedTransactionLogException("corrupted log found at position " + currentPosition + " (record terminator outside of file bounds: " + this.randomAccessFile.getFilePointer() + " of " + this.endPosition + ", recordLength: " + recordLength + ")");
            }
            int endCode = this.randomAccessFile.readInt();
            long endOfRecordPosition = this.randomAccessFile.getFilePointer();
            if (endCode != 2020504642) {
                throw new CorruptedTransactionLogException("corrupted log found at position " + currentPosition + " (no record terminator found)");
            }
            this.randomAccessFile.seek(savedPos);
            int headerLength = this.randomAccessFile.readInt();
            long time = this.randomAccessFile.readLong();
            int sequenceNumber = this.randomAccessFile.readInt();
            int crc32 = this.randomAccessFile.readInt();
            byte gtridSize = this.randomAccessFile.readByte();
            if (21 + gtridSize > recordLength) {
                this.randomAccessFile.seek(endOfRecordPosition);
                throw new CorruptedTransactionLogException("corrupted log found at position " + currentPosition + " (GTRID size too long)");
            }
            byte[] gtridArray = new byte[gtridSize];
            this.randomAccessFile.readFully(gtridArray);
            Uid gtrid = new Uid(gtridArray);
            int uniqueNamesCount = this.randomAccessFile.readInt();
            HashSet<String> uniqueNames = new HashSet<String>();
            int currentReadCount = 21 + gtridSize + 4;
            for (int i = 0; i < uniqueNamesCount; ++i) {
                short length = this.randomAccessFile.readShort();
                if ((currentReadCount += 2 + length) > recordLength) {
                    this.randomAccessFile.seek(endOfRecordPosition);
                    throw new CorruptedTransactionLogException("corrupted log found at position " + currentPosition + " (unique names too long, " + (i + 1) + " out of " + uniqueNamesCount + ", length: " + length + ", currentReadCount: " + currentReadCount + ", recordLength: " + recordLength + ")");
                }
                byte[] nameBytes = new byte[length];
                this.randomAccessFile.readFully(nameBytes);
                uniqueNames.add(new String(nameBytes, "US-ASCII"));
            }
            int cEndRecord = this.randomAccessFile.readInt();
            TransactionLogRecord tlog = new TransactionLogRecord(status, recordLength, headerLength, time, sequenceNumber, crc32, gtrid, uniqueNames, cEndRecord);
            if (!skipCrcCheck && !tlog.isCrc32Correct()) {
                this.randomAccessFile.seek(endOfRecordPosition);
                throw new CorruptedTransactionLogException("corrupted log found at position " + currentPosition + "(invalid CRC, recorded: " + tlog.getCrc32() + ", calculated: " + tlog.calculateCrc32() + ")");
            }
            return tlog;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        RandomAccessFile randomAccessFile = this.randomAccessFile;
        synchronized (randomAccessFile) {
            this.randomAccessFile.close();
        }
    }
}

