/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.resource.jdbc;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public abstract class BaseProxyHandlerClass
implements InvocationHandler {
    private static Map classMethodCache = new HashMap();
    private Map methodCache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseProxyHandlerClass() {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            this.methodCache = (Map)classMethodCache.get(this.getClass());
            if (this.methodCache == null) {
                this.methodCache = new HashMap();
                classMethodCache.put(this.getClass(), this.methodCache);
            }
        }
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            Method delegatedMethod = this.getDelegatedMethod(method);
            return delegatedMethod.invoke(this.isOurMethod(delegatedMethod) ? this : this.getProxiedDelegate(), args);
        }
        catch (InvocationTargetException ite) {
            throw ite.getTargetException();
        }
    }

    private synchronized Method getDelegatedMethod(Method method) {
        Method delegated = (Method)this.methodCache.get(method);
        if (delegated != null) {
            return delegated;
        }
        try {
            Class<?>[] parameterTypes = method.getParameterTypes();
            delegated = this.getClass().getMethod(method.getName(), parameterTypes);
        }
        catch (Exception e) {
            delegated = method;
        }
        this.methodCache.put(method, delegated);
        return delegated;
    }

    private boolean isOurMethod(Method method) {
        return this.getClass().equals(method.getDeclaringClass());
    }

    public abstract Object getProxiedDelegate() throws Exception;
}

