/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.utils;

import bitronix.tm.TransactionManagerServices;
import bitronix.tm.internal.BitronixRuntimeException;
import bitronix.tm.utils.ClassLoaderUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagementRegistrar {
    private static final Logger log;
    private static Object mbeanServer;
    private static Method registerMBeanMethod;
    private static Method unregisterMBeanMethod;
    private static Constructor objectNameConstructor;

    public static String makeValidName(String name) {
        return name.replaceAll("[\\:\\,\\=,\\.]", "_");
    }

    public static void register(String name, Object obj) {
        if (mbeanServer == null) {
            return;
        }
        try {
            Object objName = ManagementRegistrar.buildObjectName(name);
            ManagementRegistrar.mbeanServerCall(registerMBeanMethod, new Object[]{obj, objName});
        }
        catch (Exception ex) {
            log.warn("cannot register object with name " + name, (Throwable)ex);
        }
    }

    public static void unregister(String name) {
        if (mbeanServer == null) {
            return;
        }
        try {
            Object objName = ManagementRegistrar.buildObjectName(name);
            ManagementRegistrar.mbeanServerCall(unregisterMBeanMethod, new Object[]{objName});
        }
        catch (Exception ex) {
            log.warn("cannot unregister object with name " + name, (Throwable)ex);
        }
    }

    private static Object buildObjectName(String name) {
        try {
            return objectNameConstructor.newInstance(name);
        }
        catch (Exception ex) {
            throw new BitronixRuntimeException("cannot build ObjectName with name=" + name, ex);
        }
    }

    private static void mbeanServerCall(Method method, Object[] params) {
        try {
            method.invoke(mbeanServer, params);
        }
        catch (Exception ex) {
            throw new BitronixRuntimeException("cannot call method '" + method.getName() + "'", ex);
        }
    }

    static {
        boolean enableJmx;
        log = LoggerFactory.getLogger(ManagementRegistrar.class);
        boolean bl = enableJmx = !TransactionManagerServices.getConfiguration().isDisableJmx();
        if (enableJmx) {
            try {
                Class managementFactoryClass = ClassLoaderUtils.loadClass("java.lang.management.ManagementFactory");
                Method getPlatformMBeanServerMethod = managementFactoryClass.getMethod("getPlatformMBeanServer", null);
                mbeanServer = getPlatformMBeanServerMethod.invoke((Object)managementFactoryClass, (Object[])null);
                Class objectNameClass = ClassLoaderUtils.loadClass("javax.management.ObjectName");
                objectNameConstructor = objectNameClass.getConstructor(String.class);
                registerMBeanMethod = mbeanServer.getClass().getMethod("registerMBean", Object.class, objectNameClass);
                unregisterMBeanMethod = mbeanServer.getClass().getMethod("unregisterMBean", objectNameClass);
            }
            catch (Exception ex) {
                mbeanServer = null;
            }
        }
    }
}

