/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.audit;

import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import org.drools.WorkingMemory;
import org.drools.audit.WorkingMemoryLogger;
import org.drools.audit.event.LogEvent;
import org.drools.audit.event.RuleFlowLogEvent;
import org.drools.audit.event.RuleFlowNodeLogEvent;
import org.drools.audit.event.RuleFlowVariableLogEvent;
import org.drools.event.KnowledgeRuntimeEventManager;
import org.drools.impl.StatelessKnowledgeSessionImpl;
import org.drools.runtime.Environment;
import org.drools.runtime.KnowledgeRuntime;
import org.jbpm.process.audit.NodeInstanceLog;
import org.jbpm.process.audit.ProcessInstanceLog;
import org.jbpm.process.audit.VariableInstanceLog;

public class JPAWorkingMemoryDbLogger
extends WorkingMemoryLogger {
    protected Environment env;

    public JPAWorkingMemoryDbLogger(WorkingMemory workingMemory) {
        super(workingMemory);
        this.env = workingMemory.getEnvironment();
    }

    public JPAWorkingMemoryDbLogger(KnowledgeRuntimeEventManager session) {
        super(session);
        if (session instanceof KnowledgeRuntime) {
            this.env = ((KnowledgeRuntime)session).getEnvironment();
        } else if (session instanceof StatelessKnowledgeSessionImpl) {
            this.env = ((StatelessKnowledgeSessionImpl)session).getEnvironment();
        } else {
            throw new IllegalArgumentException("Not supported session in logger: " + session.getClass());
        }
    }

    public void logEventCreated(LogEvent logEvent) {
        switch (logEvent.getType()) {
            case 8: {
                RuleFlowLogEvent processEvent = (RuleFlowLogEvent)logEvent;
                this.addProcessLog(processEvent.getProcessInstanceId(), processEvent.getProcessId());
                break;
            }
            case 11: {
                RuleFlowLogEvent processEvent = (RuleFlowLogEvent)logEvent;
                this.updateProcessLog(processEvent.getProcessInstanceId());
                break;
            }
            case 24: {
                RuleFlowNodeLogEvent nodeEvent = (RuleFlowNodeLogEvent)logEvent;
                this.addNodeEnterLog(nodeEvent.getProcessInstanceId(), nodeEvent.getProcessId(), nodeEvent.getNodeInstanceId(), nodeEvent.getNodeId(), nodeEvent.getNodeName());
                break;
            }
            case 26: {
                RuleFlowNodeLogEvent nodeEvent = (RuleFlowNodeLogEvent)logEvent;
                this.addNodeExitLog(nodeEvent.getProcessInstanceId(), nodeEvent.getProcessId(), nodeEvent.getNodeInstanceId(), nodeEvent.getNodeId(), nodeEvent.getNodeName());
                break;
            }
            case 33: {
                RuleFlowVariableLogEvent variableEvent = (RuleFlowVariableLogEvent)logEvent;
                this.addVariableLog(variableEvent.getProcessInstanceId(), variableEvent.getProcessId(), variableEvent.getVariableInstanceId(), variableEvent.getVariableId(), variableEvent.getObjectToString());
                break;
            }
        }
    }

    private void addProcessLog(long processInstanceId, String processId) {
        ProcessInstanceLog log = new ProcessInstanceLog(processInstanceId, processId);
        this.getEntityManager().persist((Object)log);
    }

    private void updateProcessLog(long processInstanceId) {
        List result = this.getEntityManager().createQuery("from ProcessInstanceLog as log where log.processInstanceId = ? and log.end is null").setParameter(1, (Object)processInstanceId).getResultList();
        if (result != null && result.size() != 0) {
            ProcessInstanceLog log = (ProcessInstanceLog)result.get(result.size() - 1);
            log.setEnd(new Date());
            this.getEntityManager().merge((Object)log);
        }
    }

    private void addNodeEnterLog(long processInstanceId, String processId, String nodeInstanceId, String nodeId, String nodeName) {
        NodeInstanceLog log = new NodeInstanceLog(0, processInstanceId, processId, nodeInstanceId, nodeId, nodeName);
        this.getEntityManager().persist((Object)log);
    }

    private void addNodeExitLog(long processInstanceId, String processId, String nodeInstanceId, String nodeId, String nodeName) {
        NodeInstanceLog log = new NodeInstanceLog(1, processInstanceId, processId, nodeInstanceId, nodeId, nodeName);
        this.getEntityManager().persist((Object)log);
    }

    private void addVariableLog(long processInstanceId, String processId, String variableInstanceId, String variableId, String objectToString) {
        VariableInstanceLog log = new VariableInstanceLog(processInstanceId, processId, variableInstanceId, variableId, objectToString);
        this.getEntityManager().persist((Object)log);
    }

    public void dispose() {
    }

    protected EntityManager getEntityManager() {
        return (EntityManager)this.env.get("drools.persistence.jpa.CmdScopedEntityManager");
    }
}

