/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.jpa;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.FlushModeType;
import org.drools.persistence.PersistenceContext;
import org.drools.persistence.PersistenceContextManager;
import org.drools.persistence.jpa.JpaPersistenceContext;
import org.drools.runtime.Environment;

public class JpaPersistenceContextManager
implements PersistenceContextManager {
    Environment env;
    private EntityManagerFactory emf;
    private EntityManager appScopedEntityManager;
    protected EntityManager cmdScopedEntityManager;
    private boolean internalAppScopedEntityManager;
    private boolean internalCmdScopedEntityManager;

    public JpaPersistenceContextManager(Environment env) {
        this.env = env;
        this.emf = (EntityManagerFactory)env.get("drools.persistence.jpa.EntityManagerFactory");
    }

    public PersistenceContext getApplicationScopedPersistenceContext() {
        if (this.appScopedEntityManager == null) {
            this.appScopedEntityManager = (EntityManager)this.env.get("drools.persistence.jpa.AppScopedEntityManager");
            if (this.appScopedEntityManager != null && !this.appScopedEntityManager.isOpen()) {
                throw new RuntimeException("Provided APP_SCOPED_ENTITY_MANAGER is not open");
            }
            if (this.appScopedEntityManager == null) {
                this.internalAppScopedEntityManager = true;
                this.appScopedEntityManager = this.emf.createEntityManager();
                this.env.set("drools.persistence.jpa.AppScopedEntityManager", (Object)this.appScopedEntityManager);
            } else {
                this.internalAppScopedEntityManager = false;
            }
        }
        return new JpaPersistenceContext(this.appScopedEntityManager);
    }

    public PersistenceContext getCommandScopedPersistenceContext() {
        return new JpaPersistenceContext(this.cmdScopedEntityManager);
    }

    public void beginCommandScopedEntityManager() {
        EntityManager cmdScopedEntityManager = (EntityManager)this.env.get("drools.persistence.jpa.CmdScopedEntityManager");
        if (cmdScopedEntityManager == null || this.cmdScopedEntityManager != null && !this.cmdScopedEntityManager.isOpen()) {
            this.internalCmdScopedEntityManager = true;
            this.cmdScopedEntityManager = this.emf.createEntityManager();
            this.cmdScopedEntityManager.setFlushMode(FlushModeType.COMMIT);
            this.env.set("drools.persistence.jpa.CmdScopedEntityManager", (Object)this.cmdScopedEntityManager);
            cmdScopedEntityManager = this.cmdScopedEntityManager;
        } else {
            this.internalCmdScopedEntityManager = false;
        }
        cmdScopedEntityManager.joinTransaction();
        this.appScopedEntityManager.joinTransaction();
    }

    public void endCommandScopedEntityManager() {
        if (this.internalCmdScopedEntityManager) {
            this.env.set("drools.persistence.jpa.CmdScopedEntityManager", null);
        }
    }

    public void dispose() {
        if (this.internalAppScopedEntityManager) {
            if (this.appScopedEntityManager != null && this.appScopedEntityManager.isOpen()) {
                this.appScopedEntityManager.close();
            }
            this.internalAppScopedEntityManager = false;
            this.env.set("drools.persistence.jpa.AppScopedEntityManager", null);
            this.appScopedEntityManager = null;
        }
        if (this.internalCmdScopedEntityManager) {
            if (this.cmdScopedEntityManager != null && this.cmdScopedEntityManager.isOpen()) {
                this.cmdScopedEntityManager.close();
            }
            this.internalCmdScopedEntityManager = false;
            this.env.set("drools.persistence.jpa.CmdScopedEntityManager", null);
            this.cmdScopedEntityManager = null;
        }
    }
}

