/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.api.core;

import java.io.Serializable;
import java.util.ArrayList;
import org.hornetq.core.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleString
implements CharSequence,
Serializable,
Comparable<SimpleString> {
    private static final long serialVersionUID = 4204223851422244307L;
    private static final Logger log = Logger.getLogger(SimpleString.class);
    private final byte[] data;
    private transient int hash;
    private transient String str;

    public static SimpleString toSimpleString(String string) {
        if (string == null) {
            return null;
        }
        return new SimpleString(string);
    }

    public SimpleString(String string) {
        int len = string.length();
        this.data = new byte[len << 1];
        int j = 0;
        for (int i = 0; i < len; ++i) {
            char c = string.charAt(i);
            byte low = (byte)(c & 0xFF);
            this.data[j++] = low;
            byte high = (byte)(c >> 8 & 0xFF);
            this.data[j++] = high;
        }
        this.str = string;
    }

    public SimpleString(byte[] data) {
        this.data = data;
    }

    @Override
    public int length() {
        return this.data.length >> 1;
    }

    @Override
    public char charAt(int pos) {
        if (pos < 0 || pos >= this.data.length >> 1) {
            throw new IndexOutOfBoundsException();
        }
        return (char)(this.data[pos <<= 1] | this.data[pos + 1] << 8);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        int len = this.data.length >> 1;
        if (end < start || start < 0 || end > len) {
            throw new IndexOutOfBoundsException();
        }
        int newlen = end - start << 1;
        byte[] bytes = new byte[newlen];
        System.arraycopy(this.data, start << 1, bytes, 0, newlen);
        return new SimpleString(bytes);
    }

    @Override
    public int compareTo(SimpleString o) {
        return this.toString().compareTo(o.toString());
    }

    public byte[] getData() {
        return this.data;
    }

    public boolean startsWith(SimpleString other) {
        byte[] otherdata = other.data;
        if (otherdata.length > this.data.length) {
            return false;
        }
        for (int i = 0; i < otherdata.length; ++i) {
            if (this.data[i] == otherdata[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        if (this.str == null) {
            int len = this.data.length >> 1;
            char[] chars = new char[len];
            int j = 0;
            for (int i = 0; i < len; ++i) {
                int low = this.data[j++] & 0xFF;
                int high = this.data[j++] << 8 & 0xFF00;
                chars[i] = (char)(low | high);
            }
            this.str = new String(chars);
        }
        return this.str;
    }

    public boolean equals(Object other) {
        if (other instanceof SimpleString) {
            SimpleString s = (SimpleString)other;
            if (this.data.length != s.data.length) {
                return false;
            }
            for (int i = 0; i < this.data.length; ++i) {
                if (this.data[i] == s.data[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        if (this.hash == 0) {
            int tmphash = 0;
            for (byte element : this.data) {
                tmphash = (tmphash << 5) - tmphash + element;
            }
            this.hash = tmphash;
        }
        return this.hash;
    }

    public SimpleString[] split(char delim) {
        if (!this.contains(delim)) {
            return new SimpleString[]{this};
        }
        ArrayList<SimpleString> all = new ArrayList<SimpleString>();
        int lasPos = 0;
        for (int i = 0; i < this.data.length; i += 2) {
            byte low = (byte)(delim & 0xFF);
            byte high = (byte)(delim >> 8 & 0xFF);
            if (this.data[i] != low || this.data[i + 1] != high) continue;
            byte[] bytes = new byte[i - lasPos];
            System.arraycopy(this.data, lasPos, bytes, 0, bytes.length);
            lasPos = i + 2;
            all.add(new SimpleString(bytes));
        }
        byte[] bytes = new byte[this.data.length - lasPos];
        System.arraycopy(this.data, lasPos, bytes, 0, bytes.length);
        all.add(new SimpleString(bytes));
        SimpleString[] parts = new SimpleString[all.size()];
        return all.toArray(parts);
    }

    public boolean contains(char c) {
        for (int i = 0; i < this.data.length; i += 2) {
            byte low = (byte)(c & 0xFF);
            byte high = (byte)(c >> 8 & 0xFF);
            if (this.data[i] != low || this.data[i + 1] != high) continue;
            return true;
        }
        return false;
    }

    public SimpleString concat(String toAdd) {
        return this.concat(new SimpleString(toAdd));
    }

    public SimpleString concat(SimpleString toAdd) {
        byte[] bytes = new byte[this.data.length + toAdd.getData().length];
        System.arraycopy(this.data, 0, bytes, 0, this.data.length);
        System.arraycopy(toAdd.getData(), 0, bytes, this.data.length, toAdd.getData().length);
        return new SimpleString(bytes);
    }

    public SimpleString concat(char c) {
        byte[] bytes = new byte[this.data.length + 2];
        System.arraycopy(this.data, 0, bytes, 0, this.data.length);
        bytes[this.data.length] = (byte)(c & 0xFF);
        bytes[this.data.length + 1] = (byte)(c >> 8 & 0xFF);
        return new SimpleString(bytes);
    }

    public int sizeof() {
        return 4 + this.data.length;
    }

    public static int sizeofString(SimpleString str) {
        return str.sizeof();
    }

    public static int sizeofNullableString(SimpleString str) {
        if (str == null) {
            return 1;
        }
        return 1 + str.sizeof();
    }

    public void getChars(int srcBegin, int srcEnd, char[] dst, int dstBegin) {
        if (srcBegin < 0) {
            throw new StringIndexOutOfBoundsException(srcBegin);
        }
        if (srcEnd > this.length()) {
            throw new StringIndexOutOfBoundsException(srcEnd);
        }
        if (srcBegin > srcEnd) {
            throw new StringIndexOutOfBoundsException(srcEnd - srcBegin);
        }
        int j = 0;
        for (int i = srcBegin; i < srcEnd - srcBegin; ++i) {
            int low = this.data[j++] & 0xFF;
            int high = this.data[j++] << 8 & 0xFF00;
            dst[i] = (char)(low | high);
        }
    }
}

