/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.api.core.client;

import java.util.List;
import org.hornetq.api.core.Pair;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.api.core.client.ClientSessionFactory;
import org.hornetq.api.core.client.loadbalance.RoundRobinConnectionLoadBalancingPolicy;
import org.hornetq.core.client.impl.ClientSessionFactoryImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HornetQClient {
    public static final String DEFAULT_CONNECTION_LOAD_BALANCING_POLICY_CLASS_NAME = RoundRobinConnectionLoadBalancingPolicy.class.getCanonicalName();
    public static final long DEFAULT_CLIENT_FAILURE_CHECK_PERIOD = 30000L;
    public static final long DEFAULT_CONNECTION_TTL = 60000L;
    public static final int DEFAULT_MIN_LARGE_MESSAGE_SIZE = 102400;
    public static final int DEFAULT_CONSUMER_WINDOW_SIZE = 0x100000;
    public static final int DEFAULT_CONSUMER_MAX_RATE = -1;
    public static final int DEFAULT_CONFIRMATION_WINDOW_SIZE = -1;
    public static final int DEFAULT_PRODUCER_WINDOW_SIZE = 0x100000;
    public static final int DEFAULT_PRODUCER_MAX_RATE = -1;
    public static final boolean DEFAULT_BLOCK_ON_ACKNOWLEDGE = false;
    public static final boolean DEFAULT_BLOCK_ON_DURABLE_SEND = true;
    public static final boolean DEFAULT_BLOCK_ON_NON_DURABLE_SEND = false;
    public static final boolean DEFAULT_AUTO_GROUP = false;
    public static final long DEFAULT_CALL_TIMEOUT = 30000L;
    public static final int DEFAULT_ACK_BATCH_SIZE = 0x100000;
    public static final boolean DEFAULT_PRE_ACKNOWLEDGE = false;
    public static final long DEFAULT_DISCOVERY_INITIAL_WAIT_TIMEOUT = 2000L;
    public static final long DEFAULT_DISCOVERY_REFRESH_TIMEOUT = 10000L;
    public static final long DEFAULT_RETRY_INTERVAL = 2000L;
    public static final double DEFAULT_RETRY_INTERVAL_MULTIPLIER = 1.0;
    public static final long DEFAULT_MAX_RETRY_INTERVAL = 2000L;
    public static final int DEFAULT_RECONNECT_ATTEMPTS = 0;
    public static final boolean DEFAULT_FAILOVER_ON_SERVER_SHUTDOWN = false;
    public static final boolean DEFAULT_USE_GLOBAL_POOLS = true;
    public static final int DEFAULT_THREAD_POOL_MAX_SIZE = -1;
    public static final int DEFAULT_SCHEDULED_THREAD_POOL_MAX_SIZE = 5;
    public static final boolean DEFAULT_CACHE_LARGE_MESSAGE_CLIENT = false;
    public static final int DEFAULT_INITIAL_MESSAGE_PACKET_SIZE = 1500;

    public static ClientSessionFactory createClientSessionFactory() {
        return new ClientSessionFactoryImpl();
    }

    public static ClientSessionFactory createClientSessionFactory(ClientSessionFactory other) {
        return new ClientSessionFactoryImpl(other);
    }

    public static ClientSessionFactory createClientSessionFactory(String discoveryAddress, int discoveryPort) {
        return new ClientSessionFactoryImpl(discoveryAddress, discoveryPort);
    }

    public static ClientSessionFactory createClientSessionFactory(List<Pair<TransportConfiguration, TransportConfiguration>> staticConnectors) {
        return new ClientSessionFactoryImpl(staticConnectors);
    }

    public static ClientSessionFactory createClientSessionFactory(TransportConfiguration connectorConfig, TransportConfiguration backupConnectorConfig) {
        return new ClientSessionFactoryImpl(connectorConfig, backupConnectorConfig);
    }

    public static ClientSessionFactory createClientSessionFactory(TransportConfiguration connectorConfig) {
        return new ClientSessionFactoryImpl(connectorConfig);
    }

    private HornetQClient() {
    }
}

