/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.api.jms.management;

import java.util.Map;
import org.hornetq.api.core.management.Operation;
import org.hornetq.api.core.management.Parameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface JMSServerControl {
    public boolean isStarted();

    public String getVersion();

    public String[] getTopicNames();

    public String[] getQueueNames();

    public String[] getConnectionFactoryNames();

    @Operation(desc="Create a JMS Queue", impact=1)
    public boolean createQueue(@Parameter(name="name", desc="Name of the queue to create") String var1, @Parameter(name="jndiBinding", desc="the name of the binding for JNDI") String var2) throws Exception;

    @Operation(desc="Destroy a JMS Queue", impact=1)
    public boolean destroyQueue(@Parameter(name="name", desc="Name of the queue to destroy") String var1) throws Exception;

    @Operation(desc="Create a JMS Topic", impact=1)
    public boolean createTopic(@Parameter(name="name", desc="Name of the topic to create") String var1, @Parameter(name="jndiBinding", desc="the name of the binding for JNDI") String var2) throws Exception;

    @Operation(desc="Destroy a JMS Topic", impact=1)
    public boolean destroyTopic(@Parameter(name="name", desc="Name of the topic to destroy") String var1) throws Exception;

    public void createConnectionFactory(String var1, Object[] var2, Object[] var3, Object[] var4, Object[] var5, Object[] var6) throws Exception;

    @Operation(desc="Create a JMS ConnectionFactory", impact=1)
    public void createConnectionFactory(@Parameter(name="name") String var1, @Parameter(name="liveTransportClassNames", desc="comma-separated list of class names for transport to live servers") String var2, @Parameter(name="liveTransportParams", desc="comma-separated list of key=value parameters for the live transports (enclosed between { } for each transport)") String var3, @Parameter(name="backupTransportClassNames", desc="comma-separated list of class names for transport to backup servers") String var4, @Parameter(name="backupTransportParams", desc="comma-separated list of key=value parameters for the backup transports (enclosed between { } for each transport)") String var5, @Parameter(name="jndiBindings", desc="comma-separated list of JNDI bindings") String var6) throws Exception;

    public void createConnectionFactory(String var1, Object[] var2, Object[] var3, Object[] var4, Object[] var5, String var6, Object[] var7) throws Exception;

    @Operation(desc="Create a JMS ConnectionFactory", impact=1)
    public void createConnectionFactory(@Parameter(name="name") String var1, @Parameter(name="liveTransportClassNames", desc="comma-separated list of class names for transport to live servers") String var2, @Parameter(name="liveTransportParams", desc="comma-separated list of key=value parameters for the live transports (enclosed between { } for each transport)") String var3, @Parameter(name="backupTransportClassNames", desc="comma-separated list of class names for transport to backup servers") String var4, @Parameter(name="backupTransportParams", desc="comma-separated list of key=value parameters for the backup transports (enclosed between { } for each transport)") String var5, @Parameter(name="clientID") String var6, @Parameter(name="jndiBindings", desc="comma-separated list of JNDI bindings") String var7) throws Exception;

    public void createConnectionFactory(String var1, Object[] var2, Object[] var3, Object[] var4, Object[] var5, String var6, long var7, long var9, long var11, boolean var13, int var14, int var15, int var16, int var17, int var18, int var19, boolean var20, boolean var21, boolean var22, boolean var23, boolean var24, String var25, int var26, int var27, boolean var28, int var29, int var30, long var31, double var33, long var35, int var37, boolean var38, String var39, Object[] var40) throws Exception;

    public void createConnectionFactory(@Parameter(name="name") String var1, @Parameter(name="liveTransportClassNames", desc="comma-separated list of class names for transport to live servers") String var2, @Parameter(name="liveTransportParams", desc="comma-separated list of key=value parameters for the live transports (enclosed between { } for each transport)") String var3, @Parameter(name="backupTransportClassNames", desc="comma-separated list of class names for transport to backup servers") String var4, @Parameter(name="backupTransportParams", desc="comma-separated list of key=value parameters for the backup transports (enclosed between { } for each transport)") String var5, @Parameter(name="clientID") String var6, @Parameter(name="clientFailureCheckPeriod") long var7, @Parameter(name="connectionTTL") long var9, @Parameter(name="callTimeout") long var11, @Parameter(name="cacheLargemessageClient") boolean var13, @Parameter(name="minLargeMessageSize") int var14, @Parameter(name="consumerWindowSize") int var15, @Parameter(name="consumerMaxRate") int var16, @Parameter(name="confirmationWindowSize") int var17, @Parameter(name="producerWindowSize") int var18, @Parameter(name="producerMaxRate") int var19, @Parameter(name="blockOnAcknowledge") boolean var20, @Parameter(name="blockOnDurableSend") boolean var21, @Parameter(name="blockOnNonDurableSend") boolean var22, @Parameter(name="autoGroup") boolean var23, @Parameter(name="preAcknowledge") boolean var24, @Parameter(name="loadBalancingPolicyClassName") String var25, @Parameter(name="transactionBatchSize") int var26, @Parameter(name="dupsOKBatchSize") int var27, @Parameter(name="useGlobalPools") boolean var28, @Parameter(name="scheduledThreadPoolMaxSize") int var29, @Parameter(name="threadPoolMaxSize") int var30, @Parameter(name="retryInterval") long var31, @Parameter(name="retryIntervalMultiplier") double var33, @Parameter(name="maxRetryInterval") long var35, @Parameter(name="reconnectAttempts") int var37, @Parameter(name="failoverOnServerShutdown") boolean var38, @Parameter(name="groupID") String var39, @Parameter(name="jndiBindings", desc="comma-separated list of JNDI bindings") String var40) throws Exception;

    public void createConnectionFactory(String var1, String var2, int var3, String var4, Object[] var5) throws Exception;

    @Operation(desc="Create a JMS ConnectionFactory", impact=1)
    public void createConnectionFactory(@Parameter(name="name") String var1, @Parameter(name="discoveryAddress") String var2, @Parameter(name="discoveryPort") int var3, @Parameter(name="clientID") String var4, @Parameter(name="jndiBindings") String var5) throws Exception;

    public void createConnectionFactory(String var1, String var2, int var3, String var4, long var5, long var7, long var9, long var11, boolean var13, int var14, int var15, int var16, int var17, int var18, int var19, boolean var20, boolean var21, boolean var22, boolean var23, boolean var24, String var25, int var26, int var27, long var28, boolean var30, int var31, int var32, long var33, double var35, long var37, int var39, boolean var40, String var41, Object[] var42) throws Exception;

    @Operation(desc="Create a JMS ConnectionFactory", impact=1)
    public void createConnectionFactory(@Parameter(name="name") String var1, @Parameter(name="discoveryAddress") String var2, @Parameter(name="discoveryPort") int var3, @Parameter(name="clientID") String var4, @Parameter(name="discoveryRefreshTimeout") long var5, @Parameter(name="clientFailureCheckPeriod") long var7, @Parameter(name="connectionTTL") long var9, @Parameter(name="callTimeout") long var11, @Parameter(name="cacheLargemessageClient") boolean var13, @Parameter(name="minLargeMessageSize") int var14, @Parameter(name="consumerWindowSize") int var15, @Parameter(name="consumerMaxRate") int var16, @Parameter(name="confirmationWindowSize") int var17, @Parameter(name="producerWindowSize") int var18, @Parameter(name="producerMaxRate") int var19, @Parameter(name="blockOnAcknowledge") boolean var20, @Parameter(name="blockOnDurableSend") boolean var21, @Parameter(name="blockOnNonDurableSend") boolean var22, @Parameter(name="autoGroup") boolean var23, @Parameter(name="preAcknowledge") boolean var24, @Parameter(name="loadBalancingPolicyClassName") String var25, @Parameter(name="transactionBatchSize") int var26, @Parameter(name="dupsOKBatchSize") int var27, @Parameter(name="initialWaitTimeout") long var28, @Parameter(name="useGlobalPools") boolean var30, @Parameter(name="scheduledThreadPoolMaxSize") int var31, @Parameter(name="threadPoolMaxSize") int var32, @Parameter(name="retryInterval") long var33, @Parameter(name="retryIntervalMultiplier") double var35, @Parameter(name="maxRetryInterval") long var37, @Parameter(name="reconnectAttempts") int var39, @Parameter(name="failoverOnServerShutdown") boolean var40, @Parameter(name="groupID") String var41, @Parameter(name="jndiBindings", desc="comma-separated list of JNDI bindings") String var42) throws Exception;

    public void createConnectionFactory(String var1, String var2, Map<String, Object> var3, Object[] var4) throws Exception;

    @Operation(desc="Create a JMS ConnectionFactory", impact=1)
    public void createConnectionFactory(@Parameter(name="name") String var1, @Parameter(name="liveTransportClassName") String var2, @Parameter(name="liveTransportParams", desc="comma-separated list of key=value for the transport parameters") String var3, @Parameter(name="jndiBindings", desc="comma-separated list of JNDI bindings") String var4) throws Exception;

    public void createConnectionFactory(String var1, String var2, Map<String, Object> var3, String var4, Object[] var5) throws Exception;

    @Operation(desc="Create a JMS ConnectionFactory", impact=1)
    public void createConnectionFactory(@Parameter(name="name") String var1, @Parameter(name="liveTransportClassName") String var2, @Parameter(name="liveTransportParams", desc="comma-separated list of key=value for the transport parameters") String var3, @Parameter(name="clientID") String var4, @Parameter(name="jndiBindings", desc="comma-separated list of JNDI bindings") String var5) throws Exception;

    public void createConnectionFactory(String var1, String var2, Map<String, Object> var3, String var4, Map<String, Object> var5, Object[] var6) throws Exception;

    public void createConnectionFactory(String var1, String var2, Map<String, Object> var3, String var4, Map<String, Object> var5, String var6, Object[] var7) throws Exception;

    @Operation(desc="Destroy a JMS ConnectionFactory", impact=1)
    public void destroyConnectionFactory(@Parameter(name="name", desc="Name of the ConnectionFactory to destroy") String var1) throws Exception;

    @Operation(desc="List the client addresses", impact=0)
    public String[] listRemoteAddresses() throws Exception;

    @Operation(desc="List the client addresses which match the given IP Address", impact=0)
    public String[] listRemoteAddresses(@Parameter(desc="an IP address", name="ipAddress") String var1) throws Exception;

    @Operation(desc="Closes all the connections for the given IP Address", impact=0)
    public boolean closeConnectionsForAddress(@Parameter(desc="an IP address", name="ipAddress") String var1) throws Exception;

    @Operation(desc="List all the connection IDs", impact=0)
    public String[] listConnectionIDs() throws Exception;

    @Operation(desc="List the sessions for the given connectionID", impact=0)
    public String[] listSessions(@Parameter(desc="a connection ID", name="connectionID") String var1) throws Exception;
}

