/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.client.impl;

import java.util.concurrent.Semaphore;
import org.hornetq.api.core.SimpleString;
import org.hornetq.core.client.impl.ClientProducerCredits;
import org.hornetq.core.client.impl.ClientSessionInternal;
import org.hornetq.core.logging.Logger;

public class ClientProducerCreditsImpl
implements ClientProducerCredits {
    private static final Logger log = Logger.getLogger(ClientProducerCreditsImpl.class);
    private final Semaphore semaphore;
    private final int windowSize;
    private final SimpleString address;
    private final ClientSessionInternal session;
    private int arriving;
    private int refCount;

    public ClientProducerCreditsImpl(ClientSessionInternal session, SimpleString address, int windowSize) {
        this.session = session;
        this.address = address;
        this.windowSize = windowSize / 2;
        this.semaphore = new Semaphore(0, false);
        this.checkCredits(windowSize);
    }

    public void acquireCredits(int credits) throws InterruptedException {
        this.checkCredits(credits);
        this.semaphore.acquire(credits);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveCredits(int credits, int offset) {
        ClientProducerCreditsImpl clientProducerCreditsImpl = this;
        synchronized (clientProducerCreditsImpl) {
            this.arriving -= credits;
        }
        this.semaphore.release(credits);
    }

    public synchronized void reset() {
        this.semaphore.drainPermits();
        this.arriving = 0;
        this.checkCredits(this.windowSize * 2);
    }

    public void close() {
        this.semaphore.release(0x3FFFFFFF);
    }

    public synchronized void incrementRefCount() {
        ++this.refCount;
    }

    public synchronized int decrementRefCount() {
        return --this.refCount;
    }

    public synchronized void releaseOutstanding() {
        int permits = this.semaphore.drainPermits();
        this.session.sendProducerCreditsMessage(permits, this.address);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkCredits(int credits) {
        int needed = Math.max(credits, this.windowSize);
        int toRequest = -1;
        ClientProducerCreditsImpl clientProducerCreditsImpl = this;
        synchronized (clientProducerCreditsImpl) {
            if (this.semaphore.availablePermits() + this.arriving < needed) {
                toRequest = needed - this.arriving;
                this.arriving += toRequest;
            }
        }
        if (toRequest != -1) {
            this.requestCredits(toRequest);
        }
    }

    private void requestCredits(int credits) {
        this.session.sendProducerCreditsMessage(credits, this.address);
    }
}

