/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.config.impl;

import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import org.hornetq.api.core.Pair;
import org.hornetq.api.core.SimpleString;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.core.config.impl.ConfigurationImpl;
import org.hornetq.core.config.impl.Validators;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.server.JournalType;
import org.hornetq.core.server.cluster.BridgeConfiguration;
import org.hornetq.core.server.cluster.BroadcastGroupConfiguration;
import org.hornetq.core.server.cluster.ClusterConnectionConfiguration;
import org.hornetq.core.server.cluster.DiscoveryGroupConfiguration;
import org.hornetq.core.server.cluster.DivertConfiguration;
import org.hornetq.core.server.group.impl.GroupingHandlerConfiguration;
import org.hornetq.utils.XMLConfigurationUtil;
import org.hornetq.utils.XMLUtil;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FileConfiguration
extends ConfigurationImpl {
    private static final long serialVersionUID = -4766689627675039596L;
    private static final Logger log = Logger.getLogger(FileConfiguration.class);
    private static final String DEFAULT_CONFIGURATION_URL = "hornetq-configuration.xml";
    private static final String CONFIGURATION_SCHEMA_URL = "schema/hornetq-configuration.xsd";
    public static final int DEFAULT_CONFIRMATION_WINDOW_SIZE = 0x100000;
    private String configurationUrl = "hornetq-configuration.xml";
    private boolean started;

    public synchronized void start() throws Exception {
        if (this.started) {
            return;
        }
        URL url = this.getClass().getClassLoader().getResource(this.configurationUrl);
        log.debug("Loading server configuration from " + url);
        InputStreamReader reader = new InputStreamReader(url.openStream());
        String xml = XMLUtil.readerToString(reader);
        xml = XMLUtil.replaceSystemProps(xml);
        Element e = XMLUtil.stringToElement(xml);
        XMLUtil.validate(e, CONFIGURATION_SCHEMA_URL);
        this.clustered = XMLConfigurationUtil.getBoolean(e, "clustered", this.clustered);
        this.backup = XMLConfigurationUtil.getBoolean(e, "backup", this.backup);
        this.sharedStore = XMLConfigurationUtil.getBoolean(e, "shared-store", this.sharedStore);
        this.fileDeploymentEnabled = XMLConfigurationUtil.getBoolean(e, "file-deployment-enabled", true);
        this.persistenceEnabled = XMLConfigurationUtil.getBoolean(e, "persistence-enabled", this.persistenceEnabled);
        this.persistDeliveryCountBeforeDelivery = XMLConfigurationUtil.getBoolean(e, "persist-delivery-count-before-delivery", this.persistDeliveryCountBeforeDelivery);
        this.scheduledThreadPoolMaxSize = XMLConfigurationUtil.getInteger(e, "scheduled-thread-pool-max-size", this.scheduledThreadPoolMaxSize, Validators.GT_ZERO);
        this.threadPoolMaxSize = XMLConfigurationUtil.getInteger(e, "thread-pool-max-size", this.threadPoolMaxSize, Validators.MINUS_ONE_OR_GT_ZERO);
        this.securityEnabled = XMLConfigurationUtil.getBoolean(e, "security-enabled", this.securityEnabled);
        this.jmxManagementEnabled = XMLConfigurationUtil.getBoolean(e, "jmx-management-enabled", this.jmxManagementEnabled);
        this.jmxDomain = XMLConfigurationUtil.getString(e, "jmx-domain", this.jmxDomain, Validators.NOT_NULL_OR_EMPTY);
        this.securityInvalidationInterval = XMLConfigurationUtil.getLong(e, "security-invalidation-interval", this.securityInvalidationInterval, Validators.GT_ZERO);
        this.connectionTTLOverride = XMLConfigurationUtil.getLong(e, "connection-ttl-override", this.connectionTTLOverride, Validators.MINUS_ONE_OR_GT_ZERO);
        this.asyncConnectionExecutionEnabled = XMLConfigurationUtil.getBoolean(e, "async-connection-execution-enabled", this.asyncConnectionExecutionEnabled);
        this.transactionTimeout = XMLConfigurationUtil.getLong(e, "transaction-timeout", this.transactionTimeout, Validators.GT_ZERO);
        this.transactionTimeoutScanPeriod = XMLConfigurationUtil.getLong(e, "transaction-timeout-scan-period", this.transactionTimeoutScanPeriod, Validators.GT_ZERO);
        this.messageExpiryScanPeriod = XMLConfigurationUtil.getLong(e, "message-expiry-scan-period", this.messageExpiryScanPeriod, Validators.GT_ZERO);
        this.messageExpiryThreadPriority = XMLConfigurationUtil.getInteger(e, "message-expiry-thread-priority", this.messageExpiryThreadPriority, Validators.THREAD_PRIORITY_RANGE);
        this.idCacheSize = XMLConfigurationUtil.getInteger(e, "id-cache-size", this.idCacheSize, Validators.GT_ZERO);
        this.persistIDCache = XMLConfigurationUtil.getBoolean(e, "persist-id-cache", this.persistIDCache);
        this.managementAddress = new SimpleString(XMLConfigurationUtil.getString(e, "management-address", this.managementAddress.toString(), Validators.NOT_NULL_OR_EMPTY));
        this.managementNotificationAddress = new SimpleString(XMLConfigurationUtil.getString(e, "management-notification-address", this.managementNotificationAddress.toString(), Validators.NOT_NULL_OR_EMPTY));
        this.clusterPassword = XMLConfigurationUtil.getString(e, "cluster-password", this.clusterPassword, Validators.NO_CHECK);
        this.clusterUser = XMLConfigurationUtil.getString(e, "cluster-user", this.clusterUser, Validators.NO_CHECK);
        this.logDelegateFactoryClassName = XMLConfigurationUtil.getString(e, "log-delegate-factory-class-name", this.logDelegateFactoryClassName, Validators.NOT_NULL_OR_EMPTY);
        NodeList interceptorNodes = e.getElementsByTagName("remoting-interceptors");
        ArrayList<String> interceptorList = new ArrayList<String>();
        if (interceptorNodes.getLength() > 0) {
            NodeList interceptors = interceptorNodes.item(0).getChildNodes();
            for (int i = 0; i < interceptors.getLength(); ++i) {
                if (!"class-name".equalsIgnoreCase(interceptors.item(i).getNodeName())) continue;
                String clazz = interceptors.item(i).getTextContent();
                interceptorList.add(clazz);
            }
        }
        this.interceptorClassNames = interceptorList;
        NodeList backups = e.getElementsByTagName("backup-connector-ref");
        if (backups.getLength() > 0) {
            Node backupNode = backups.item(0);
            this.backupConnectorName = backupNode.getAttributes().getNamedItem("connector-name").getNodeValue();
        }
        NodeList connectorNodes = e.getElementsByTagName("connector");
        for (int i = 0; i < connectorNodes.getLength(); ++i) {
            Element connectorNode = (Element)connectorNodes.item(i);
            TransportConfiguration connectorConfig = this.parseTransportConfiguration(connectorNode);
            if (connectorConfig.getName() == null) {
                log.warn("Cannot deploy a connector with no name specified.");
                continue;
            }
            if (this.connectorConfigs.containsKey(connectorConfig.getName())) {
                log.warn("There is already a connector with name " + connectorConfig.getName() + " deployed. This one will not be deployed.");
                continue;
            }
            this.connectorConfigs.put(connectorConfig.getName(), connectorConfig);
        }
        NodeList acceptorNodes = e.getElementsByTagName("acceptor");
        for (int i = 0; i < acceptorNodes.getLength(); ++i) {
            Element acceptorNode = (Element)acceptorNodes.item(i);
            TransportConfiguration acceptorConfig = this.parseTransportConfiguration(acceptorNode);
            this.acceptorConfigs.add(acceptorConfig);
        }
        NodeList bgNodes = e.getElementsByTagName("broadcast-group");
        for (int i = 0; i < bgNodes.getLength(); ++i) {
            Element bgNode = (Element)bgNodes.item(i);
            this.parseBroadcastGroupConfiguration(bgNode);
        }
        NodeList dgNodes = e.getElementsByTagName("discovery-group");
        for (int i = 0; i < dgNodes.getLength(); ++i) {
            Element dgNode = (Element)dgNodes.item(i);
            this.parseDiscoveryGroupConfiguration(dgNode);
        }
        NodeList brNodes = e.getElementsByTagName("bridge");
        for (int i = 0; i < brNodes.getLength(); ++i) {
            Element mfNode = (Element)brNodes.item(i);
            this.parseBridgeConfiguration(mfNode);
        }
        NodeList gaNodes = e.getElementsByTagName("grouping-handler");
        for (int i = 0; i < gaNodes.getLength(); ++i) {
            Element gaNode = (Element)gaNodes.item(i);
            this.parseGroupingHandlerConfiguration(gaNode);
        }
        NodeList ccNodes = e.getElementsByTagName("cluster-connection");
        for (int i = 0; i < ccNodes.getLength(); ++i) {
            Element ccNode = (Element)ccNodes.item(i);
            this.parseClusterConnectionConfiguration(ccNode);
        }
        NodeList dvNodes = e.getElementsByTagName("divert");
        for (int i = 0; i < dvNodes.getLength(); ++i) {
            Element dvNode = (Element)dvNodes.item(i);
            this.parseDivertConfiguration(dvNode);
        }
        this.largeMessagesDirectory = XMLConfigurationUtil.getString(e, "large-messages-directory", this.largeMessagesDirectory, Validators.NOT_NULL_OR_EMPTY);
        this.bindingsDirectory = XMLConfigurationUtil.getString(e, "bindings-directory", this.bindingsDirectory, Validators.NOT_NULL_OR_EMPTY);
        this.createBindingsDir = XMLConfigurationUtil.getBoolean(e, "create-bindings-dir", this.createBindingsDir);
        this.journalDirectory = XMLConfigurationUtil.getString(e, "journal-directory", this.journalDirectory, Validators.NOT_NULL_OR_EMPTY);
        this.pagingDirectory = XMLConfigurationUtil.getString(e, "paging-directory", this.pagingDirectory, Validators.NOT_NULL_OR_EMPTY);
        this.createJournalDir = XMLConfigurationUtil.getBoolean(e, "create-journal-dir", this.createJournalDir);
        String s = XMLConfigurationUtil.getString(e, "journal-type", this.journalType.toString(), Validators.JOURNAL_TYPE);
        if (s.equals(JournalType.NIO.toString())) {
            this.journalType = JournalType.NIO;
        } else if (s.equals(JournalType.ASYNCIO.toString())) {
            this.journalType = JournalType.ASYNCIO;
        }
        this.journalSyncTransactional = XMLConfigurationUtil.getBoolean(e, "journal-sync-transactional", this.journalSyncTransactional);
        this.journalSyncNonTransactional = XMLConfigurationUtil.getBoolean(e, "journal-sync-non-transactional", this.journalSyncNonTransactional);
        this.journalFileSize = XMLConfigurationUtil.getInteger(e, "journal-file-size", this.journalFileSize, Validators.GT_ZERO);
        int journalBufferTimeout = XMLConfigurationUtil.getInteger(e, "journal-buffer-timeout", this.journalType == JournalType.ASYNCIO ? 500000 : 3333333, Validators.GT_ZERO);
        int journalBufferSize = XMLConfigurationUtil.getInteger(e, "journal-buffer-size", this.journalType == JournalType.ASYNCIO ? 501760 : 501760, Validators.GT_ZERO);
        int journalMaxIO = XMLConfigurationUtil.getInteger(e, "journal-max-io", this.journalType == JournalType.ASYNCIO ? 500 : 1, Validators.GT_ZERO);
        if (this.journalType == JournalType.ASYNCIO) {
            this.journalBufferTimeout_AIO = journalBufferTimeout;
            this.journalBufferSize_AIO = journalBufferSize;
            this.journalMaxIO_AIO = journalMaxIO;
        } else {
            this.journalBufferTimeout_NIO = journalBufferTimeout;
            this.journalBufferSize_NIO = journalBufferSize;
            this.journalMaxIO_NIO = journalMaxIO;
        }
        this.journalMinFiles = XMLConfigurationUtil.getInteger(e, "journal-min-files", this.journalMinFiles, Validators.GT_ZERO);
        this.journalCompactMinFiles = XMLConfigurationUtil.getInteger(e, "journal-compact-min-files", this.journalCompactMinFiles, Validators.GE_ZERO);
        this.journalCompactPercentage = XMLConfigurationUtil.getInteger(e, "journal-compact-percentage", this.journalCompactPercentage, Validators.PERCENTAGE);
        this.logJournalWriteRate = XMLConfigurationUtil.getBoolean(e, "log-journal-write-rate", false);
        this.journalPerfBlastPages = XMLConfigurationUtil.getInteger(e, "perf-blast-pages", -1, Validators.MINUS_ONE_OR_GT_ZERO);
        this.runSyncSpeedTest = XMLConfigurationUtil.getBoolean(e, "run-sync-speed-test", this.runSyncSpeedTest);
        this.wildcardRoutingEnabled = XMLConfigurationUtil.getBoolean(e, "wild-card-routing-enabled", this.wildcardRoutingEnabled);
        this.messageCounterEnabled = XMLConfigurationUtil.getBoolean(e, "message-counter-enabled", this.messageCounterEnabled);
        this.messageCounterSamplePeriod = XMLConfigurationUtil.getLong(e, "message-counter-sample-period", this.messageCounterSamplePeriod, Validators.GT_ZERO);
        this.messageCounterMaxDayHistory = XMLConfigurationUtil.getInteger(e, "message-counter-max-day-history", this.messageCounterMaxDayHistory, Validators.GT_ZERO);
        this.serverDumpInterval = XMLConfigurationUtil.getLong(e, "server-dump-interval", this.serverDumpInterval, Validators.MINUS_ONE_OR_GT_ZERO);
        this.memoryWarningThreshold = XMLConfigurationUtil.getInteger(e, "memory-warning-threshold", this.memoryWarningThreshold, Validators.PERCENTAGE);
        this.memoryMeasureInterval = XMLConfigurationUtil.getLong(e, "memory-measure-interval", this.memoryMeasureInterval, Validators.MINUS_ONE_OR_GT_ZERO);
        this.started = true;
    }

    public synchronized void stop() throws Exception {
        this.started = false;
    }

    public String getConfigurationUrl() {
        return this.configurationUrl;
    }

    public void setConfigurationUrl(String configurationUrl) {
        this.configurationUrl = configurationUrl;
    }

    private TransportConfiguration parseTransportConfiguration(Element e) {
        Node nameNode = e.getAttributes().getNamedItem("name");
        String name = nameNode != null ? nameNode.getNodeValue() : null;
        String clazz = XMLConfigurationUtil.getString(e, "factory-class", null, Validators.NOT_NULL_OR_EMPTY);
        HashMap<String, Object> params = new HashMap<String, Object>();
        NodeList paramsNodes = e.getElementsByTagName("param");
        for (int i = 0; i < paramsNodes.getLength(); ++i) {
            Node paramNode = paramsNodes.item(i);
            NamedNodeMap attributes = paramNode.getAttributes();
            Node nkey = attributes.getNamedItem("key");
            String key = nkey.getTextContent();
            Node nValue = attributes.getNamedItem("value");
            params.put(key, nValue.getTextContent());
        }
        return new TransportConfiguration(clazz, params, name);
    }

    private void parseBroadcastGroupConfiguration(Element e) {
        String name = e.getAttribute("name");
        String localAddress = XMLConfigurationUtil.getString(e, "local-bind-address", null, Validators.NO_CHECK);
        int localBindPort = XMLConfigurationUtil.getInteger(e, "local-bind-port", -1, Validators.MINUS_ONE_OR_GT_ZERO);
        String groupAddress = XMLConfigurationUtil.getString(e, "group-address", null, Validators.NOT_NULL_OR_EMPTY);
        int groupPort = XMLConfigurationUtil.getInteger(e, "group-port", -1, Validators.GT_ZERO);
        long broadcastPeriod = XMLConfigurationUtil.getLong(e, "broadcast-period", 1000L, Validators.GT_ZERO);
        NodeList children = e.getChildNodes();
        ArrayList<Pair<String, String>> connectorNames = new ArrayList<Pair<String, String>>();
        for (int j = 0; j < children.getLength(); ++j) {
            Node child = children.item(j);
            if (!child.getNodeName().equals("connector-ref")) continue;
            String connectorName = child.getAttributes().getNamedItem("connector-name").getNodeValue();
            Node backupConnectorNode = child.getAttributes().getNamedItem("backup-connector-name");
            String backupConnectorName = null;
            if (backupConnectorNode != null) {
                backupConnectorName = backupConnectorNode.getNodeValue();
            }
            Pair<String, String> connectorInfo = new Pair<String, String>(connectorName, backupConnectorName);
            connectorNames.add(connectorInfo);
        }
        BroadcastGroupConfiguration config = new BroadcastGroupConfiguration(name, localAddress, localBindPort, groupAddress, groupPort, broadcastPeriod, connectorNames);
        this.broadcastGroupConfigurations.add(config);
    }

    private void parseDiscoveryGroupConfiguration(Element e) {
        String name = e.getAttribute("name");
        String groupAddress = XMLConfigurationUtil.getString(e, "group-address", null, Validators.NOT_NULL_OR_EMPTY);
        int groupPort = XMLConfigurationUtil.getInteger(e, "group-port", -1, Validators.MINUS_ONE_OR_GT_ZERO);
        long refreshTimeout = XMLConfigurationUtil.getLong(e, "refresh-timeout", 10000L, Validators.GT_ZERO);
        DiscoveryGroupConfiguration config = new DiscoveryGroupConfiguration(name, groupAddress, groupPort, refreshTimeout);
        if (this.discoveryGroupConfigurations.containsKey(name)) {
            log.warn("There is already a discovery group with name " + name + " deployed. This one will not be deployed.");
            return;
        }
        this.discoveryGroupConfigurations.put(name, config);
    }

    private void parseClusterConnectionConfiguration(Element e) {
        String name = e.getAttribute("name");
        String address = XMLConfigurationUtil.getString(e, "address", null, Validators.NOT_NULL_OR_EMPTY);
        boolean duplicateDetection = XMLConfigurationUtil.getBoolean(e, "use-duplicate-detection", true);
        boolean forwardWhenNoConsumers = XMLConfigurationUtil.getBoolean(e, "forward-when-no-consumers", false);
        int maxHops = XMLConfigurationUtil.getInteger(e, "max-hops", 1, Validators.GE_ZERO);
        long retryInterval = XMLConfigurationUtil.getLong(e, "retry-interval", 500L, Validators.GT_ZERO);
        int confirmationWindowSize = XMLConfigurationUtil.getInteger(e, "confirmation-window-size", 0x100000, Validators.GT_ZERO);
        String discoveryGroupName = null;
        ArrayList<Pair<String, String>> connectorPairs = new ArrayList<Pair<String, String>>();
        NodeList children = e.getChildNodes();
        for (int j = 0; j < children.getLength(); ++j) {
            Node child = children.item(j);
            if (child.getNodeName().equals("discovery-group-ref")) {
                discoveryGroupName = child.getAttributes().getNamedItem("discovery-group-name").getNodeValue();
                continue;
            }
            if (!child.getNodeName().equals("connector-ref")) continue;
            String connectorName = child.getAttributes().getNamedItem("connector-name").getNodeValue();
            Node backupNode = child.getAttributes().getNamedItem("backup-connector-name");
            String backupConnectorName = null;
            if (backupNode != null) {
                backupConnectorName = backupNode.getNodeValue();
            }
            Pair<String, String> connectorPair = new Pair<String, String>(connectorName, backupConnectorName);
            connectorPairs.add(connectorPair);
        }
        ClusterConnectionConfiguration config = discoveryGroupName == null ? new ClusterConnectionConfiguration(name, address, retryInterval, duplicateDetection, forwardWhenNoConsumers, maxHops, confirmationWindowSize, connectorPairs) : new ClusterConnectionConfiguration(name, address, retryInterval, duplicateDetection, forwardWhenNoConsumers, maxHops, confirmationWindowSize, discoveryGroupName);
        this.clusterConfigurations.add(config);
    }

    private void parseGroupingHandlerConfiguration(Element node) {
        String name = node.getAttribute("name");
        String type = XMLConfigurationUtil.getString(node, "type", null, Validators.NOT_NULL_OR_EMPTY);
        String address = XMLConfigurationUtil.getString(node, "address", null, Validators.NOT_NULL_OR_EMPTY);
        Integer timeout = XMLConfigurationUtil.getInteger(node, "timeout", 5000, Validators.GT_ZERO);
        this.groupingHandlerConfiguration = new GroupingHandlerConfiguration(new SimpleString(name), type.equals(GroupingHandlerConfiguration.TYPE.LOCAL.getType()) ? GroupingHandlerConfiguration.TYPE.LOCAL : GroupingHandlerConfiguration.TYPE.REMOTE, new SimpleString(address), timeout);
    }

    private void parseBridgeConfiguration(Element brNode) {
        String name = brNode.getAttribute("name");
        String queueName = XMLConfigurationUtil.getString(brNode, "queue-name", null, Validators.NOT_NULL_OR_EMPTY);
        String forwardingAddress = XMLConfigurationUtil.getString(brNode, "forwarding-address", null, Validators.NOT_NULL_OR_EMPTY);
        String transformerClassName = XMLConfigurationUtil.getString(brNode, "transformer-class-name", null, Validators.NO_CHECK);
        long retryInterval = XMLConfigurationUtil.getLong(brNode, "retry-interval", 2000L, Validators.GT_ZERO);
        int confirmationWindowSize = XMLConfigurationUtil.getInteger(brNode, "confirmation-window-size", 0x100000, Validators.GT_ZERO);
        double retryIntervalMultiplier = XMLConfigurationUtil.getDouble(brNode, "retry-interval-multiplier", 1.0, Validators.GT_ZERO);
        int reconnectAttempts = XMLConfigurationUtil.getInteger(brNode, "reconnect-attempts", -1, Validators.MINUS_ONE_OR_GE_ZERO);
        boolean failoverOnServerShutdown = XMLConfigurationUtil.getBoolean(brNode, "failover-on-server-shutdown", false);
        boolean useDuplicateDetection = XMLConfigurationUtil.getBoolean(brNode, "use-duplicate-detection", true);
        String user = XMLConfigurationUtil.getString(brNode, "user", "HORNETQ.CLUSTER.ADMIN.USER", Validators.NO_CHECK);
        String password = XMLConfigurationUtil.getString(brNode, "password", "CHANGE ME!!", Validators.NO_CHECK);
        String filterString = null;
        Pair<String, String> connectorPair = null;
        String discoveryGroupName = null;
        NodeList children = brNode.getChildNodes();
        for (int j = 0; j < children.getLength(); ++j) {
            Node child = children.item(j);
            if (child.getNodeName().equals("filter")) {
                filterString = child.getAttributes().getNamedItem("string").getNodeValue();
                continue;
            }
            if (child.getNodeName().equals("discovery-group-ref")) {
                discoveryGroupName = child.getAttributes().getNamedItem("discovery-group-name").getNodeValue();
                continue;
            }
            if (!child.getNodeName().equals("connector-ref")) continue;
            String connectorName = child.getAttributes().getNamedItem("connector-name").getNodeValue();
            Node backupNode = child.getAttributes().getNamedItem("backup-connector-name");
            String backupConnectorName = null;
            if (backupNode != null) {
                backupConnectorName = backupNode.getNodeValue();
            }
            connectorPair = new Pair<String, String>(connectorName, backupConnectorName);
        }
        BridgeConfiguration config = connectorPair != null ? new BridgeConfiguration(name, queueName, forwardingAddress, filterString, transformerClassName, retryInterval, retryIntervalMultiplier, reconnectAttempts, failoverOnServerShutdown, useDuplicateDetection, confirmationWindowSize, 30000L, connectorPair, user, password) : new BridgeConfiguration(name, queueName, forwardingAddress, filterString, transformerClassName, retryInterval, retryIntervalMultiplier, reconnectAttempts, failoverOnServerShutdown, useDuplicateDetection, confirmationWindowSize, 30000L, discoveryGroupName, user, password);
        this.bridgeConfigurations.add(config);
    }

    private void parseDivertConfiguration(Element e) {
        String name = e.getAttribute("name");
        String routingName = XMLConfigurationUtil.getString(e, "routing-name", null, Validators.NO_CHECK);
        String address = XMLConfigurationUtil.getString(e, "address", null, Validators.NOT_NULL_OR_EMPTY);
        String forwardingAddress = XMLConfigurationUtil.getString(e, "forwarding-address", null, Validators.NOT_NULL_OR_EMPTY);
        boolean exclusive = XMLConfigurationUtil.getBoolean(e, "exclusive", false);
        String transformerClassName = XMLConfigurationUtil.getString(e, "transformer-class-name", null, Validators.NO_CHECK);
        String filterString = null;
        NodeList children = e.getChildNodes();
        for (int j = 0; j < children.getLength(); ++j) {
            Node child = children.item(j);
            if (!child.getNodeName().equals("filter")) continue;
            filterString = child.getAttributes().getNamedItem("string").getNodeValue();
        }
        DivertConfiguration config = new DivertConfiguration(name, routingName, address, forwardingAddress, exclusive, filterString, transformerClassName);
        this.divertConfigurations.add(config);
    }
}

