/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.deployers.impl;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.hornetq.api.core.Pair;
import org.hornetq.core.deployers.Deployer;
import org.hornetq.core.deployers.DeploymentManager;
import org.hornetq.core.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileDeploymentManager
implements Runnable,
DeploymentManager {
    private static final Logger log = Logger.getLogger(FileDeploymentManager.class);
    private final List<Deployer> deployers = new ArrayList<Deployer>();
    private final Map<Pair<URL, Deployer>, DeployInfo> deployed = new HashMap<Pair<URL, Deployer>, DeployInfo>();
    private ScheduledExecutorService scheduler;
    private boolean started;
    private final long period;
    private ScheduledFuture<?> future;

    public FileDeploymentManager(long period) {
        this.period = period;
    }

    @Override
    public synchronized void start() throws Exception {
        if (this.started) {
            return;
        }
        this.started = true;
        this.scheduler = Executors.newSingleThreadScheduledExecutor();
        this.future = this.scheduler.scheduleWithFixedDelay(this, this.period, this.period, TimeUnit.MILLISECONDS);
    }

    @Override
    public synchronized void stop() {
        if (!this.started) {
            return;
        }
        this.started = false;
        if (this.future != null) {
            this.future.cancel(false);
            this.future = null;
        }
        this.scheduler.shutdown();
        this.scheduler = null;
    }

    @Override
    public synchronized boolean isStarted() {
        return this.started;
    }

    @Override
    public synchronized void registerDeployer(Deployer deployer) throws Exception {
        if (!this.deployers.contains(deployer)) {
            String[] filenames;
            this.deployers.add(deployer);
            for (String filename : filenames = deployer.getConfigFileNames()) {
                log.debug("the filename is " + filename);
                log.debug(System.getProperty("java.class.path"));
                Enumeration<URL> urls = Thread.currentThread().getContextClassLoader().getResources(filename);
                while (urls.hasMoreElements()) {
                    URL url = urls.nextElement();
                    log.debug("Got url " + url);
                    try {
                        log.debug("Deploying " + url + " for " + deployer.getClass().getSimpleName());
                        deployer.deploy(url);
                    }
                    catch (Exception e) {
                        log.error("Error deploying " + url, e);
                    }
                    Pair<URL, Deployer> pair = new Pair<URL, Deployer>(url, deployer);
                    this.deployed.put(pair, new DeployInfo(deployer, this.getFileFromURL(url).lastModified()));
                }
            }
        }
    }

    @Override
    public synchronized void unregisterDeployer(Deployer deployer) throws Exception {
        if (this.deployers.remove(deployer)) {
            String[] filenames;
            for (String filename : filenames = deployer.getConfigFileNames()) {
                Enumeration<URL> urls = Thread.currentThread().getContextClassLoader().getResources(filename);
                while (urls.hasMoreElements()) {
                    URL url = urls.nextElement();
                    Pair<URL, Deployer> pair = new Pair<URL, Deployer>(url, deployer);
                    this.deployed.remove(pair);
                }
            }
        }
    }

    private File getFileFromURL(URL url) throws UnsupportedEncodingException {
        return new File(URLDecoder.decode(url.getFile(), "UTF-8"));
    }

    @Override
    public synchronized void run() {
        if (!this.started) {
            return;
        }
        try {
            for (Deployer deployer : this.deployers) {
                String[] stringArray;
                for (String filename : stringArray = deployer.getConfigFileNames()) {
                    Enumeration<URL> urls = Thread.currentThread().getContextClassLoader().getResources(filename);
                    while (urls.hasMoreElements()) {
                        URL url = urls.nextElement();
                        Pair<URL, Deployer> pair = new Pair<URL, Deployer>(url, deployer);
                        DeployInfo info = this.deployed.get(pair);
                        long newLastModified = this.getFileFromURL(url).lastModified();
                        if (info == null) {
                            try {
                                deployer.deploy(url);
                                this.deployed.put(pair, new DeployInfo(deployer, this.getFileFromURL(url).lastModified()));
                            }
                            catch (Exception e) {
                                log.error("Error deploying " + url, e);
                            }
                            continue;
                        }
                        if (newLastModified <= info.lastModified) continue;
                        try {
                            deployer.redeploy(url);
                            this.deployed.put(pair, new DeployInfo(deployer, this.getFileFromURL(url).lastModified()));
                        }
                        catch (Exception e) {
                            log.error("Error redeploying " + url, e);
                        }
                    }
                }
            }
            ArrayList<Pair<URL, Deployer>> toRemove = new ArrayList<Pair<URL, Deployer>>();
            for (Map.Entry<Pair<URL, Deployer>, DeployInfo> entry : this.deployed.entrySet()) {
                Pair<URL, Deployer> pair = entry.getKey();
                if (this.fileExists((URL)pair.a)) continue;
                try {
                    Deployer deployer = entry.getValue().deployer;
                    log.debug("Undeploying " + deployer + " with url " + pair.a);
                    deployer.undeploy((URL)pair.a);
                    toRemove.add(pair);
                }
                catch (Exception e) {
                    log.error("Error undeploying " + pair.a, e);
                }
            }
            for (Pair pair : toRemove) {
                this.deployed.remove(pair);
            }
        }
        catch (Exception e) {
            log.warn("error scanning for URL's " + e);
        }
    }

    public synchronized List<Deployer> getDeployers() {
        return this.deployers;
    }

    public synchronized Map<Pair<URL, Deployer>, DeployInfo> getDeployed() {
        return this.deployed;
    }

    private boolean fileExists(URL resourceURL) {
        try {
            File f = this.getFileFromURL(resourceURL);
            Enumeration<URL> resources = Thread.currentThread().getContextClassLoader().getResources(f.getName());
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                if (!url.equals(resourceURL)) continue;
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public static class DeployInfo {
        public Deployer deployer;
        public long lastModified;

        DeployInfo(Deployer deployer, long lastModified) {
            this.deployer = deployer;
            this.lastModified = lastModified;
        }
    }
}

