/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.deployers.impl;

import org.hornetq.api.core.management.HornetQServerControl;
import org.hornetq.core.deployers.DeploymentManager;
import org.hornetq.core.deployers.impl.XmlDeployer;
import org.hornetq.core.server.cluster.QueueConfiguration;
import org.hornetq.utils.XMLUtil;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class QueueDeployer
extends XmlDeployer {
    private final HornetQServerControl serverControl;

    public QueueDeployer(DeploymentManager deploymentManager, HornetQServerControl serverControl) {
        super(deploymentManager);
        this.serverControl = serverControl;
    }

    public String[] getElementTagName() {
        return new String[]{"queue"};
    }

    public void validate(Node rootNode) throws Exception {
        XMLUtil.validate(rootNode, "schema/hornetq-configuration.xsd");
    }

    public void deploy(Node node) throws Exception {
        QueueConfiguration queueConfig = this.parseQueueConfiguration(node);
        this.serverControl.deployQueue(queueConfig.getAddress(), queueConfig.getName(), queueConfig.getFilterString(), queueConfig.isDurable());
    }

    public void undeploy(Node node) throws Exception {
    }

    public String[] getDefaultConfigFileNames() {
        return new String[]{"hornetq-configuration.xml", "hornetq-queues.xml"};
    }

    private QueueConfiguration parseQueueConfiguration(Node node) {
        String name = node.getAttributes().getNamedItem("name").getNodeValue();
        String address = null;
        String filterString = null;
        boolean durable = true;
        NodeList children = node.getChildNodes();
        for (int j = 0; j < children.getLength(); ++j) {
            Node child = children.item(j);
            if (child.getNodeName().equals("address")) {
                address = child.getTextContent().trim();
                continue;
            }
            if (child.getNodeName().equals("filter")) {
                filterString = child.getAttributes().getNamedItem("string").getNodeValue();
                continue;
            }
            if (!child.getNodeName().equals("durable")) continue;
            durable = Boolean.parseBoolean(child.getTextContent().trim());
        }
        return new QueueConfiguration(address, name, filterString, durable);
    }
}

