/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.deployers.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.hornetq.core.deployers.DeploymentManager;
import org.hornetq.core.deployers.impl.XmlDeployer;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.security.Role;
import org.hornetq.core.settings.HierarchicalRepository;
import org.hornetq.utils.XMLUtil;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityDeployer
extends XmlDeployer {
    private static final Logger log = Logger.getLogger(SecurityDeployer.class);
    private static final String PERMISSION_ELEMENT_NAME = "permission";
    private static final String TYPE_ATTR_NAME = "type";
    private static final String ROLES_ATTR_NAME = "roles";
    private static final String QUEUES_XML = "hornetq-queues.xml";
    private static final String MATCH = "match";
    private static final String SECURITY_ELEMENT_NAME = "security-setting";
    public static final String SEND_NAME = "send";
    public static final String CONSUME_NAME = "consume";
    public static final String CREATEDURABLEQUEUE_NAME = "createDurableQueue";
    public static final String DELETEDURABLEQUEUE_NAME = "deleteDurableQueue";
    public static final String CREATETEMPQUEUE_NAME = "createTempQueue";
    public static final String DELETETEMPQUEUE_NAME = "deleteTempQueue";
    public static final String MANAGE_NAME = "manage";
    private final HierarchicalRepository<Set<Role>> securityRepository;

    public SecurityDeployer(DeploymentManager deploymentManager, HierarchicalRepository<Set<Role>> securityRepository) {
        super(deploymentManager);
        this.securityRepository = securityRepository;
    }

    @Override
    public String[] getElementTagName() {
        return new String[]{SECURITY_ELEMENT_NAME};
    }

    @Override
    public void validate(Node rootNode) throws Exception {
        XMLUtil.validate(rootNode, "schema/hornetq-configuration.xsd");
    }

    @Override
    public String getKeyAttribute() {
        return MATCH;
    }

    @Override
    public void deploy(Node node) throws Exception {
        HashSet<Role> securityRoles = new HashSet<Role>();
        ArrayList<String> send = new ArrayList<String>();
        ArrayList<String> consume = new ArrayList<String>();
        ArrayList<String> createDurableQueue = new ArrayList<String>();
        ArrayList<String> deleteDurableQueue = new ArrayList<String>();
        ArrayList<String> createTempQueue = new ArrayList<String>();
        ArrayList<String> deleteTempQueue = new ArrayList<String>();
        ArrayList<String> manageRoles = new ArrayList<String>();
        ArrayList<String> allRoles = new ArrayList<String>();
        String match = node.getAttributes().getNamedItem(this.getKeyAttribute()).getNodeValue();
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            String[] roles;
            Node child = children.item(i);
            if (!PERMISSION_ELEMENT_NAME.equalsIgnoreCase(child.getNodeName())) continue;
            String type = child.getAttributes().getNamedItem(TYPE_ATTR_NAME).getNodeValue();
            String roleString = child.getAttributes().getNamedItem(ROLES_ATTR_NAME).getNodeValue();
            for (String role : roles = roleString.split(",")) {
                if (SEND_NAME.equals(type)) {
                    send.add(role.trim());
                } else if (CONSUME_NAME.equals(type)) {
                    consume.add(role.trim());
                } else if (CREATEDURABLEQUEUE_NAME.equals(type)) {
                    createDurableQueue.add(role);
                } else if (DELETEDURABLEQUEUE_NAME.equals(type)) {
                    deleteDurableQueue.add(role);
                } else if (CREATETEMPQUEUE_NAME.equals(type)) {
                    createTempQueue.add(role);
                } else if (DELETETEMPQUEUE_NAME.equals(type)) {
                    deleteTempQueue.add(role);
                } else if (MANAGE_NAME.equals(type)) {
                    manageRoles.add(role);
                }
                if (allRoles.contains(role.trim())) continue;
                allRoles.add(role.trim());
            }
        }
        for (String role : allRoles) {
            securityRoles.add(new Role(role, send.contains(role), consume.contains(role), createDurableQueue.contains(role), deleteDurableQueue.contains(role), createTempQueue.contains(role), deleteTempQueue.contains(role), manageRoles.contains(role)));
        }
        this.securityRepository.addMatch(match, securityRoles);
    }

    @Override
    public void undeploy(Node node) throws Exception {
        String match = node.getAttributes().getNamedItem(this.getKeyAttribute()).getNodeValue();
        this.securityRepository.removeMatch(match);
    }

    @Override
    public String[] getDefaultConfigFileNames() {
        return new String[]{"hornetq-configuration.xml", QUEUES_XML};
    }
}

