/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.deployers.impl;

import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.hornetq.core.deployers.Deployer;
import org.hornetq.core.deployers.DeploymentManager;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.server.HornetQComponent;
import org.hornetq.utils.XMLUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class XmlDeployer
implements Deployer,
HornetQComponent {
    private static Logger log = Logger.getLogger(XmlDeployer.class);
    protected static final String NAME_ATTR = "name";
    private final Map<URL, Map<String, Node>> configuration = new HashMap<URL, Map<String, Node>>();
    private final DeploymentManager deploymentManager;
    private boolean started;
    private String[] configFileNames;

    public XmlDeployer(DeploymentManager deploymentManager) {
        this.deploymentManager = deploymentManager;
        this.configFileNames = this.getDefaultConfigFileNames();
    }

    public synchronized void addToConfiguration(URL url, String name, Node e) {
        Map<String, Node> map = this.configuration.get(url);
        if (map == null) {
            map = new HashMap<String, Node>();
            this.configuration.put(url, map);
        }
        map.put(name, e);
    }

    public synchronized void redeploy(URL url) throws Exception {
        String[] elements;
        Element e = this.getRootElement(url);
        ArrayList<String> added = new ArrayList<String>();
        for (String element : elements = this.getElementTagName()) {
            NodeList children = e.getElementsByTagName(element);
            for (int i = 0; i < children.getLength(); ++i) {
                Node node = children.item(i);
                String name = node.getAttributes().getNamedItem(this.getKeyAttribute()).getNodeValue();
                added.add(name);
                Map<String, Node> map = this.configuration.get(url);
                if (map == null || map != null && map.get(name) == null) {
                    this.deploy(node);
                    continue;
                }
                if (!this.hasNodeChanged(url, node, name)) continue;
                this.undeploy(node);
                this.deploy(node);
                this.addToConfiguration(url, name, node);
            }
        }
        if (this.configuration.get(url) != null) {
            Set<String> keys = this.configuration.get(url).keySet();
            ArrayList<String> removed = new ArrayList<String>();
            for (String key : keys) {
                if (added.contains(key)) continue;
                this.undeploy(this.configuration.get(url).get(key));
                removed.add(key);
            }
            for (String s : removed) {
                this.configuration.get(url).remove(s);
            }
        }
    }

    public synchronized void undeploy(URL url) throws Exception {
        Set<String> keys = this.configuration.get(url).keySet();
        for (String key : keys) {
            this.undeploy(this.configuration.get(url).get(key));
        }
        this.configuration.remove(url);
    }

    public synchronized void deploy(URL url) throws Exception {
        String[] elements;
        Element e = this.getRootElement(url);
        this.validate(e);
        Map<String, Node> map = this.configuration.get(url);
        if (map == null) {
            map = new HashMap<String, Node>();
            this.configuration.put(url, map);
        }
        for (String element : elements = this.getElementTagName()) {
            NodeList children = e.getElementsByTagName(element);
            for (int i = 0; i < children.getLength(); ++i) {
                Node node = children.item(i);
                Node keyNode = node.getAttributes().getNamedItem(this.getKeyAttribute());
                if (keyNode == null) {
                    log.error("key attribute missing for configuration " + node);
                    continue;
                }
                String name = keyNode.getNodeValue();
                try {
                    this.deploy(node);
                }
                catch (Exception e1) {
                    log.error(new StringBuilder("Unable to deploy node " + node + " " + name), e1);
                    continue;
                }
                this.addToConfiguration(url, name, node);
            }
        }
    }

    public String getKeyAttribute() {
        return NAME_ATTR;
    }

    public synchronized void start() throws Exception {
        if (this.started) {
            return;
        }
        this.deploymentManager.registerDeployer(this);
        this.started = true;
    }

    public synchronized void stop() throws Exception {
        if (!this.started) {
            return;
        }
        Collection<Map<String, Node>> urls = this.configuration.values();
        for (Map<String, Node> hashMap : urls) {
            for (Node node : hashMap.values()) {
                try {
                    this.undeploy(node);
                }
                catch (Exception e) {
                    log.warn("problem undeploying " + node, e);
                }
            }
        }
        this.deploymentManager.unregisterDeployer(this);
        this.started = false;
    }

    public synchronized boolean isStarted() {
        return this.started;
    }

    public String[] getConfigFileNames() {
        return this.configFileNames;
    }

    public void setConfigFileNames(String[] configFileNames) {
        this.configFileNames = configFileNames;
    }

    public abstract String[] getElementTagName();

    public abstract String[] getDefaultConfigFileNames();

    public abstract void deploy(Node var1) throws Exception;

    public abstract void validate(Node var1) throws Exception;

    public abstract void undeploy(Node var1) throws Exception;

    protected Element getRootElement(URL url) throws Exception {
        InputStreamReader reader = new InputStreamReader(url.openStream());
        String xml = XMLUtil.readerToString(reader);
        xml = XMLUtil.replaceSystemProps(xml);
        return XMLUtil.stringToElement(xml);
    }

    private boolean hasNodeChanged(URL url, Node child, String name) {
        String origTextContent;
        String newTextContent = child.getTextContent();
        return !newTextContent.equals(origTextContent = this.configuration.get(url).get(name).getTextContent());
    }
}

