/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.journal.impl;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.hornetq.api.core.HornetQException;
import org.hornetq.core.journal.impl.SyncIOCompletion;
import org.hornetq.core.logging.Logger;

public class SimpleWaitIOCallback
extends SyncIOCompletion {
    private static final Logger log = Logger.getLogger(SimpleWaitIOCallback.class);
    private final CountDownLatch latch = new CountDownLatch(1);
    private volatile String errorMessage;
    private volatile int errorCode = 0;

    public void done() {
        this.latch.countDown();
    }

    public void onError(int errorCode, String errorMessage) {
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
        log.warn("Error Message " + errorMessage);
        this.latch.countDown();
    }

    public void waitCompletion() throws Exception {
        this.latch.await();
        if (this.errorMessage != null) {
            throw new HornetQException(this.errorCode, this.errorMessage);
        }
    }

    public boolean waitCompletion(long timeout) throws Exception {
        boolean retValue = this.latch.await(timeout, TimeUnit.MILLISECONDS);
        if (this.errorMessage != null) {
            throw new HornetQException(this.errorCode, this.errorMessage);
        }
        return retValue;
    }

    public void storeLineUp() {
    }
}

