/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.management.impl;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.transaction.xa.Xid;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.SimpleString;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.api.core.management.AddressControl;
import org.hornetq.api.core.management.HornetQServerControl;
import org.hornetq.api.core.management.NotificationType;
import org.hornetq.api.core.management.QueueControl;
import org.hornetq.core.config.Configuration;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.management.impl.AbstractControl;
import org.hornetq.core.management.impl.MBeanInfoHelper;
import org.hornetq.core.messagecounter.MessageCounterManager;
import org.hornetq.core.persistence.StorageManager;
import org.hornetq.core.postoffice.PostOffice;
import org.hornetq.core.remoting.RemotingConnection;
import org.hornetq.core.remoting.server.RemotingService;
import org.hornetq.core.server.HornetQServer;
import org.hornetq.core.server.JournalType;
import org.hornetq.core.server.ServerSession;
import org.hornetq.core.transaction.ResourceManager;
import org.hornetq.core.transaction.Transaction;
import org.hornetq.core.transaction.impl.XidImpl;
import org.hornetq.utils.json.JSONArray;
import org.hornetq.utils.json.JSONObject;

public class HornetQServerControlImpl
extends AbstractControl
implements HornetQServerControl,
NotificationEmitter {
    private static final Logger log = Logger.getLogger(HornetQServerControlImpl.class);
    private final PostOffice postOffice;
    private final Configuration configuration;
    private final ResourceManager resourceManager;
    private final RemotingService remotingService;
    private final HornetQServer server;
    private final MessageCounterManager messageCounterManager;
    private final NotificationBroadcasterSupport broadcaster;

    public HornetQServerControlImpl(PostOffice postOffice, Configuration configuration, ResourceManager resourceManager, RemotingService remotingService, HornetQServer messagingServer, MessageCounterManager messageCounterManager, StorageManager storageManager, NotificationBroadcasterSupport broadcaster) throws Exception {
        super(HornetQServerControl.class, storageManager);
        this.postOffice = postOffice;
        this.configuration = configuration;
        this.resourceManager = resourceManager;
        this.remotingService = remotingService;
        this.server = messagingServer;
        this.messageCounterManager = messageCounterManager;
        this.broadcaster = broadcaster;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStarted() {
        this.clearIO();
        try {
            boolean bl = this.server.isStarted();
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getVersion() {
        this.clearIO();
        try {
            String string = this.server.getVersion().getFullVersion();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBackup() {
        this.clearIO();
        try {
            boolean bl = this.configuration.isBackup();
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSharedStore() {
        this.clearIO();
        try {
            boolean bl = this.configuration.isSharedStore();
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getBackupConnectorName() {
        this.clearIO();
        try {
            String string = this.configuration.getBackupConnectorName();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getBindingsDirectory() {
        this.clearIO();
        try {
            String string = this.configuration.getBindingsDirectory();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getInterceptorClassNames() {
        this.clearIO();
        try {
            String[] stringArray = this.configuration.getInterceptorClassNames().toArray(new String[this.configuration.getInterceptorClassNames().size()]);
            return stringArray;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getJournalBufferSize() {
        this.clearIO();
        try {
            int n = this.configuration.getJournalType() == JournalType.ASYNCIO ? this.configuration.getJournalBufferSize_AIO() : this.configuration.getJournalBufferSize_NIO();
            return n;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getJournalBufferTimeout() {
        this.clearIO();
        try {
            int n = this.configuration.getJournalType() == JournalType.ASYNCIO ? this.configuration.getJournalBufferTimeout_AIO() : this.configuration.getJournalBufferTimeout_NIO();
            return n;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getJournalMaxIO() {
        this.clearIO();
        try {
            int n = this.configuration.getJournalType() == JournalType.ASYNCIO ? this.configuration.getJournalMaxIO_AIO() : this.configuration.getJournalMaxIO_NIO();
            return n;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getJournalDirectory() {
        this.clearIO();
        try {
            String string = this.configuration.getJournalDirectory();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getJournalFileSize() {
        this.clearIO();
        try {
            int n = this.configuration.getJournalFileSize();
            return n;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getJournalMinFiles() {
        this.clearIO();
        try {
            int n = this.configuration.getJournalMinFiles();
            return n;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getJournalCompactMinFiles() {
        this.clearIO();
        try {
            int n = this.configuration.getJournalCompactMinFiles();
            return n;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getJournalCompactPercentage() {
        this.clearIO();
        try {
            int n = this.configuration.getJournalCompactPercentage();
            return n;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPersistenceEnabled() {
        this.clearIO();
        try {
            boolean bl = this.configuration.isPersistenceEnabled();
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getJournalType() {
        this.clearIO();
        try {
            String string = this.configuration.getJournalType().toString();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPagingDirectory() {
        this.clearIO();
        try {
            String string = this.configuration.getPagingDirectory();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getScheduledThreadPoolMaxSize() {
        this.clearIO();
        try {
            int n = this.configuration.getScheduledThreadPoolMaxSize();
            return n;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getThreadPoolMaxSize() {
        this.clearIO();
        try {
            int n = this.configuration.getThreadPoolMaxSize();
            return n;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSecurityInvalidationInterval() {
        this.clearIO();
        try {
            long l = this.configuration.getSecurityInvalidationInterval();
            return l;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClustered() {
        this.clearIO();
        try {
            boolean bl = this.configuration.isClustered();
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCreateBindingsDir() {
        this.clearIO();
        try {
            boolean bl = this.configuration.isCreateBindingsDir();
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCreateJournalDir() {
        this.clearIO();
        try {
            boolean bl = this.configuration.isCreateJournalDir();
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isJournalSyncNonTransactional() {
        this.clearIO();
        try {
            boolean bl = this.configuration.isJournalSyncNonTransactional();
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isJournalSyncTransactional() {
        this.clearIO();
        try {
            boolean bl = this.configuration.isJournalSyncTransactional();
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSecurityEnabled() {
        this.clearIO();
        try {
            boolean bl = this.configuration.isSecurityEnabled();
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAsyncConnectionExecutionEnabled() {
        this.clearIO();
        try {
            boolean bl = this.configuration.isAsyncConnectionExecutionEnabled();
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deployQueue(String address, String name, String filterString) throws Exception {
        this.clearIO();
        try {
            this.server.deployQueue(new SimpleString(address), new SimpleString(name), new SimpleString(filterString), true, false);
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deployQueue(String address, String name, String filterStr, boolean durable) throws Exception {
        SimpleString filter = filterStr == null ? null : new SimpleString(filterStr);
        this.clearIO();
        try {
            this.server.deployQueue(new SimpleString(address), new SimpleString(name), filter, durable, false);
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createQueue(String address, String name) throws Exception {
        this.clearIO();
        try {
            this.server.createQueue(new SimpleString(address), new SimpleString(name), null, true, false);
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createQueue(String address, String name, boolean durable) throws Exception {
        this.clearIO();
        try {
            this.server.createQueue(new SimpleString(address), new SimpleString(name), null, durable, false);
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createQueue(String address, String name, String filterStr, boolean durable) throws Exception {
        this.clearIO();
        try {
            SimpleString filter = null;
            if (filterStr != null && !filterStr.trim().equals("")) {
                filter = new SimpleString(filterStr);
            }
            this.server.createQueue(new SimpleString(address), new SimpleString(name), filter, durable, false);
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getQueueNames() {
        this.clearIO();
        try {
            Object[] queues = this.server.getManagementService().getResources(QueueControl.class);
            String[] names = new String[queues.length];
            for (int i = 0; i < queues.length; ++i) {
                QueueControl queue = (QueueControl)queues[i];
                names[i] = queue.getName();
            }
            String[] stringArray = names;
            return stringArray;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getAddressNames() {
        this.clearIO();
        try {
            Object[] addresses = this.server.getManagementService().getResources(AddressControl.class);
            String[] names = new String[addresses.length];
            for (int i = 0; i < addresses.length; ++i) {
                AddressControl address = (AddressControl)addresses[i];
                names[i] = address.getAddress();
            }
            String[] stringArray = names;
            return stringArray;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyQueue(String name) throws Exception {
        this.clearIO();
        try {
            SimpleString queueName = new SimpleString(name);
            this.server.destroyQueue(queueName, null);
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getConnectionCount() {
        this.clearIO();
        try {
            int n = this.server.getConnectionCount();
            return n;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableMessageCounters() {
        this.clearIO();
        try {
            this.setMessageCounterEnabled(true);
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableMessageCounters() {
        this.clearIO();
        try {
            this.setMessageCounterEnabled(false);
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetAllMessageCounters() {
        this.clearIO();
        try {
            this.messageCounterManager.resetAllCounters();
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetAllMessageCounterHistories() {
        this.clearIO();
        try {
            this.messageCounterManager.resetAllCounterHistories();
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMessageCounterEnabled() {
        this.clearIO();
        try {
            boolean bl = this.configuration.isMessageCounterEnabled();
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized long getMessageCounterSamplePeriod() {
        this.clearIO();
        try {
            long l = this.messageCounterManager.getSamplePeriod();
            return l;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setMessageCounterSamplePeriod(long newPeriod) {
        this.clearIO();
        try {
            if (newPeriod < 1000L) {
                throw new IllegalArgumentException("Cannot set MessageCounterSamplePeriod < 1000 ms");
            }
            if (this.messageCounterManager != null && newPeriod != this.messageCounterManager.getSamplePeriod()) {
                this.messageCounterManager.reschedule(newPeriod);
            }
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMessageCounterMaxDayCount() {
        this.clearIO();
        try {
            int n = this.messageCounterManager.getMaxDayCount();
            return n;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMessageCounterMaxDayCount(int count) {
        this.clearIO();
        try {
            if (count <= 0) {
                throw new IllegalArgumentException("invalid value: count must be greater than 0");
            }
            this.messageCounterManager.setMaxDayCount(count);
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] listPreparedTransactions() {
        this.clearIO();
        try {
            DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 2);
            Map<Xid, Long> xids = this.resourceManager.getPreparedTransactionsWithCreationTime();
            ArrayList<Map.Entry<Xid, Long>> xidsSortedByCreationTime = new ArrayList<Map.Entry<Xid, Long>>(xids.entrySet());
            Collections.sort(xidsSortedByCreationTime, new Comparator<Map.Entry<Xid, Long>>(){

                @Override
                public int compare(Map.Entry<Xid, Long> entry1, Map.Entry<Xid, Long> entry2) {
                    return (int)(entry1.getValue() - entry2.getValue());
                }
            });
            String[] s = new String[xidsSortedByCreationTime.size()];
            int i = 0;
            for (Map.Entry<Xid, Long> entry : xidsSortedByCreationTime) {
                Date creation = new Date(entry.getValue());
                Xid xid = entry.getKey();
                s[i++] = dateFormat.format(creation) + " base64: " + XidImpl.toBase64String(xid) + " " + xid.toString();
            }
            String[] stringArray = s;
            return stringArray;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] listHeuristicCommittedTransactions() {
        this.clearIO();
        try {
            List<Xid> xids = this.resourceManager.getHeuristicCommittedTransactions();
            String[] s = new String[xids.size()];
            int i = 0;
            for (Xid xid : xids) {
                s[i++] = XidImpl.toBase64String(xid);
            }
            String[] stringArray = s;
            return stringArray;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] listHeuristicRolledBackTransactions() {
        this.clearIO();
        try {
            List<Xid> xids = this.resourceManager.getHeuristicRolledbackTransactions();
            String[] s = new String[xids.size()];
            int i = 0;
            for (Xid xid : xids) {
                s[i++] = XidImpl.toBase64String(xid);
            }
            String[] stringArray = s;
            return stringArray;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean commitPreparedTransaction(String transactionAsBase64) throws Exception {
        this.clearIO();
        try {
            List<Xid> xids = this.resourceManager.getPreparedTransactions();
            for (Xid xid : xids) {
                if (!XidImpl.toBase64String(xid).equals(transactionAsBase64)) continue;
                Transaction transaction = this.resourceManager.removeTransaction(xid);
                transaction.commit(false);
                long recordID = this.server.getStorageManager().storeHeuristicCompletion(xid, true);
                this.storageManager.waitOnOperations();
                this.resourceManager.putHeuristicCompletion(recordID, xid, true);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean rollbackPreparedTransaction(String transactionAsBase64) throws Exception {
        this.clearIO();
        try {
            List<Xid> xids = this.resourceManager.getPreparedTransactions();
            for (Xid xid : xids) {
                if (!XidImpl.toBase64String(xid).equals(transactionAsBase64)) continue;
                Transaction transaction = this.resourceManager.removeTransaction(xid);
                transaction.rollback();
                long recordID = this.server.getStorageManager().storeHeuristicCompletion(xid, false);
                this.server.getStorageManager().waitOnOperations();
                this.resourceManager.putHeuristicCompletion(recordID, xid, false);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] listRemoteAddresses() {
        this.clearIO();
        try {
            Set<RemotingConnection> connections = this.remotingService.getConnections();
            String[] remoteAddresses = new String[connections.size()];
            int i = 0;
            for (RemotingConnection connection : connections) {
                remoteAddresses[i++] = connection.getRemoteAddress();
            }
            String[] stringArray = remoteAddresses;
            return stringArray;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] listRemoteAddresses(String ipAddress) {
        this.clearIO();
        try {
            Set<RemotingConnection> connections = this.remotingService.getConnections();
            ArrayList<String> remoteConnections = new ArrayList<String>();
            for (RemotingConnection connection : connections) {
                String remoteAddress = connection.getRemoteAddress();
                if (!remoteAddress.contains(ipAddress)) continue;
                remoteConnections.add(connection.getRemoteAddress());
            }
            String[] stringArray = remoteConnections.toArray(new String[remoteConnections.size()]);
            return stringArray;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean closeConnectionsForAddress(String ipAddress) {
        this.clearIO();
        try {
            boolean closed = false;
            Set<RemotingConnection> connections = this.remotingService.getConnections();
            for (RemotingConnection connection : connections) {
                String remoteAddress = connection.getRemoteAddress();
                if (!remoteAddress.contains(ipAddress)) continue;
                this.remotingService.removeConnection(connection.getID());
                connection.fail(new HornetQException(0, "connections for " + ipAddress + " closed by management"));
                closed = true;
            }
            boolean bl = closed;
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] listConnectionIDs() {
        this.clearIO();
        try {
            Set<RemotingConnection> connections = this.remotingService.getConnections();
            String[] connectionIDs = new String[connections.size()];
            int i = 0;
            for (RemotingConnection connection : connections) {
                connectionIDs[i++] = connection.getID().toString();
            }
            String[] stringArray = connectionIDs;
            return stringArray;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] listSessions(String connectionID) {
        this.clearIO();
        try {
            List<ServerSession> sessions = this.server.getSessions(connectionID);
            String[] sessionIDs = new String[sessions.size()];
            int i = 0;
            for (ServerSession serverSession : sessions) {
                sessionIDs[i++] = serverSession.getName();
            }
            String[] stringArray = sessionIDs;
            return stringArray;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getConnectors() throws Exception {
        this.clearIO();
        try {
            Collection<TransportConfiguration> connectorConfigurations = this.configuration.getConnectorConfigurations().values();
            Object[] ret = new Object[connectorConfigurations.size()];
            int i = 0;
            for (TransportConfiguration config : connectorConfigurations) {
                Object[] tc = new Object[]{config.getName(), config.getFactoryClassName(), config.getParams()};
                ret[i++] = tc;
            }
            Object[] objectArray = ret;
            return objectArray;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getConnectorsAsJSON() throws Exception {
        this.clearIO();
        try {
            JSONArray array = new JSONArray();
            for (TransportConfiguration config : this.configuration.getConnectorConfigurations().values()) {
                array.put(new JSONObject(config));
            }
            String string = array.toString();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendQueueInfoToQueue(String queueName, String address) throws Exception {
        this.clearIO();
        try {
            this.postOffice.sendQueueInfoToQueue(new SimpleString(queueName), new SimpleString(address));
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        this.clearIO();
        try {
            this.broadcaster.removeNotificationListener(listener, filter, handback);
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        this.clearIO();
        try {
            this.broadcaster.removeNotificationListener(listener);
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws IllegalArgumentException {
        this.clearIO();
        try {
            this.broadcaster.addNotificationListener(listener, filter, handback);
        }
        finally {
            this.blockOnIO();
        }
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        NotificationType[] values = NotificationType.values();
        String[] names = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            names[i] = values[i].toString();
        }
        return new MBeanNotificationInfo[]{new MBeanNotificationInfo(names, this.getClass().getName(), "Notifications emitted by a Core Server")};
    }

    private synchronized void setMessageCounterEnabled(boolean enable) {
        if (this.isStarted()) {
            if (this.configuration.isMessageCounterEnabled() && !enable) {
                this.stopMessageCounters();
            } else if (!this.configuration.isMessageCounterEnabled() && enable) {
                this.startMessageCounters();
            }
        }
        this.configuration.setMessageCounterEnabled(enable);
    }

    private void startMessageCounters() {
        this.messageCounterManager.start();
    }

    private void stopMessageCounters() {
        this.messageCounterManager.stop();
        this.messageCounterManager.resetAllCounters();
        this.messageCounterManager.resetAllCounterHistories();
    }

    public long getConnectionTTLOverride() {
        return this.configuration.getConnectionTTLOverride();
    }

    public int getIDCacheSize() {
        return this.configuration.getIDCacheSize();
    }

    public String getLargeMessagesDirectory() {
        return this.configuration.getLargeMessagesDirectory();
    }

    public String getManagementAddress() {
        return this.configuration.getManagementAddress().toString();
    }

    public String getManagementNotificationAddress() {
        return this.configuration.getManagementNotificationAddress().toString();
    }

    public long getMessageExpiryScanPeriod() {
        return this.configuration.getMessageExpiryScanPeriod();
    }

    public long getMessageExpiryThreadPriority() {
        return this.configuration.getMessageExpiryThreadPriority();
    }

    public long getTransactionTimeout() {
        return this.configuration.getTransactionTimeout();
    }

    public long getTransactionTimeoutScanPeriod() {
        return this.configuration.getTransactionTimeoutScanPeriod();
    }

    public boolean isPersistDeliveryCountBeforeDelivery() {
        return this.configuration.isPersistDeliveryCountBeforeDelivery();
    }

    public boolean isPersistIDCache() {
        return this.configuration.isPersistIDCache();
    }

    public boolean isWildcardRoutingEnabled() {
        return this.configuration.isWildcardRoutingEnabled();
    }

    MBeanOperationInfo[] fillMBeanOperationInfo() {
        return MBeanInfoHelper.getMBeanOperationsInfo(HornetQServerControl.class);
    }
}

