/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.messagecounter;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import org.hornetq.api.core.management.QueueControl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageCounter {
    private final String destName;
    private final String destSubscription;
    private final boolean destTopic;
    private final boolean destDurable;
    private final QueueControl destQueue;
    private long countTotal;
    private long countTotalLast;
    private int depthLast;
    private long timeLastUpdate;
    private long timeLastAdd;
    private int dayCounterMax;
    private final List<DayCounter> dayCounters;
    private int lastMessagesAdded;

    public MessageCounter(String name, String subscription, QueueControl queue, boolean topic, boolean durable, int daycountmax) {
        this.destName = name;
        this.destSubscription = subscription;
        this.destTopic = topic;
        this.destDurable = durable;
        this.destQueue = queue;
        this.resetCounter();
        this.dayCounters = new ArrayList<DayCounter>();
        this.setHistoryLimit(daycountmax);
    }

    public synchronized void onTimer() {
        int latestMessagesAdded = this.destQueue.getMessagesAdded();
        int newMessagesAdded = latestMessagesAdded - this.lastMessagesAdded;
        this.countTotal += (long)newMessagesAdded;
        this.lastMessagesAdded = latestMessagesAdded;
        if (newMessagesAdded > 0) {
            this.timeLastAdd = System.currentTimeMillis();
        }
        this.timeLastUpdate = System.currentTimeMillis();
        this.updateHistory(newMessagesAdded);
    }

    public String getDestinationName() {
        return this.destName;
    }

    public String getDestinationSubscription() {
        return this.destSubscription;
    }

    public boolean isDestinationTopic() {
        return this.destTopic;
    }

    public boolean isDestinationDurable() {
        return this.destDurable;
    }

    public long getCount() {
        return this.countTotal;
    }

    public long getCountDelta() {
        long delta = this.countTotal - this.countTotalLast;
        this.countTotalLast = this.countTotal;
        return delta;
    }

    public int getMessageCount() {
        return this.destQueue.getMessageCount();
    }

    public int getMessageCountDelta() {
        int current = this.destQueue.getMessageCount();
        int delta = current - this.depthLast;
        this.depthLast = current;
        return delta;
    }

    public long getLastUpdate() {
        return this.timeLastUpdate;
    }

    public long getLastAddedMessageTime() {
        return this.timeLastAdd;
    }

    public void resetCounter() {
        this.countTotal = 0L;
        this.countTotalLast = 0L;
        this.depthLast = 0;
        this.timeLastUpdate = 0L;
        this.timeLastAdd = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setHistoryLimit(int daycountmax) {
        boolean bInitialize = false;
        this.dayCounterMax = daycountmax;
        List<DayCounter> list = this.dayCounters;
        synchronized (list) {
            if (this.dayCounterMax > 0) {
                int delta = this.dayCounters.size() - this.dayCounterMax;
                for (int i = 0; i < delta; ++i) {
                    this.dayCounters.remove(0);
                }
                bInitialize = this.dayCounters.isEmpty();
            } else if (this.dayCounterMax == 0) {
                this.dayCounters.clear();
            } else {
                bInitialize = this.dayCounters.isEmpty();
            }
            if (bInitialize) {
                this.dayCounters.add(new DayCounter(new GregorianCalendar(), true));
            }
        }
    }

    public void resetHistory() {
        int max = this.dayCounterMax;
        this.setHistoryLimit(0);
        this.setHistoryLimit(max);
    }

    public List<DayCounter> getHistory() {
        this.updateHistory(0);
        return new ArrayList<DayCounter>(this.dayCounters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getHistoryAsString() {
        String ret = "";
        this.updateHistory(0);
        List<DayCounter> list = this.dayCounters;
        synchronized (list) {
            ret = ret + this.dayCounters.size() + "\n";
            for (int i = 0; i < this.dayCounters.size(); ++i) {
                DayCounter counter = this.dayCounters.get(i);
                ret = ret + counter.getDayCounterAsString() + "\n";
            }
        }
        return ret;
    }

    public String toString() {
        return "MessageCounter[destName" + this.destName + ", destSubscription=" + this.destSubscription + ", destTopic=" + this.destTopic + ", destDurable=" + this.destDurable + ", destQueue=" + this.destQueue + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateHistory(int newMessages) {
        if (this.dayCounters.isEmpty()) {
            return;
        }
        List<DayCounter> list = this.dayCounters;
        synchronized (list) {
            DayCounter counterLast = this.dayCounters.get(this.dayCounters.size() - 1);
            GregorianCalendar calNow = new GregorianCalendar();
            GregorianCalendar calLast = counterLast.getDate();
            calNow.clear(9);
            calNow.clear(10);
            calNow.clear(11);
            calNow.clear(12);
            calNow.clear(13);
            calNow.clear(14);
            calLast.clear(9);
            calLast.clear(10);
            calLast.clear(11);
            calLast.clear(12);
            calLast.clear(13);
            calLast.clear(14);
            long millisPerDay = 86400000L;
            long millisDelta = calNow.getTime().getTime() - calLast.getTime().getTime();
            int dayDelta = (int)(millisDelta / millisPerDay);
            if (dayDelta > 0) {
                DayCounter counterNew;
                counterLast.finalizeDayCounter();
                for (int i = 1; i < dayDelta; ++i) {
                    calLast.add(6, 1);
                    counterNew = new DayCounter(calLast, false);
                    counterNew.finalizeDayCounter();
                    this.dayCounters.add(counterNew);
                }
                counterNew = new DayCounter(calNow, false);
                this.dayCounters.add(counterNew);
                this.setHistoryLimit(this.dayCounterMax);
            }
            counterLast = this.dayCounters.get(this.dayCounters.size() - 1);
            counterLast.updateDayCounter(newMessages);
        }
    }

    public static class DayCounter {
        static final int HOURS = 24;
        GregorianCalendar date = null;
        int[] counters = new int[24];

        DayCounter(GregorianCalendar date, boolean isStartDay) {
            this.date = (GregorianCalendar)date.clone();
            int hour = date.get(11);
            for (int i = 0; i < 24; ++i) {
                if (i < hour) {
                    if (isStartDay) {
                        this.counters[i] = -1;
                        continue;
                    }
                    this.counters[i] = 0;
                    continue;
                }
                this.counters[i] = -1;
            }
            this.counters[hour] = 0;
        }

        public GregorianCalendar getDate() {
            return (GregorianCalendar)this.date.clone();
        }

        public int[] getCounters() {
            return this.counters;
        }

        void updateDayCounter(int newMessages) {
            GregorianCalendar cal = new GregorianCalendar();
            int currentIndex = cal.get(11);
            boolean bUpdate = false;
            for (int i = 0; i <= currentIndex; ++i) {
                if (this.counters[i] > -1) {
                    bUpdate = true;
                }
                if (!bUpdate || this.counters[i] != -1) continue;
                this.counters[i] = 0;
            }
            int n = currentIndex;
            this.counters[n] = this.counters[n] + newMessages;
        }

        void finalizeDayCounter() {
            boolean bFinalize = false;
            for (int i = 0; i < 24; ++i) {
                if (this.counters[i] > -1) {
                    bFinalize = true;
                }
                if (!bFinalize || this.counters[i] != -1) continue;
                this.counters[i] = 0;
            }
        }

        String getDayCounterAsString() {
            DateFormat dateFormat = DateFormat.getDateInstance(3);
            String strData = dateFormat.format(this.date.getTime());
            for (int i = 0; i < 24; ++i) {
                strData = strData + "," + this.counters[i];
            }
            return strData;
        }
    }
}

