/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.persistence.impl.journal;

import java.util.concurrent.atomic.AtomicLong;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.core.journal.EncodingSupport;
import org.hornetq.core.journal.Journal;
import org.hornetq.core.logging.Logger;
import org.hornetq.utils.IDGenerator;

public class BatchingIDGenerator
implements IDGenerator {
    private static final Logger log = Logger.getLogger(BatchingIDGenerator.class);
    private final AtomicLong counter;
    private final Journal journalStorage;
    private final long checkpointSize;
    private volatile long nextID;

    public BatchingIDGenerator(long start, long checkpointSize, Journal journalstorage) {
        this.counter = new AtomicLong(start);
        this.nextID = start;
        this.checkpointSize = checkpointSize;
        this.journalStorage = journalstorage;
    }

    public void close() {
        this.storeID(this.counter.incrementAndGet(), this.counter.get());
    }

    public void loadState(long journalID, HornetQBuffer buffer) {
        IDCounterEncoding encoding = new IDCounterEncoding();
        encoding.decode(buffer);
        this.nextID = encoding.id;
        this.counter.set(this.nextID);
    }

    public long generateID() {
        long id = this.counter.getAndIncrement();
        if (id >= this.nextID) {
            this.saveCheckPoint(id);
            return id;
        }
        return id;
    }

    public long getCurrentID() {
        return this.counter.get();
    }

    private synchronized void saveCheckPoint(long id) {
        if (id >= this.nextID) {
            this.nextID += this.checkpointSize;
            this.storeID(this.counter.incrementAndGet(), this.nextID);
        }
    }

    private void storeID(long journalID, long id) {
        try {
            this.journalStorage.appendAddRecord(journalID, (byte)24, new IDCounterEncoding(id), true);
        }
        catch (Exception e) {
            log.error("Failed to store id", e);
        }
    }

    private static final class IDCounterEncoding
    implements EncodingSupport {
        long id;

        IDCounterEncoding(long id) {
            this.id = id;
        }

        IDCounterEncoding() {
        }

        public void decode(HornetQBuffer buffer) {
            this.id = buffer.readLong();
        }

        public void encode(HornetQBuffer buffer) {
            buffer.writeLong(this.id);
        }

        public int getEncodeSize() {
            return 8;
        }
    }
}

