/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.postoffice.impl;

import org.hornetq.api.core.SimpleString;
import org.hornetq.core.filter.Filter;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.postoffice.BindingType;
import org.hornetq.core.postoffice.QueueBinding;
import org.hornetq.core.server.Bindable;
import org.hornetq.core.server.Queue;
import org.hornetq.core.server.RoutingContext;
import org.hornetq.core.server.ServerMessage;

public class LocalQueueBinding
implements QueueBinding {
    private static final Logger log = Logger.getLogger(LocalQueueBinding.class);
    private final SimpleString address;
    private final Queue queue;
    private final Filter filter;
    private final SimpleString name;
    private final SimpleString clusterName;

    public LocalQueueBinding(SimpleString address, Queue queue, SimpleString nodeID) {
        this.address = address;
        this.queue = queue;
        this.filter = queue.getFilter();
        this.name = queue.getName();
        this.clusterName = this.name.concat(nodeID);
    }

    public long getID() {
        return this.queue.getID();
    }

    public Filter getFilter() {
        return this.filter;
    }

    public SimpleString getAddress() {
        return this.address;
    }

    public Bindable getBindable() {
        return this.queue;
    }

    public Queue getQueue() {
        return this.queue;
    }

    public SimpleString getRoutingName() {
        return this.name;
    }

    public SimpleString getUniqueName() {
        return this.name;
    }

    public SimpleString getClusterName() {
        return this.clusterName;
    }

    public boolean isExclusive() {
        return false;
    }

    public int getDistance() {
        return 0;
    }

    public boolean isHighAcceptPriority(ServerMessage message) {
        return this.queue.hasMatchingConsumer(message);
    }

    public void route(ServerMessage message, RoutingContext context) throws Exception {
        this.queue.route(message, context);
    }

    public boolean isQueueBinding() {
        return true;
    }

    public int consumerCount() {
        return this.queue.getConsumerCount();
    }

    public BindingType getType() {
        return BindingType.LOCAL_QUEUE;
    }

    public String toString() {
        return "LocalQueueBinding [address=" + this.address + ", name=" + this.name + ", filter=" + this.filter + "]";
    }
}

