/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.remoting.impl;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.HornetQException;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.remoting.Channel;
import org.hornetq.core.remoting.ChannelHandler;
import org.hornetq.core.remoting.CommandConfirmationHandler;
import org.hornetq.core.remoting.Packet;
import org.hornetq.core.remoting.RemotingConnection;
import org.hornetq.core.remoting.impl.RemotingConnectionImpl;
import org.hornetq.core.remoting.impl.wireformat.HornetQExceptionMessage;
import org.hornetq.core.remoting.impl.wireformat.PacketsConfirmedMessage;

public class ChannelImpl
implements Channel {
    private static final Logger log = Logger.getLogger(ChannelImpl.class);
    private volatile long id;
    private ChannelHandler handler;
    private Packet response;
    private final Queue<Packet> resendCache;
    private volatile int firstStoredCommandID;
    private volatile int lastConfirmedCommandID = -1;
    private volatile RemotingConnection connection;
    private volatile boolean closed;
    private final Lock lock = new ReentrantLock();
    private final Condition sendCondition = this.lock.newCondition();
    private final Condition failoverCondition = this.lock.newCondition();
    private final Object sendLock = new Object();
    private final Object sendBlockingLock = new Object();
    private boolean failingOver;
    private final int confWindowSize;
    private int receivedBytes;
    private CommandConfirmationHandler commandConfirmationHandler;
    private volatile boolean transferring;

    public ChannelImpl(RemotingConnection connection, long id, int confWindowSize) {
        this.connection = connection;
        this.id = id;
        this.confWindowSize = confWindowSize;
        this.resendCache = confWindowSize != -1 ? new ConcurrentLinkedQueue<Packet>() : null;
    }

    public long getID() {
        return this.id;
    }

    public int getLastConfirmedCommandID() {
        return this.lastConfirmedCommandID;
    }

    public Lock getLock() {
        return this.lock;
    }

    public int getConfirmationWindowSize() {
        return this.confWindowSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnBlocking() {
        this.lock.lock();
        try {
            this.response = new HornetQExceptionMessage(new HornetQException(5, "Connection failure detected. Unblocking a blocking call that will never get a response"));
            this.sendCondition.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void sendAndFlush(Packet packet) {
        this.send(packet, true);
    }

    public void send(Packet packet) {
        this.send(packet, false);
    }

    public void setTransferring(boolean transferring) {
        this.transferring = transferring;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Packet packet, boolean flush) {
        Object object = this.sendLock;
        synchronized (object) {
            packet.setChannelID(this.id);
            HornetQBuffer buffer = packet.encode(this.connection);
            this.lock.lock();
            try {
                while (this.failingOver) {
                    try {
                        this.failoverCondition.await(10000L, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException e) {}
                }
                if (this.transferring) {
                    throw new IllegalStateException("Cannot send a packet while channel is doing failover");
                }
                if (this.resendCache != null && packet.isRequiresConfirmations()) {
                    this.resendCache.add(packet);
                }
                this.connection.getTransportConnection().write(buffer, flush);
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Packet sendBlocking(Packet packet) throws HornetQException {
        if (this.closed) {
            throw new HornetQException(2, "Connection is destroyed");
        }
        if (this.connection.getBlockingCallTimeout() == -1L) {
            throw new IllegalStateException("Cannot do a blocking call timeout on a server side connection");
        }
        Object object = this.sendBlockingLock;
        synchronized (object) {
            packet.setChannelID(this.id);
            HornetQBuffer buffer = packet.encode(this.connection);
            this.lock.lock();
            try {
                long now;
                while (this.failingOver) {
                    try {
                        this.failoverCondition.await(10000L, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException e) {}
                }
                this.response = null;
                if (this.resendCache != null && packet.isRequiresConfirmations()) {
                    this.resendCache.add(packet);
                }
                this.connection.getTransportConnection().write(buffer);
                long start = System.currentTimeMillis();
                for (long toWait = this.connection.getBlockingCallTimeout(); this.response == null && toWait > 0L; toWait -= now - start) {
                    try {
                        this.sendCondition.await(toWait, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    if (this.closed) break;
                    now = System.currentTimeMillis();
                    start = now;
                }
                if (this.response == null) {
                    throw new HornetQException(3, "Timed out waiting for response when sending packet " + packet.getType());
                }
                if (this.response.getType() == 20) {
                    HornetQExceptionMessage mem = (HornetQExceptionMessage)this.response;
                    HornetQException e = mem.getException();
                    e.fillInStackTrace();
                    throw e;
                }
            }
            finally {
                this.lock.unlock();
            }
            return this.response;
        }
    }

    public void setCommandConfirmationHandler(CommandConfirmationHandler handler) {
        this.commandConfirmationHandler = handler;
    }

    public void setHandler(ChannelHandler handler) {
        this.handler = handler;
    }

    public void close() {
        if (this.closed) {
            return;
        }
        if (!this.connection.isDestroyed() && !this.connection.removeChannel(this.id)) {
            throw new IllegalArgumentException("Cannot find channel with id " + this.id + " to close");
        }
        this.closed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transferConnection(RemotingConnection newConnection) {
        Object object = this.connection.getTransferLock();
        synchronized (object) {
            this.connection.removeChannel(this.id);
            RemotingConnectionImpl rnewConnection = (RemotingConnectionImpl)newConnection;
            rnewConnection.putChannel(this.id, this);
            this.connection = rnewConnection;
            this.transferring = true;
        }
    }

    public void replayCommands(int otherLastConfirmedCommandID, long newChannelID) {
        if (this.resendCache != null) {
            this.clearUpTo(otherLastConfirmedCommandID);
            for (Packet packet : this.resendCache) {
                packet.setChannelID(newChannelID);
                this.doWrite(packet);
            }
        }
    }

    public void lock() {
        this.lock.lock();
        this.failingOver = true;
        this.lock.unlock();
    }

    public void unlock() {
        this.lock.lock();
        this.failingOver = false;
        this.failoverCondition.signalAll();
        this.lock.unlock();
    }

    public RemotingConnection getConnection() {
        return this.connection;
    }

    public synchronized void flushConfirmations() {
        if (this.resendCache != null && this.receivedBytes != 0) {
            this.receivedBytes = 0;
            PacketsConfirmedMessage confirmed = new PacketsConfirmedMessage(this.lastConfirmedCommandID);
            confirmed.setChannelID(this.id);
            this.doWrite(confirmed);
        }
    }

    public void confirm(Packet packet) {
        if (this.resendCache != null && packet.isRequiresConfirmations()) {
            ++this.lastConfirmedCommandID;
            this.receivedBytes += packet.getPacketSize();
            if (this.receivedBytes >= this.confWindowSize) {
                this.receivedBytes = 0;
                PacketsConfirmedMessage confirmed = new PacketsConfirmedMessage(this.lastConfirmedCommandID);
                confirmed.setChannelID(this.id);
                this.doWrite(confirmed);
            }
        }
    }

    public void clearCommands() {
        if (this.resendCache != null) {
            this.lastConfirmedCommandID = -1;
            this.firstStoredCommandID = 0;
            this.resendCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handlePacket(Packet packet) {
        if (packet.getType() == 22) {
            if (this.resendCache != null) {
                PacketsConfirmedMessage msg = (PacketsConfirmedMessage)packet;
                this.clearUpTo(msg.getCommandID());
            }
            if (!this.connection.isClient()) {
                this.handler.handlePacket(packet);
            }
            return;
        }
        if (packet.isResponse()) {
            this.confirm(packet);
            this.lock.lock();
            this.response = packet;
            try {
                this.sendCondition.signal();
            }
            finally {
                this.lock.unlock();
            }
        } else if (this.handler != null) {
            this.handler.handlePacket(packet);
        }
    }

    private void doWrite(Packet packet) {
        HornetQBuffer buffer = packet.encode(this.connection);
        this.connection.getTransportConnection().write(buffer);
    }

    private void clearUpTo(int lastReceivedCommandID) {
        int numberToClear = 1 + lastReceivedCommandID - this.firstStoredCommandID;
        if (numberToClear == -1) {
            throw new IllegalArgumentException("Invalid lastReceivedCommandID: " + lastReceivedCommandID);
        }
        int sizeToFree = 0;
        for (int i = 0; i < numberToClear; ++i) {
            Packet packet = this.resendCache.poll();
            if (packet == null) {
                log.warn("Can't find packet to clear:  last received command id " + lastReceivedCommandID + " first stored command id " + this.firstStoredCommandID);
                return;
            }
            if (packet.getType() != 22) {
                sizeToFree += packet.getPacketSize();
            }
            if (this.commandConfirmationHandler == null) continue;
            this.commandConfirmationHandler.commandConfirmed(packet);
        }
        this.firstStoredCommandID += numberToClear;
    }
}

