/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.remoting.impl.wireformat;

import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.core.journal.EncodingSupport;
import org.hornetq.core.remoting.impl.wireformat.PacketImpl;

public class ReplicationAddTXMessage
extends PacketImpl {
    private long txId;
    private long id;
    private byte journalID;
    private boolean isUpdate;
    private byte recordType;
    private EncodingSupport encodingData;
    private byte[] recordData;

    public ReplicationAddTXMessage() {
        super((byte)92);
    }

    public ReplicationAddTXMessage(byte journalID, boolean isUpdate, long txId, long id, byte recordType, EncodingSupport encodingData) {
        this();
        this.journalID = journalID;
        this.isUpdate = isUpdate;
        this.txId = txId;
        this.id = id;
        this.recordType = recordType;
        this.encodingData = encodingData;
    }

    public void encodeRest(HornetQBuffer buffer) {
        buffer.writeByte(this.journalID);
        buffer.writeBoolean(this.isUpdate);
        buffer.writeLong(this.txId);
        buffer.writeLong(this.id);
        buffer.writeByte(this.recordType);
        buffer.writeInt(this.encodingData.getEncodeSize());
        this.encodingData.encode(buffer);
    }

    public void decodeRest(HornetQBuffer buffer) {
        this.journalID = buffer.readByte();
        this.isUpdate = buffer.readBoolean();
        this.txId = buffer.readLong();
        this.id = buffer.readLong();
        this.recordType = buffer.readByte();
        int size = buffer.readInt();
        this.recordData = new byte[size];
        buffer.readBytes(this.recordData);
    }

    public long getId() {
        return this.id;
    }

    public long getTxId() {
        return this.txId;
    }

    public byte getJournalID() {
        return this.journalID;
    }

    public boolean isUpdate() {
        return this.isUpdate;
    }

    public byte getRecordType() {
        return this.recordType;
    }

    public byte[] getRecordData() {
        return this.recordData;
    }
}

