/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.remoting.impl.wireformat;

import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.core.journal.EncodingSupport;
import org.hornetq.core.remoting.impl.wireformat.PacketImpl;

public class ReplicationPrepareMessage
extends PacketImpl {
    private long txId;
    private byte journalID;
    private EncodingSupport encodingData;
    private byte[] recordData;

    public ReplicationPrepareMessage() {
        super((byte)95);
    }

    public ReplicationPrepareMessage(byte journalID, long txId, EncodingSupport encodingData) {
        this();
        this.journalID = journalID;
        this.txId = txId;
        this.encodingData = encodingData;
    }

    public void encodeRest(HornetQBuffer buffer) {
        buffer.writeByte(this.journalID);
        buffer.writeLong(this.txId);
        buffer.writeInt(this.encodingData.getEncodeSize());
        this.encodingData.encode(buffer);
    }

    public void decodeRest(HornetQBuffer buffer) {
        this.journalID = buffer.readByte();
        this.txId = buffer.readLong();
        int size = buffer.readInt();
        this.recordData = new byte[size];
        buffer.readBytes(this.recordData);
    }

    public long getTxId() {
        return this.txId;
    }

    public byte getJournalID() {
        return this.journalID;
    }

    public byte[] getRecordData() {
        return this.recordData;
    }
}

