/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.remoting.impl.wireformat;

import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.SimpleString;
import org.hornetq.core.remoting.impl.wireformat.PacketImpl;

public class SessionCreateConsumerMessage
extends PacketImpl {
    private long id;
    private SimpleString queueName;
    private SimpleString filterString;
    private boolean browseOnly;
    private boolean requiresResponse;

    public SessionCreateConsumerMessage(long id, SimpleString queueName, SimpleString filterString, boolean browseOnly, boolean requiresResponse) {
        super((byte)40);
        this.id = id;
        this.queueName = queueName;
        this.filterString = filterString;
        this.browseOnly = browseOnly;
        this.requiresResponse = requiresResponse;
    }

    public SessionCreateConsumerMessage() {
        super((byte)40);
    }

    public String toString() {
        StringBuffer buff = new StringBuffer(this.getParentString());
        buff.append(", queueName=" + this.queueName);
        buff.append(", filterString=" + this.filterString);
        buff.append("]");
        return buff.toString();
    }

    public long getID() {
        return this.id;
    }

    public SimpleString getQueueName() {
        return this.queueName;
    }

    public SimpleString getFilterString() {
        return this.filterString;
    }

    public boolean isBrowseOnly() {
        return this.browseOnly;
    }

    public boolean isRequiresResponse() {
        return this.requiresResponse;
    }

    public void encodeRest(HornetQBuffer buffer) {
        buffer.writeLong(this.id);
        buffer.writeSimpleString(this.queueName);
        buffer.writeNullableSimpleString(this.filterString);
        buffer.writeBoolean(this.browseOnly);
        buffer.writeBoolean(this.requiresResponse);
    }

    public void decodeRest(HornetQBuffer buffer) {
        this.id = buffer.readLong();
        this.queueName = buffer.readSimpleString();
        this.filterString = buffer.readNullableSimpleString();
        this.browseOnly = buffer.readBoolean();
        this.requiresResponse = buffer.readBoolean();
    }

    public boolean equals(Object other) {
        if (!(other instanceof SessionCreateConsumerMessage)) {
            return false;
        }
        SessionCreateConsumerMessage r = (SessionCreateConsumerMessage)other;
        return super.equals(other) && this.queueName.equals(r.queueName) && this.filterString == null ? r.filterString == null : this.filterString.equals(r.filterString);
    }
}

