/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.remoting.impl.wireformat;

import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.core.remoting.impl.wireformat.PacketImpl;

public class SessionExpiredMessage
extends PacketImpl {
    private long consumerID;
    private long messageID;

    public SessionExpiredMessage(long consumerID, long messageID) {
        super((byte)42);
        this.consumerID = consumerID;
        this.messageID = messageID;
    }

    public SessionExpiredMessage() {
        super((byte)42);
    }

    public long getConsumerID() {
        return this.consumerID;
    }

    public long getMessageID() {
        return this.messageID;
    }

    public void encodeRest(HornetQBuffer buffer) {
        buffer.writeLong(this.consumerID);
        buffer.writeLong(this.messageID);
    }

    public void decodeRest(HornetQBuffer buffer) {
        this.consumerID = buffer.readLong();
        this.messageID = buffer.readLong();
    }

    public boolean equals(Object other) {
        if (!(other instanceof SessionExpiredMessage)) {
            return false;
        }
        SessionExpiredMessage r = (SessionExpiredMessage)other;
        return super.equals(other) && this.consumerID == r.consumerID && this.messageID == r.messageID;
    }
}

