/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.remoting.impl.wireformat;

import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.SimpleString;
import org.hornetq.core.remoting.impl.wireformat.PacketImpl;

public class SessionQueueQueryResponseMessage
extends PacketImpl {
    private SimpleString name;
    private boolean exists;
    private boolean durable;
    private int consumerCount;
    private int messageCount;
    private SimpleString filterString;
    private SimpleString address;
    private boolean temporary;

    public SessionQueueQueryResponseMessage(SimpleString name, SimpleString address, boolean durable, boolean temporary, SimpleString filterString, int consumerCount, int messageCount) {
        this(name, address, durable, temporary, filterString, consumerCount, messageCount, true);
    }

    public SessionQueueQueryResponseMessage() {
        this(null, null, false, false, null, 0, 0, false);
    }

    private SessionQueueQueryResponseMessage(SimpleString name, SimpleString address, boolean durable, boolean temporary, SimpleString filterString, int consumerCount, int messageCount, boolean exists) {
        super((byte)46);
        this.durable = durable;
        this.temporary = temporary;
        this.consumerCount = consumerCount;
        this.messageCount = messageCount;
        this.filterString = filterString;
        this.address = address;
        this.name = name;
        this.exists = exists;
    }

    public boolean isResponse() {
        return true;
    }

    public boolean isExists() {
        return this.exists;
    }

    public boolean isDurable() {
        return this.durable;
    }

    public int getConsumerCount() {
        return this.consumerCount;
    }

    public int getMessageCount() {
        return this.messageCount;
    }

    public SimpleString getFilterString() {
        return this.filterString;
    }

    public SimpleString getAddress() {
        return this.address;
    }

    public SimpleString getName() {
        return this.name;
    }

    public boolean isTemporary() {
        return this.temporary;
    }

    public void encodeRest(HornetQBuffer buffer) {
        buffer.writeBoolean(this.exists);
        buffer.writeBoolean(this.durable);
        buffer.writeBoolean(this.temporary);
        buffer.writeInt(this.consumerCount);
        buffer.writeInt(this.messageCount);
        buffer.writeNullableSimpleString(this.filterString);
        buffer.writeNullableSimpleString(this.address);
        buffer.writeNullableSimpleString(this.name);
    }

    public void decodeRest(HornetQBuffer buffer) {
        this.exists = buffer.readBoolean();
        this.durable = buffer.readBoolean();
        this.temporary = buffer.readBoolean();
        this.consumerCount = buffer.readInt();
        this.messageCount = buffer.readInt();
        this.filterString = buffer.readNullableSimpleString();
        this.address = buffer.readNullableSimpleString();
        this.name = buffer.readNullableSimpleString();
    }

    public boolean equals(Object other) {
        if (!(other instanceof SessionQueueQueryResponseMessage)) {
            return false;
        }
        SessionQueueQueryResponseMessage r = (SessionQueueQueryResponseMessage)other;
        return super.equals(other) && this.exists == r.exists && this.durable == r.durable && this.consumerCount == r.consumerCount && this.messageCount == r.messageCount && this.filterString == null ? r.filterString == null : (this.filterString.equals(r.filterString) && this.address == null ? r.address == null : this.address.equals(r.address));
    }
}

