/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.remoting.impl.wireformat;

import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.core.remoting.impl.wireformat.PacketImpl;

public class SessionReceiveLargeMessage
extends PacketImpl {
    private byte[] largeMessageHeader;
    private long largeMessageSize;
    private long consumerID;
    private int deliveryCount;

    public SessionReceiveLargeMessage() {
        super((byte)76);
    }

    public SessionReceiveLargeMessage(long consumerID, byte[] largeMessageHeader, long largeMessageSize, int deliveryCount) {
        super((byte)76);
        this.consumerID = consumerID;
        this.largeMessageHeader = largeMessageHeader;
        this.deliveryCount = deliveryCount;
        this.largeMessageSize = largeMessageSize;
    }

    public byte[] getLargeMessageHeader() {
        return this.largeMessageHeader;
    }

    public long getConsumerID() {
        return this.consumerID;
    }

    public int getDeliveryCount() {
        return this.deliveryCount;
    }

    public long getLargeMessageSize() {
        return this.largeMessageSize;
    }

    public void encodeRest(HornetQBuffer buffer) {
        buffer.writeLong(this.consumerID);
        buffer.writeInt(this.deliveryCount);
        buffer.writeLong(this.largeMessageSize);
        buffer.writeInt(this.largeMessageHeader.length);
        buffer.writeBytes(this.largeMessageHeader);
    }

    public void decodeRest(HornetQBuffer buffer) {
        this.consumerID = buffer.readLong();
        this.deliveryCount = buffer.readInt();
        this.largeMessageSize = buffer.readLong();
        int size = buffer.readInt();
        this.largeMessageHeader = new byte[size];
        buffer.readBytes(this.largeMessageHeader);
    }
}

