/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.remoting.server.impl;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.Interceptor;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.core.config.Configuration;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.remoting.Channel;
import org.hornetq.core.remoting.ChannelHandler;
import org.hornetq.core.remoting.Packet;
import org.hornetq.core.remoting.RemotingConnection;
import org.hornetq.core.remoting.impl.AbstractBufferHandler;
import org.hornetq.core.remoting.impl.RemotingConnectionImpl;
import org.hornetq.core.remoting.impl.wireformat.PacketImpl;
import org.hornetq.core.remoting.impl.wireformat.Ping;
import org.hornetq.core.remoting.server.RemotingService;
import org.hornetq.core.server.HornetQServer;
import org.hornetq.core.server.impl.HornetQPacketHandler;
import org.hornetq.core.server.management.ManagementService;
import org.hornetq.spi.core.remoting.Acceptor;
import org.hornetq.spi.core.remoting.AcceptorFactory;
import org.hornetq.spi.core.remoting.BufferHandler;
import org.hornetq.spi.core.remoting.Connection;
import org.hornetq.spi.core.remoting.ConnectionLifeCycleListener;
import org.hornetq.utils.ConfigurationHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemotingServiceImpl
implements RemotingService,
ConnectionLifeCycleListener {
    private static final Logger log = Logger.getLogger(RemotingServiceImpl.class);
    public static final long CONNECTION_TTL_CHECK_INTERVAL = 2000L;
    private volatile boolean started = false;
    private final Set<TransportConfiguration> transportConfigs;
    private final List<Interceptor> interceptors = new CopyOnWriteArrayList<Interceptor>();
    private final Set<Acceptor> acceptors = new HashSet<Acceptor>();
    private final Map<Object, ConnectionEntry> connections = new ConcurrentHashMap<Object, ConnectionEntry>();
    private final BufferHandler bufferHandler = new DelegatingBufferHandler();
    private final Configuration config;
    private final HornetQServer server;
    private final ManagementService managementService;
    private volatile RemotingConnection serverSideReplicatingConnection;
    private final Executor threadPool;
    private final ScheduledExecutorService scheduledThreadPool;
    private FailureCheckAndFlushThread failureCheckAndFlushThread;

    public RemotingServiceImpl(Configuration config, HornetQServer server, ManagementService managementService, Executor threadPool, ScheduledExecutorService scheduledThreadPool) {
        this.transportConfigs = config.getAcceptorConfigurations();
        this.server = server;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        for (String interceptorClass : config.getInterceptorClassNames()) {
            try {
                Class<?> clazz = loader.loadClass(interceptorClass);
                this.interceptors.add((Interceptor)clazz.newInstance());
            }
            catch (Exception e) {
                log.warn("Error instantiating interceptor \"" + interceptorClass + "\"", e);
            }
        }
        this.config = config;
        this.managementService = managementService;
        this.threadPool = threadPool;
        this.scheduledThreadPool = scheduledThreadPool;
    }

    @Override
    public synchronized void start() throws Exception {
        if (this.started) {
            return;
        }
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        for (TransportConfiguration info : this.transportConfigs) {
            try {
                Set<String> invalid;
                Class<?> clazz = loader.loadClass(info.getFactoryClassName());
                AcceptorFactory factory = (AcceptorFactory)clazz.newInstance();
                if (info.getParams() != null && !(invalid = ConfigurationHelper.checkKeys(factory.getAllowableProperties(), info.getParams().keySet())).isEmpty()) {
                    log.warn(ConfigurationHelper.stringSetToCommaListString("The following keys are invalid for configuring the acceptor: ", invalid) + " the acceptor will not be started.");
                    continue;
                }
                Acceptor acceptor = factory.createAcceptor(info.getParams(), this.bufferHandler, this, this.threadPool, this.scheduledThreadPool);
                this.acceptors.add(acceptor);
                if (this.managementService == null) continue;
                acceptor.setNotificationService(this.managementService);
                this.managementService.registerAcceptor(acceptor, info);
            }
            catch (Exception e) {
                log.warn("Error instantiating acceptor \"" + info.getFactoryClassName() + "\"", e);
            }
        }
        for (Acceptor a : this.acceptors) {
            a.start();
        }
        this.failureCheckAndFlushThread = new FailureCheckAndFlushThread(2000L);
        this.failureCheckAndFlushThread.start();
        this.started = true;
    }

    @Override
    public synchronized void freeze() {
        for (Acceptor acceptor : this.acceptors) {
            try {
                acceptor.pause();
            }
            catch (Exception e) {
                log.error("Failed to stop acceptor", e);
            }
        }
    }

    @Override
    public void stop() throws Exception {
        if (!this.started) {
            return;
        }
        if (!this.started) {
            return;
        }
        this.failureCheckAndFlushThread.close();
        for (Acceptor acceptor : this.acceptors) {
            acceptor.pause();
        }
        for (ConnectionEntry entry : this.connections.values()) {
            RemotingConnection conn = entry.connection;
            Channel channel0 = conn.getChannel(0L, -1);
            conn.removeAllChannels();
            channel0.sendAndFlush(new PacketImpl(11));
        }
        for (Acceptor acceptor : this.acceptors) {
            acceptor.stop();
        }
        this.acceptors.clear();
        this.connections.clear();
        if (this.managementService != null) {
            this.managementService.unregisterAcceptors();
        }
        this.started = false;
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    @Override
    public RemotingConnection removeConnection(Object remotingConnectionID) {
        ConnectionEntry entry = this.connections.remove(remotingConnectionID);
        if (entry != null) {
            return entry.connection;
        }
        return null;
    }

    @Override
    public synchronized Set<RemotingConnection> getConnections() {
        HashSet<RemotingConnection> conns = new HashSet<RemotingConnection>();
        for (ConnectionEntry entry : this.connections.values()) {
            conns.add(entry.connection);
        }
        return conns;
    }

    @Override
    public RemotingConnection getServerSideReplicatingConnection() {
        return this.serverSideReplicatingConnection;
    }

    @Override
    public void connectionCreated(Connection connection) {
        if (this.server == null) {
            throw new IllegalStateException("Unable to create connection, server hasn't finished starting up");
        }
        RemotingConnectionImpl rc = new RemotingConnectionImpl(connection, this.interceptors, this.config.isAsyncConnectionExecutionEnabled() ? this.server.getExecutorFactory().getExecutor() : null);
        Channel channel1 = rc.getChannel(1L, -1);
        ChannelHandler handler = this.createHandler(rc, channel1);
        channel1.setHandler(handler);
        long ttl = 60000L;
        if (this.config.getConnectionTTLOverride() != -1L) {
            ttl = this.config.getConnectionTTLOverride();
        }
        final ConnectionEntry entry = new ConnectionEntry(rc, System.currentTimeMillis(), ttl);
        this.connections.put(connection.getID(), entry);
        final Channel channel0 = rc.getChannel(0L, -1);
        channel0.setHandler(new ChannelHandler(){

            public void handlePacket(Packet packet) {
                if (packet.getType() == 10) {
                    Ping ping = (Ping)packet;
                    if (RemotingServiceImpl.this.config.getConnectionTTLOverride() == -1L) {
                        entry.ttl = ping.getConnectionTTL();
                    }
                    channel0.send(packet);
                }
            }
        });
        if (this.config.isBackup()) {
            this.serverSideReplicatingConnection = rc;
        }
    }

    @Override
    public void connectionDestroyed(Object connectionID) {
        ConnectionEntry conn = this.connections.get(connectionID);
        if (conn != null && conn.connection.getFailureListeners().isEmpty()) {
            this.connections.remove(connectionID);
            conn.connection.destroy();
        }
    }

    @Override
    public void connectionException(Object connectionID, HornetQException me) {
    }

    @Override
    public void addInterceptor(Interceptor interceptor) {
        this.interceptors.add(interceptor);
    }

    @Override
    public boolean removeInterceptor(Interceptor interceptor) {
        return this.interceptors.remove(interceptor);
    }

    protected ChannelHandler createHandler(RemotingConnection rc, Channel channel) {
        return new HornetQPacketHandler(this.server, channel, rc);
    }

    private final class FailureCheckAndFlushThread
    extends Thread {
        private final long pauseInterval;
        private volatile boolean closed;

        FailureCheckAndFlushThread(long pauseInterval) {
            super("hornetq-failure-check-thread");
            this.pauseInterval = pauseInterval;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void close() {
            this.closed = true;
            FailureCheckAndFlushThread failureCheckAndFlushThread = this;
            synchronized (failureCheckAndFlushThread) {
                this.notify();
            }
            try {
                this.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this.closed) {
                RemotingConnection conn;
                long now = System.currentTimeMillis();
                HashSet<Object> idsToRemove = new HashSet<Object>();
                for (ConnectionEntry entry : RemotingServiceImpl.this.connections.values()) {
                    conn = entry.connection;
                    boolean flush = true;
                    if (entry.ttl != -1L && now >= entry.lastCheck + entry.ttl) {
                        if (!conn.checkDataReceived()) {
                            idsToRemove.add(conn.getID());
                            flush = false;
                        } else {
                            entry.lastCheck = now;
                        }
                    }
                    if (!flush) continue;
                    conn.flushConfirmations();
                }
                for (Object id : idsToRemove) {
                    conn = RemotingServiceImpl.this.removeConnection(id);
                    HornetQException me = new HornetQException(3, "Did not receive ping from " + conn.getRemoteAddress() + ". It is likely the client has exited or crashed without " + "closing its connection, or the network between the server and client has failed. The connection will now be closed.");
                    conn.fail(me);
                }
                FailureCheckAndFlushThread failureCheckAndFlushThread = this;
                synchronized (failureCheckAndFlushThread) {
                    long start = System.currentTimeMillis();
                    for (long toWait = this.pauseInterval; !this.closed && toWait > 0L; toWait -= now - start) {
                        try {
                            this.wait(toWait);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                        now = System.currentTimeMillis();
                        start = now;
                    }
                }
            }
        }
    }

    private static final class ConnectionEntry {
        final RemotingConnection connection;
        volatile long lastCheck;
        volatile long ttl;

        ConnectionEntry(RemotingConnection connection, long lastCheck, long ttl) {
            this.connection = connection;
            this.lastCheck = lastCheck;
            this.ttl = ttl;
        }
    }

    private final class DelegatingBufferHandler
    extends AbstractBufferHandler {
        private DelegatingBufferHandler() {
        }

        public void bufferReceived(Object connectionID, HornetQBuffer buffer) {
            ConnectionEntry conn = (ConnectionEntry)RemotingServiceImpl.this.connections.get(connectionID);
            if (conn != null) {
                conn.connection.bufferReceived(connectionID, buffer);
            }
        }
    }
}

