/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.replication.impl;

import java.util.List;
import org.hornetq.core.journal.EncodingSupport;
import org.hornetq.core.journal.IOCompletion;
import org.hornetq.core.journal.Journal;
import org.hornetq.core.journal.JournalLoadInformation;
import org.hornetq.core.journal.LoaderCallback;
import org.hornetq.core.journal.PreparedTransactionInfo;
import org.hornetq.core.journal.RecordInfo;
import org.hornetq.core.journal.TransactionFailureCallback;
import org.hornetq.core.journal.impl.dataformat.ByteArrayEncoding;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.replication.ReplicationManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplicatedJournal
implements Journal {
    private static final Logger log = Logger.getLogger(ReplicatedJournal.class);
    private static final boolean trace = false;
    private final ReplicationManager replicationManager;
    private final Journal localJournal;
    private final byte journalID;

    private static void trace(String message) {
        System.out.println("ReplicatedJournal::" + message);
    }

    public ReplicatedJournal(byte journaID, Journal localJournal, ReplicationManager replicationManager) {
        this.journalID = journaID;
        this.localJournal = localJournal;
        this.replicationManager = replicationManager;
    }

    @Override
    public void appendAddRecord(long id, byte recordType, byte[] record, boolean sync) throws Exception {
        this.appendAddRecord(id, recordType, new ByteArrayEncoding(record), sync);
    }

    @Override
    public void appendAddRecord(long id, byte recordType, EncodingSupport record, boolean sync) throws Exception {
        this.replicationManager.appendAddRecord(this.journalID, id, recordType, record);
        this.localJournal.appendAddRecord(id, recordType, record, sync);
    }

    @Override
    public void appendAddRecord(long id, byte recordType, byte[] record, boolean sync, IOCompletion completionCallback) throws Exception {
        this.appendAddRecord(id, recordType, new ByteArrayEncoding(record), sync, completionCallback);
    }

    @Override
    public void appendAddRecord(long id, byte recordType, EncodingSupport record, boolean sync, IOCompletion completionCallback) throws Exception {
        this.replicationManager.appendAddRecord(this.journalID, id, recordType, record);
        this.localJournal.appendAddRecord(id, recordType, record, sync, completionCallback);
    }

    @Override
    public void appendAddRecordTransactional(long txID, long id, byte recordType, byte[] record) throws Exception {
        this.appendAddRecordTransactional(txID, id, recordType, new ByteArrayEncoding(record));
    }

    @Override
    public void appendAddRecordTransactional(long txID, long id, byte recordType, EncodingSupport record) throws Exception {
        this.replicationManager.appendAddRecordTransactional(this.journalID, txID, id, recordType, record);
        this.localJournal.appendAddRecordTransactional(txID, id, recordType, record);
    }

    @Override
    public void appendCommitRecord(long txID, boolean sync) throws Exception {
        this.replicationManager.appendCommitRecord(this.journalID, txID);
        this.localJournal.appendCommitRecord(txID, sync);
    }

    @Override
    public void appendCommitRecord(long txID, boolean sync, IOCompletion callback) throws Exception {
        this.replicationManager.appendCommitRecord(this.journalID, txID);
        this.localJournal.appendCommitRecord(txID, sync, callback);
    }

    @Override
    public void appendDeleteRecord(long id, boolean sync) throws Exception {
        this.replicationManager.appendDeleteRecord(this.journalID, id);
        this.localJournal.appendDeleteRecord(id, sync);
    }

    @Override
    public void appendDeleteRecord(long id, boolean sync, IOCompletion completionCallback) throws Exception {
        this.replicationManager.appendDeleteRecord(this.journalID, id);
        this.localJournal.appendDeleteRecord(id, sync, completionCallback);
    }

    @Override
    public void appendDeleteRecordTransactional(long txID, long id, byte[] record) throws Exception {
        this.appendDeleteRecordTransactional(txID, id, new ByteArrayEncoding(record));
    }

    @Override
    public void appendDeleteRecordTransactional(long txID, long id, EncodingSupport record) throws Exception {
        this.replicationManager.appendDeleteRecordTransactional(this.journalID, txID, id, record);
        this.localJournal.appendDeleteRecordTransactional(txID, id, record);
    }

    @Override
    public void appendDeleteRecordTransactional(long txID, long id) throws Exception {
        this.replicationManager.appendDeleteRecordTransactional(this.journalID, txID, id);
        this.localJournal.appendDeleteRecordTransactional(txID, id);
    }

    @Override
    public void appendPrepareRecord(long txID, byte[] transactionData, boolean sync) throws Exception {
        this.appendPrepareRecord(txID, new ByteArrayEncoding(transactionData), sync);
    }

    @Override
    public void appendPrepareRecord(long txID, EncodingSupport transactionData, boolean sync) throws Exception {
        this.replicationManager.appendPrepareRecord(this.journalID, txID, transactionData);
        this.localJournal.appendPrepareRecord(txID, transactionData, sync);
    }

    @Override
    public void appendPrepareRecord(long txID, EncodingSupport transactionData, boolean sync, IOCompletion callback) throws Exception {
        this.replicationManager.appendPrepareRecord(this.journalID, txID, transactionData);
        this.localJournal.appendPrepareRecord(txID, transactionData, sync, callback);
    }

    @Override
    public void appendPrepareRecord(long txID, byte[] transactionData, boolean sync, IOCompletion callback) throws Exception {
        this.appendPrepareRecord(txID, new ByteArrayEncoding(transactionData), sync, callback);
    }

    @Override
    public void appendRollbackRecord(long txID, boolean sync) throws Exception {
        this.replicationManager.appendRollbackRecord(this.journalID, txID);
        this.localJournal.appendRollbackRecord(txID, sync);
    }

    @Override
    public void appendRollbackRecord(long txID, boolean sync, IOCompletion callback) throws Exception {
        this.replicationManager.appendRollbackRecord(this.journalID, txID);
        this.localJournal.appendRollbackRecord(txID, sync, callback);
    }

    @Override
    public void appendUpdateRecord(long id, byte recordType, byte[] record, boolean sync) throws Exception {
        this.appendUpdateRecord(id, recordType, new ByteArrayEncoding(record), sync);
    }

    @Override
    public void appendUpdateRecord(long id, byte recordType, EncodingSupport record, boolean sync) throws Exception {
        this.replicationManager.appendUpdateRecord(this.journalID, id, recordType, record);
        this.localJournal.appendUpdateRecord(id, recordType, record, sync);
    }

    @Override
    public void appendUpdateRecord(long id, byte recordType, byte[] record, boolean sync, IOCompletion completionCallback) throws Exception {
        this.appendUpdateRecord(id, recordType, new ByteArrayEncoding(record), sync, completionCallback);
    }

    @Override
    public void appendUpdateRecord(long id, byte recordType, EncodingSupport record, boolean sync, IOCompletion completionCallback) throws Exception {
        this.replicationManager.appendUpdateRecord(this.journalID, id, recordType, record);
        this.localJournal.appendUpdateRecord(id, recordType, record, sync, completionCallback);
    }

    @Override
    public void appendUpdateRecordTransactional(long txID, long id, byte recordType, byte[] record) throws Exception {
        this.appendUpdateRecordTransactional(txID, id, recordType, new ByteArrayEncoding(record));
    }

    @Override
    public void appendUpdateRecordTransactional(long txID, long id, byte recordType, EncodingSupport record) throws Exception {
        this.replicationManager.appendUpdateRecordTransactional(this.journalID, txID, id, recordType, record);
        this.localJournal.appendUpdateRecordTransactional(txID, id, recordType, record);
    }

    @Override
    public JournalLoadInformation load(List<RecordInfo> committedRecords, List<PreparedTransactionInfo> preparedTransactions, TransactionFailureCallback transactionFailure) throws Exception {
        return this.localJournal.load(committedRecords, preparedTransactions, transactionFailure);
    }

    @Override
    public JournalLoadInformation load(LoaderCallback reloadManager) throws Exception {
        return this.localJournal.load(reloadManager);
    }

    @Override
    public void perfBlast(int pages) throws Exception {
        this.localJournal.perfBlast(pages);
    }

    @Override
    public void start() throws Exception {
        this.localJournal.start();
    }

    @Override
    public void stop() throws Exception {
        this.localJournal.stop();
    }

    @Override
    public int getAlignment() throws Exception {
        return this.localJournal.getAlignment();
    }

    @Override
    public boolean isStarted() {
        return this.localJournal.isStarted();
    }

    @Override
    public JournalLoadInformation loadInternalOnly() throws Exception {
        return this.localJournal.loadInternalOnly();
    }

    @Override
    public int getNumberOfRecords() {
        return this.localJournal.getNumberOfRecords();
    }

    @Override
    public void runDirectJournalBlast() throws Exception {
    }
}

