/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.server.cluster;

import java.io.Serializable;
import java.util.List;
import org.hornetq.api.core.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusterConnectionConfiguration
implements Serializable {
    private static final long serialVersionUID = 8948303813427795935L;
    private final String name;
    private final String address;
    private final long retryInterval;
    private final boolean duplicateDetection;
    private final boolean forwardWhenNoConsumers;
    private final List<Pair<String, String>> staticConnectorNamePairs;
    private final String discoveryGroupName;
    private final int maxHops;
    private final int confirmationWindowSize;

    public ClusterConnectionConfiguration(String name, String address, long retryInterval, boolean duplicateDetection, boolean forwardWhenNoConsumers, int maxHops, int confirmationWindowSize, List<Pair<String, String>> staticConnectorNamePairs) {
        this.name = name;
        this.address = address;
        this.retryInterval = retryInterval;
        this.staticConnectorNamePairs = staticConnectorNamePairs;
        this.duplicateDetection = duplicateDetection;
        this.forwardWhenNoConsumers = forwardWhenNoConsumers;
        this.discoveryGroupName = null;
        this.maxHops = maxHops;
        this.confirmationWindowSize = confirmationWindowSize;
    }

    public ClusterConnectionConfiguration(String name, String address, long retryInterval, boolean duplicateDetection, boolean forwardWhenNoConsumers, int maxHops, int confirmationWindowSize, String discoveryGroupName) {
        this.name = name;
        this.address = address;
        this.retryInterval = retryInterval;
        this.duplicateDetection = duplicateDetection;
        this.forwardWhenNoConsumers = forwardWhenNoConsumers;
        this.discoveryGroupName = discoveryGroupName;
        this.staticConnectorNamePairs = null;
        this.maxHops = maxHops;
        this.confirmationWindowSize = confirmationWindowSize;
    }

    public String getName() {
        return this.name;
    }

    public String getAddress() {
        return this.address;
    }

    public boolean isDuplicateDetection() {
        return this.duplicateDetection;
    }

    public boolean isForwardWhenNoConsumers() {
        return this.forwardWhenNoConsumers;
    }

    public int getMaxHops() {
        return this.maxHops;
    }

    public int getConfirmationWindowSize() {
        return this.confirmationWindowSize;
    }

    public List<Pair<String, String>> getStaticConnectorNamePairs() {
        return this.staticConnectorNamePairs;
    }

    public String getDiscoveryGroupName() {
        return this.discoveryGroupName;
    }

    public long getRetryInterval() {
        return this.retryInterval;
    }
}

