/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.server.group.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import org.hornetq.api.core.SimpleString;
import org.hornetq.api.core.management.ManagementHelper;
import org.hornetq.api.core.management.NotificationType;
import org.hornetq.core.server.group.GroupingHandler;
import org.hornetq.core.server.group.impl.GroupBinding;
import org.hornetq.core.server.group.impl.Proposal;
import org.hornetq.core.server.group.impl.Response;
import org.hornetq.core.server.management.ManagementService;
import org.hornetq.core.server.management.Notification;
import org.hornetq.utils.TypedProperties;

public class RemoteGroupingHandler
implements GroupingHandler {
    private static Logger log = Logger.getLogger(RemoteGroupingHandler.class.getName());
    private final SimpleString name;
    private final ManagementService managementService;
    private final SimpleString address;
    private final Map<SimpleString, Response> responses = new ConcurrentHashMap<SimpleString, Response>();
    private final Lock lock = new ReentrantLock();
    private final Condition sendCondition = this.lock.newCondition();
    private final int timeout;
    private final ConcurrentMap<SimpleString, List<SimpleString>> groupMap = new ConcurrentHashMap<SimpleString, List<SimpleString>>();

    public RemoteGroupingHandler(ManagementService managementService, SimpleString name, SimpleString address, int timeout) {
        this.name = name;
        this.address = address;
        this.managementService = managementService;
        this.timeout = timeout;
    }

    public SimpleString getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response propose(Proposal proposal) throws Exception {
        Response response = this.responses.get(proposal.getGroupId());
        if (response != null) {
            return response;
        }
        try {
            this.lock.lock();
            TypedProperties props = new TypedProperties();
            props.putSimpleStringProperty(ManagementHelper.HDR_PROPOSAL_GROUP_ID, proposal.getGroupId());
            props.putSimpleStringProperty(ManagementHelper.HDR_PROPOSAL_VALUE, proposal.getClusterName());
            props.putIntProperty(ManagementHelper.HDR_BINDING_TYPE, 0);
            props.putSimpleStringProperty(ManagementHelper.HDR_ADDRESS, this.address);
            props.putIntProperty(ManagementHelper.HDR_DISTANCE, 0);
            Notification notification = new Notification(null, NotificationType.PROPOSAL, props);
            this.managementService.sendNotification(notification);
            this.sendCondition.await(this.timeout, TimeUnit.MILLISECONDS);
            response = this.responses.get(proposal.getGroupId());
        }
        finally {
            this.lock.unlock();
        }
        if (response == null) {
            throw new IllegalStateException("no response received from group handler for " + proposal.getGroupId());
        }
        return response;
    }

    public Response getProposal(SimpleString fullID) {
        return this.responses.get(fullID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void proposed(Response response) throws Exception {
        try {
            this.lock.lock();
            this.responses.put(response.getGroupId(), response);
            List<SimpleString> newList = new ArrayList<SimpleString>();
            List oldList = this.groupMap.putIfAbsent(response.getChosenClusterName(), newList);
            if (oldList != null) {
                newList = oldList;
            }
            newList.add(response.getGroupId());
            this.sendCondition.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    public Response receive(Proposal proposal, int distance) throws Exception {
        TypedProperties props = new TypedProperties();
        props.putSimpleStringProperty(ManagementHelper.HDR_PROPOSAL_GROUP_ID, proposal.getGroupId());
        props.putSimpleStringProperty(ManagementHelper.HDR_PROPOSAL_VALUE, proposal.getClusterName());
        props.putIntProperty(ManagementHelper.HDR_BINDING_TYPE, 0);
        props.putSimpleStringProperty(ManagementHelper.HDR_ADDRESS, this.address);
        props.putIntProperty(ManagementHelper.HDR_DISTANCE, distance);
        Notification notification = new Notification(null, NotificationType.PROPOSAL, props);
        this.managementService.sendNotification(notification);
        return null;
    }

    public void send(Response response, int distance) throws Exception {
    }

    public void addGroupBinding(GroupBinding groupBinding) {
    }

    public void onNotification(Notification notification) {
        SimpleString clusterName;
        List list;
        if (notification.getType() == NotificationType.BINDING_REMOVED && (list = (List)this.groupMap.remove(clusterName = notification.getProperties().getSimpleStringProperty(ManagementHelper.HDR_CLUSTER_NAME))) != null) {
            for (SimpleString val : list) {
                if (val == null) continue;
                this.responses.remove(val);
            }
        }
    }
}

