/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.server.impl;

import org.hornetq.api.core.HornetQException;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.remoting.Channel;
import org.hornetq.core.remoting.ChannelHandler;
import org.hornetq.core.remoting.Packet;
import org.hornetq.core.remoting.RemotingConnection;
import org.hornetq.core.remoting.impl.wireformat.CreateQueueMessage;
import org.hornetq.core.remoting.impl.wireformat.CreateReplicationSessionMessage;
import org.hornetq.core.remoting.impl.wireformat.CreateSessionMessage;
import org.hornetq.core.remoting.impl.wireformat.HornetQExceptionMessage;
import org.hornetq.core.remoting.impl.wireformat.NullResponseMessage;
import org.hornetq.core.remoting.impl.wireformat.PacketImpl;
import org.hornetq.core.remoting.impl.wireformat.ReattachSessionMessage;
import org.hornetq.core.replication.ReplicationEndpoint;
import org.hornetq.core.server.HornetQServer;

public class HornetQPacketHandler
implements ChannelHandler {
    private static final Logger log = Logger.getLogger(HornetQPacketHandler.class);
    private final HornetQServer server;
    private final Channel channel1;
    private final RemotingConnection connection;

    public HornetQPacketHandler(HornetQServer server, Channel channel1, RemotingConnection connection) {
        this.server = server;
        this.channel1 = channel1;
        this.connection = connection;
    }

    public void handlePacket(Packet packet) {
        byte type = packet.getType();
        switch (type) {
            case 30: {
                CreateSessionMessage request = (CreateSessionMessage)packet;
                this.handleCreateSession(request);
                break;
            }
            case 32: {
                ReattachSessionMessage request = (ReattachSessionMessage)packet;
                this.handleReattachSession(request);
                break;
            }
            case 34: {
                CreateQueueMessage request = (CreateQueueMessage)packet;
                this.handleCreateQueue(request);
                break;
            }
            case 36: {
                CreateReplicationSessionMessage request = (CreateReplicationSessionMessage)packet;
                this.handleCreateReplication(request);
                break;
            }
            default: {
                log.error("Invalid packet " + packet);
            }
        }
    }

    private void handleCreateSession(CreateSessionMessage request) {
        PacketImpl response;
        boolean incompatibleVersion = false;
        try {
            response = this.server.createSession(request.getName(), request.getSessionChannelID(), request.getUsername(), request.getPassword(), request.getMinLargeMessageSize(), request.getVersion(), this.connection, request.isAutoCommitSends(), request.isAutoCommitAcks(), request.isPreAcknowledge(), request.isXA(), request.getWindowSize());
        }
        catch (Exception e) {
            if (e instanceof HornetQException) {
                response = new HornetQExceptionMessage((HornetQException)e);
                if (((HornetQException)e).getCode() == 108) {
                    incompatibleVersion = true;
                }
            }
            log.error("Failed to create session", e);
            response = new HornetQExceptionMessage(new HornetQException(0));
        }
        if (incompatibleVersion) {
            this.channel1.sendAndFlush(response);
        } else {
            this.channel1.send(response);
        }
    }

    private void handleReattachSession(ReattachSessionMessage request) {
        PacketImpl response;
        try {
            response = this.server.reattachSession(this.connection, request.getName(), request.getLastConfirmedCommandID());
        }
        catch (Exception e) {
            if (e instanceof HornetQException) {
                response = new HornetQExceptionMessage((HornetQException)e);
            }
            log.error("Failed to reattach session", e);
            response = new HornetQExceptionMessage(new HornetQException(0));
        }
        this.channel1.send(response);
    }

    private void handleCreateQueue(CreateQueueMessage request) {
        try {
            this.server.createQueue(request.getAddress(), request.getQueueName(), request.getFilterString(), request.isDurable(), request.isTemporary());
        }
        catch (Exception e) {
            log.error("Failed to handle create queue", e);
        }
    }

    private void handleCreateReplication(CreateReplicationSessionMessage request) {
        PacketImpl response;
        try {
            Channel channel = this.connection.getChannel(request.getSessionChannelID(), -1);
            ReplicationEndpoint endpoint = this.server.connectToReplicationEndpoint(channel);
            channel.setHandler(endpoint);
            response = new NullResponseMessage();
        }
        catch (Exception e) {
            if (e instanceof HornetQException) {
                response = new HornetQExceptionMessage((HornetQException)e);
            }
            log.warn(e.getMessage(), e);
            response = new HornetQExceptionMessage(new HornetQException(0));
        }
        this.channel1.send(response);
    }
}

