/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.server.impl;

import org.hornetq.core.logging.Logger;
import org.hornetq.core.server.MemoryManager;
import org.hornetq.utils.SizeFormatterUtil;

public class MemoryManagerImpl
implements MemoryManager {
    private static final Logger log = Logger.getLogger(MemoryManagerImpl.class);
    private final Runtime runtime = Runtime.getRuntime();
    private final long measureInterval;
    private final int memoryWarningThreshold;
    private volatile boolean started;
    private Thread thread;
    private volatile boolean low;

    public MemoryManagerImpl(int memoryWarningThreshold, long measureInterval) {
        this.measureInterval = measureInterval;
        this.memoryWarningThreshold = memoryWarningThreshold;
    }

    public boolean isMemoryLow() {
        return this.low;
    }

    public synchronized boolean isStarted() {
        return this.started;
    }

    public synchronized void start() {
        log.debug("Starting MemoryManager with MEASURE_INTERVAL: " + this.measureInterval + " FREE_MEMORY_PERCENT: " + this.memoryWarningThreshold);
        if (this.started) {
            return;
        }
        this.started = true;
        this.thread = new Thread((Runnable)new MemoryRunnable(), "hornetq-memory-manager-thread");
        this.thread.setDaemon(true);
        this.thread.start();
    }

    public synchronized void stop() {
        if (!this.started) {
            return;
        }
        this.started = false;
        this.thread.interrupt();
        try {
            this.thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private class MemoryRunnable
    implements Runnable {
        private MemoryRunnable() {
        }

        public void run() {
            while (true) {
                try {
                    if (MemoryManagerImpl.this.thread.isInterrupted() && !MemoryManagerImpl.this.started) break;
                    Thread.sleep(MemoryManagerImpl.this.measureInterval);
                }
                catch (InterruptedException ignore) {
                    if (!MemoryManagerImpl.this.started) break;
                }
                long maxMemory = MemoryManagerImpl.this.runtime.maxMemory();
                long totalMemory = MemoryManagerImpl.this.runtime.totalMemory();
                long freeMemory = MemoryManagerImpl.this.runtime.freeMemory();
                long availableMemory = freeMemory + maxMemory - totalMemory;
                double availableMemoryPercent = 100.0 * (double)availableMemory / (double)maxMemory;
                String info = "";
                info = info + String.format("free memory:      %s\n", SizeFormatterUtil.sizeof(freeMemory));
                info = info + String.format("max memory:       %s\n", SizeFormatterUtil.sizeof(maxMemory));
                info = info + String.format("total memory:     %s\n", SizeFormatterUtil.sizeof(totalMemory));
                info = info + String.format("available memory: %.2f%%\n", availableMemoryPercent);
                if (log.isDebugEnabled()) {
                    log.debug(info);
                }
                if (availableMemoryPercent <= (double)MemoryManagerImpl.this.memoryWarningThreshold) {
                    log.warn("Less than " + MemoryManagerImpl.this.memoryWarningThreshold + "%\n" + info + "\nYou are in danger of running out of RAM. Have you set paging parameters " + "on your addresses? (See user manual \"Paging\" chapter)");
                    MemoryManagerImpl.this.low = true;
                    continue;
                }
                MemoryManagerImpl.this.low = false;
            }
        }
    }
}

