/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.server.impl;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.Date;
import org.hornetq.api.core.SimpleString;
import org.hornetq.core.paging.PagingManager;
import org.hornetq.core.paging.PagingStore;
import org.hornetq.core.server.HornetQServer;
import org.hornetq.utils.SizeFormatterUtil;

public class ServerInfo {
    private final HornetQServer server;
    private final PagingManager pagingManager;

    public ServerInfo(HornetQServer server, PagingManager pagingManager) {
        this.server = server;
        this.pagingManager = pagingManager;
    }

    public String dump() {
        long maxMemory = Runtime.getRuntime().maxMemory();
        long totalMemory = Runtime.getRuntime().totalMemory();
        long freeMemory = Runtime.getRuntime().freeMemory();
        long availableMemory = freeMemory + maxMemory - totalMemory;
        double availableMemoryPercent = 100.0 * (double)availableMemory / (double)maxMemory;
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        String info = "\n**** Server Dump ****\n";
        info = info + String.format("date:            %s\n", new Date());
        info = info + String.format("free memory:      %s\n", SizeFormatterUtil.sizeof(freeMemory));
        info = info + String.format("max memory:       %s\n", SizeFormatterUtil.sizeof(maxMemory));
        info = info + String.format("total memory:     %s\n", SizeFormatterUtil.sizeof(totalMemory));
        info = info + String.format("available memory: %.2f%%\n", availableMemoryPercent);
        info = info + this.appendPagingInfos();
        info = info + String.format("# of thread:     %d\n", threadMXBean.getThreadCount());
        info = info + String.format("# of conns:      %d\n", this.server.getConnectionCount());
        info = info + "********************\n";
        return info;
    }

    private String appendPagingInfos() {
        String info = "";
        info = info + String.format("total paging memory:   %s\n", SizeFormatterUtil.sizeof(this.pagingManager.getTotalMemory()));
        for (SimpleString storeName : this.pagingManager.getStoreNames()) {
            try {
                PagingStore pageStore = this.pagingManager.getPageStore(storeName);
                info = info + String.format("\t%s: %s\n", storeName, SizeFormatterUtil.sizeof(pageStore.getPageSizeBytes() * (long)pageStore.getNumberOfPages()));
            }
            catch (Exception e) {
                info = info + String.format("\t%s: %s\n", storeName, e.getMessage());
            }
        }
        return info;
    }
}

