/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.server.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.transaction.xa.Xid;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.SimpleString;
import org.hornetq.api.core.management.ManagementHelper;
import org.hornetq.api.core.management.NotificationType;
import org.hornetq.core.client.impl.ClientMessageImpl;
import org.hornetq.core.filter.Filter;
import org.hornetq.core.filter.impl.FilterImpl;
import org.hornetq.core.journal.IOAsyncTask;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.paging.PagingStore;
import org.hornetq.core.persistence.StorageManager;
import org.hornetq.core.postoffice.Binding;
import org.hornetq.core.postoffice.BindingType;
import org.hornetq.core.postoffice.Bindings;
import org.hornetq.core.postoffice.PostOffice;
import org.hornetq.core.postoffice.QueueBinding;
import org.hornetq.core.remoting.Channel;
import org.hornetq.core.remoting.CloseListener;
import org.hornetq.core.remoting.FailureListener;
import org.hornetq.core.remoting.Packet;
import org.hornetq.core.remoting.RemotingConnection;
import org.hornetq.core.remoting.impl.wireformat.CreateQueueMessage;
import org.hornetq.core.remoting.impl.wireformat.HornetQExceptionMessage;
import org.hornetq.core.remoting.impl.wireformat.NullResponseMessage;
import org.hornetq.core.remoting.impl.wireformat.PacketImpl;
import org.hornetq.core.remoting.impl.wireformat.RollbackMessage;
import org.hornetq.core.remoting.impl.wireformat.SessionAcknowledgeMessage;
import org.hornetq.core.remoting.impl.wireformat.SessionBindingQueryMessage;
import org.hornetq.core.remoting.impl.wireformat.SessionBindingQueryResponseMessage;
import org.hornetq.core.remoting.impl.wireformat.SessionConsumerCloseMessage;
import org.hornetq.core.remoting.impl.wireformat.SessionConsumerFlowCreditMessage;
import org.hornetq.core.remoting.impl.wireformat.SessionCreateConsumerMessage;
import org.hornetq.core.remoting.impl.wireformat.SessionDeleteQueueMessage;
import org.hornetq.core.remoting.impl.wireformat.SessionExpiredMessage;
import org.hornetq.core.remoting.impl.wireformat.SessionForceConsumerDelivery;
import org.hornetq.core.remoting.impl.wireformat.SessionProducerCreditsMessage;
import org.hornetq.core.remoting.impl.wireformat.SessionQueueQueryMessage;
import org.hornetq.core.remoting.impl.wireformat.SessionQueueQueryResponseMessage;
import org.hornetq.core.remoting.impl.wireformat.SessionRequestProducerCreditsMessage;
import org.hornetq.core.remoting.impl.wireformat.SessionSendContinuationMessage;
import org.hornetq.core.remoting.impl.wireformat.SessionSendLargeMessage;
import org.hornetq.core.remoting.impl.wireformat.SessionSendMessage;
import org.hornetq.core.remoting.impl.wireformat.SessionXACommitMessage;
import org.hornetq.core.remoting.impl.wireformat.SessionXAEndMessage;
import org.hornetq.core.remoting.impl.wireformat.SessionXAForgetMessage;
import org.hornetq.core.remoting.impl.wireformat.SessionXAGetInDoubtXidsResponseMessage;
import org.hornetq.core.remoting.impl.wireformat.SessionXAGetTimeoutResponseMessage;
import org.hornetq.core.remoting.impl.wireformat.SessionXAJoinMessage;
import org.hornetq.core.remoting.impl.wireformat.SessionXAPrepareMessage;
import org.hornetq.core.remoting.impl.wireformat.SessionXAResponseMessage;
import org.hornetq.core.remoting.impl.wireformat.SessionXAResumeMessage;
import org.hornetq.core.remoting.impl.wireformat.SessionXARollbackMessage;
import org.hornetq.core.remoting.impl.wireformat.SessionXASetTimeoutMessage;
import org.hornetq.core.remoting.impl.wireformat.SessionXASetTimeoutResponseMessage;
import org.hornetq.core.remoting.impl.wireformat.SessionXAStartMessage;
import org.hornetq.core.security.CheckType;
import org.hornetq.core.security.SecurityStore;
import org.hornetq.core.server.HornetQServer;
import org.hornetq.core.server.LargeServerMessage;
import org.hornetq.core.server.MessageReference;
import org.hornetq.core.server.Queue;
import org.hornetq.core.server.RoutingContext;
import org.hornetq.core.server.ServerConsumer;
import org.hornetq.core.server.ServerMessage;
import org.hornetq.core.server.ServerSession;
import org.hornetq.core.server.impl.CreditsAvailableRunnable;
import org.hornetq.core.server.impl.RoutingContextImpl;
import org.hornetq.core.server.impl.ServerConsumerImpl;
import org.hornetq.core.server.impl.ServerProducerCreditManager;
import org.hornetq.core.server.impl.ServerSessionPacketHandler;
import org.hornetq.core.server.management.ManagementService;
import org.hornetq.core.server.management.Notification;
import org.hornetq.core.transaction.ResourceManager;
import org.hornetq.core.transaction.Transaction;
import org.hornetq.core.transaction.impl.TransactionImpl;
import org.hornetq.utils.TypedProperties;

public class ServerSessionImpl
implements ServerSession,
FailureListener,
CloseListener {
    private static final Logger log = Logger.getLogger(ServerSessionImpl.class);
    private final long id;
    private final String username;
    private final String password;
    private final int minLargeMessageSize;
    private final boolean autoCommitSends;
    private final boolean autoCommitAcks;
    private final boolean preAcknowledge;
    private final boolean strictUpdateDeliveryCount;
    private RemotingConnection remotingConnection;
    private final Map<Long, ServerConsumer> consumers = new ConcurrentHashMap<Long, ServerConsumer>();
    private Transaction tx;
    private final StorageManager storageManager;
    private final ResourceManager resourceManager;
    public final PostOffice postOffice;
    private final SecurityStore securityStore;
    private final Channel channel;
    private final ManagementService managementService;
    private volatile boolean started = false;
    private final Map<SimpleString, Runnable> failureRunners = new HashMap<SimpleString, Runnable>();
    private final String name;
    private final HornetQServer server;
    private final SimpleString managementAddress;
    private volatile LargeServerMessage currentLargeMessage;
    private ServerSessionPacketHandler handler;
    private boolean closed;
    private final Map<SimpleString, CreditManagerHolder> creditManagerHolders = new HashMap<SimpleString, CreditManagerHolder>();
    private final RoutingContext routingContext = new RoutingContextImpl(null);

    public ServerSessionImpl(String name, String username, String password, int minLargeMessageSize, boolean autoCommitSends, boolean autoCommitAcks, boolean preAcknowledge, boolean strictUpdateDeliveryCount, boolean xa, RemotingConnection remotingConnection, StorageManager storageManager, PostOffice postOffice, ResourceManager resourceManager, SecurityStore securityStore, Channel channel, ManagementService managementService, HornetQServer server, SimpleString managementAddress) throws Exception {
        this.id = channel.getID();
        this.username = username;
        this.password = password;
        this.minLargeMessageSize = minLargeMessageSize;
        this.autoCommitSends = autoCommitSends;
        this.autoCommitAcks = autoCommitAcks;
        this.preAcknowledge = preAcknowledge;
        this.remotingConnection = remotingConnection;
        this.storageManager = storageManager;
        this.postOffice = postOffice;
        this.resourceManager = resourceManager;
        this.securityStore = securityStore;
        if (!xa) {
            this.tx = new TransactionImpl(storageManager);
        }
        this.strictUpdateDeliveryCount = strictUpdateDeliveryCount;
        this.channel = channel;
        this.managementService = managementService;
        this.name = name;
        this.server = server;
        this.managementAddress = managementAddress;
        remotingConnection.addFailureListener(this);
        remotingConnection.addCloseListener(this);
    }

    public ServerSessionPacketHandler getHandler() {
        return this.handler;
    }

    public void setHandler(ServerSessionPacketHandler handler) {
        this.handler = handler;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public int getMinLargeMessageSize() {
        return this.minLargeMessageSize;
    }

    public long getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Object getConnectionID() {
        return this.remotingConnection.getID();
    }

    public void removeConsumer(ServerConsumer consumer) throws Exception {
        if (this.consumers.remove(consumer.getID()) == null) {
            throw new IllegalStateException("Cannot find consumer with id " + consumer.getID() + " to remove");
        }
    }

    public synchronized void close() throws Exception {
        if (this.tx != null && this.tx.getXid() == null) {
            this.rollback(false);
        }
        HashSet<ServerConsumer> consumersClone = new HashSet<ServerConsumer>(this.consumers.values());
        for (ServerConsumer consumer : consumersClone) {
            consumer.close();
        }
        this.consumers.clear();
        this.server.removeSession(this.name);
        if (this.currentLargeMessage != null) {
            try {
                this.currentLargeMessage.deleteFile();
            }
            catch (Throwable error) {
                log.error("Failed to delete large message file", error);
            }
        }
        this.remotingConnection.removeFailureListener(this);
        this.closed = true;
        for (CreditManagerHolder holder : this.creditManagerHolders.values()) {
            holder.store.returnProducerCredits(holder.outstandingCredits);
        }
    }

    public void handleCreateConsumer(SessionCreateConsumerMessage packet) {
        SimpleString name = packet.getQueueName();
        SimpleString filterString = packet.getFilterString();
        boolean browseOnly = packet.isBrowseOnly();
        PacketImpl response = null;
        try {
            Binding binding = this.postOffice.getBinding(name);
            if (binding == null || binding.getType() != BindingType.LOCAL_QUEUE) {
                throw new HornetQException(100, "Queue " + name + " does not exist");
            }
            this.securityStore.check(binding.getAddress(), CheckType.CONSUME, this);
            Filter filter = FilterImpl.createFilter(filterString);
            ServerConsumerImpl consumer = new ServerConsumerImpl(packet.getID(), this, (QueueBinding)binding, filter, this.started, browseOnly, this.storageManager, this.channel, this.preAcknowledge, this.strictUpdateDeliveryCount, this.managementService);
            this.consumers.put(consumer.getID(), consumer);
            if (!browseOnly) {
                TypedProperties props = new TypedProperties();
                props.putSimpleStringProperty(ManagementHelper.HDR_ADDRESS, binding.getAddress());
                props.putSimpleStringProperty(ManagementHelper.HDR_CLUSTER_NAME, binding.getClusterName());
                props.putSimpleStringProperty(ManagementHelper.HDR_ROUTING_NAME, binding.getRoutingName());
                props.putIntProperty(ManagementHelper.HDR_DISTANCE, binding.getDistance());
                Queue theQueue = (Queue)binding.getBindable();
                props.putIntProperty(ManagementHelper.HDR_CONSUMER_COUNT, theQueue.getConsumerCount());
                if (filterString != null) {
                    props.putSimpleStringProperty(ManagementHelper.HDR_FILTERSTRING, filterString);
                }
                Notification notification = new Notification(null, NotificationType.CONSUMER_CREATED, props);
                this.managementService.sendNotification(notification);
            }
            response = packet.isRequiresResponse() ? this.doExecuteQueueQuery(name) : null;
        }
        catch (Exception e) {
            if (e instanceof HornetQException) {
                response = new HornetQExceptionMessage((HornetQException)e);
            }
            log.error("Failed to create consumer", e);
            response = new HornetQExceptionMessage(new HornetQException(0));
        }
        this.sendResponse(packet, response, false, false);
    }

    public void handleCreateQueue(CreateQueueMessage packet) {
        SimpleString address = packet.getAddress();
        final SimpleString name = packet.getQueueName();
        SimpleString filterString = packet.getFilterString();
        boolean temporary = packet.isTemporary();
        boolean durable = packet.isDurable();
        PacketImpl response = null;
        try {
            if (durable) {
                this.securityStore.check(address, CheckType.CREATE_DURABLE_QUEUE, this);
            } else {
                this.securityStore.check(address, CheckType.CREATE_NON_DURABLE_QUEUE, this);
            }
            this.server.createQueue(address, name, filterString, durable, temporary);
            if (temporary) {
                this.failureRunners.put(name, new Runnable(){

                    public void run() {
                        try {
                            if (ServerSessionImpl.this.postOffice.getBinding(name) != null) {
                                ServerSessionImpl.this.postOffice.removeBinding(name);
                                if (ServerSessionImpl.this.postOffice.getBindingsForAddress(name).getBindings().size() == 0) {
                                    ServerSessionImpl.this.creditManagerHolders.remove(name);
                                }
                            }
                        }
                        catch (Exception e) {
                            log.error("Failed to remove temporary queue " + name);
                        }
                    }
                });
            }
            response = packet.isRequiresResponse() ? new NullResponseMessage() : null;
        }
        catch (Exception e) {
            if (e instanceof HornetQException) {
                response = new HornetQExceptionMessage((HornetQException)e);
            }
            log.error("Failed to create queue", e);
            response = new HornetQExceptionMessage(new HornetQException(0));
        }
        this.sendResponse(packet, response, false, false);
    }

    public void handleDeleteQueue(SessionDeleteQueueMessage packet) {
        SimpleString name = packet.getQueueName();
        PacketImpl response = null;
        try {
            Binding binding = this.postOffice.getBinding(name);
            if (binding == null || binding.getType() != BindingType.LOCAL_QUEUE) {
                throw new HornetQException(100);
            }
            this.server.destroyQueue(name, this);
            this.failureRunners.remove(name);
            if (this.postOffice.getBindingsForAddress(name).getBindings().size() == 0) {
                this.creditManagerHolders.remove(name);
            }
            response = new NullResponseMessage();
        }
        catch (Exception e) {
            if (e instanceof HornetQException) {
                response = new HornetQExceptionMessage((HornetQException)e);
            }
            log.error("Failed to delete queue", e);
            response = new HornetQExceptionMessage(new HornetQException(0));
        }
        this.sendResponse(packet, response, false, false);
    }

    public void handleExecuteQueueQuery(SessionQueueQueryMessage packet) {
        SimpleString name = packet.getQueueName();
        PacketImpl response = null;
        try {
            response = this.doExecuteQueueQuery(name);
        }
        catch (Exception e) {
            if (e instanceof HornetQException) {
                response = new HornetQExceptionMessage((HornetQException)e);
            }
            log.error("Failed to execute queue query", e);
            response = new HornetQExceptionMessage(new HornetQException(0));
        }
        this.sendResponse(packet, response, false, false);
    }

    public void handleExecuteBindingQuery(SessionBindingQueryMessage packet) {
        SimpleString address = packet.getAddress();
        PacketImpl response = null;
        try {
            if (address == null) {
                throw new IllegalArgumentException("Address is null");
            }
            ArrayList<SimpleString> names = new ArrayList<SimpleString>();
            Bindings bindings = this.postOffice.getMatchingBindings(address);
            for (Binding binding : bindings.getBindings()) {
                if (binding.getType() != BindingType.LOCAL_QUEUE) continue;
                names.add(binding.getUniqueName());
            }
            response = new SessionBindingQueryResponseMessage(!names.isEmpty(), names);
        }
        catch (Exception e) {
            log.error("Failed to execute binding query", e);
            response = e instanceof HornetQException ? new HornetQExceptionMessage((HornetQException)e) : new HornetQExceptionMessage(new HornetQException(0));
        }
        this.sendResponse(packet, response, false, false);
    }

    public void handleForceConsumerDelivery(SessionForceConsumerDelivery message) {
        try {
            ServerConsumer consumer = this.consumers.get(message.getConsumerID());
            consumer.forceDelivery(message.getSequence());
        }
        catch (Exception e) {
            log.error("Failed to query consumer deliveries", e);
        }
        this.sendResponse(message, null, false, false);
    }

    public void handleAcknowledge(SessionAcknowledgeMessage packet) {
        PacketImpl response;
        block3: {
            response = null;
            try {
                ServerConsumer consumer = this.consumers.get(packet.getConsumerID());
                consumer.acknowledge(this.autoCommitAcks, this.tx, packet.getMessageID());
                if (packet.isRequiresResponse()) {
                    response = new NullResponseMessage();
                }
            }
            catch (Exception e) {
                log.error("Failed to acknowledge", e);
                if (!packet.isRequiresResponse()) break block3;
                response = e instanceof HornetQException ? new HornetQExceptionMessage((HornetQException)e) : new HornetQExceptionMessage(new HornetQException(0));
            }
        }
        this.sendResponse(packet, response, false, false);
    }

    public void handleExpired(SessionExpiredMessage packet) {
        try {
            MessageReference ref = this.consumers.get(packet.getConsumerID()).getExpired(packet.getMessageID());
            if (ref != null) {
                ref.getQueue().expire(ref);
            }
        }
        catch (Exception e) {
            log.error("Failed to acknowledge", e);
        }
        this.sendResponse(packet, null, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleCommit(Packet packet) {
        PacketImpl response = null;
        try {
            this.tx.commit();
            response = new NullResponseMessage();
        }
        catch (Exception e) {
            log.error("Failed to commit", e);
            response = e instanceof HornetQException ? new HornetQExceptionMessage((HornetQException)e) : new HornetQExceptionMessage(new HornetQException(0));
        }
        finally {
            this.tx = new TransactionImpl(this.storageManager);
        }
        this.sendResponse(packet, response, false, false);
    }

    public void handleRollback(RollbackMessage packet) {
        PacketImpl response = null;
        try {
            this.rollback(packet.isConsiderLastMessageAsDelivered());
            response = new NullResponseMessage();
        }
        catch (Exception e) {
            log.error("Failed to rollback", e);
            response = e instanceof HornetQException ? new HornetQExceptionMessage((HornetQException)e) : new HornetQExceptionMessage(new HornetQException(0));
        }
        this.sendResponse(packet, response, false, false);
    }

    public void handleXACommit(SessionXACommitMessage packet) {
        PacketImpl response = null;
        Xid xid = packet.getXid();
        try {
            if (this.tx != null) {
                String msg = "Cannot commit, session is currently doing work in transaction " + this.tx.getXid();
                response = new SessionXAResponseMessage(true, -6, msg);
            } else {
                Transaction theTx = this.resourceManager.removeTransaction(xid);
                if (theTx == null) {
                    response = this.resourceManager.getHeuristicCommittedTransactions().contains(xid) ? new SessionXAResponseMessage(true, 7, "transaction has been heuristically committed: " + xid) : (this.resourceManager.getHeuristicRolledbackTransactions().contains(xid) ? new SessionXAResponseMessage(true, 6, "transaction has been heuristically rolled back: " + xid) : new SessionXAResponseMessage(true, -4, "Cannot find xid in resource manager: " + xid));
                } else if (theTx.getState() == Transaction.State.SUSPENDED) {
                    this.resourceManager.putTransaction(xid, this.tx);
                    response = new SessionXAResponseMessage(true, -6, "Cannot commit transaction, it is suspended " + xid);
                } else {
                    theTx.commit(packet.isOnePhase());
                    response = new SessionXAResponseMessage(false, 0, null);
                }
            }
        }
        catch (Exception e) {
            log.error("Failed to xa commit", e);
            response = e instanceof HornetQException ? new HornetQExceptionMessage((HornetQException)e) : new HornetQExceptionMessage(new HornetQException(0));
        }
        this.sendResponse(packet, response, false, false);
    }

    public void handleXAEnd(SessionXAEndMessage packet) {
        PacketImpl response = null;
        Xid xid = packet.getXid();
        try {
            if (this.tx != null && this.tx.getXid().equals(xid)) {
                if (this.tx.getState() == Transaction.State.SUSPENDED) {
                    String msg = "Cannot end, transaction is suspended";
                    response = new SessionXAResponseMessage(true, -6, "Cannot end, transaction is suspended");
                } else {
                    this.tx = null;
                }
            } else {
                Transaction theTx = this.resourceManager.getTransaction(xid);
                if (theTx == null) {
                    String msg = "Cannot find suspended transaction to end " + xid;
                    response = new SessionXAResponseMessage(true, -4, msg);
                } else if (theTx.getState() != Transaction.State.SUSPENDED) {
                    String msg = "Transaction is not suspended " + xid;
                    response = new SessionXAResponseMessage(true, -6, msg);
                } else {
                    theTx.resume();
                }
            }
            if (response == null) {
                response = new SessionXAResponseMessage(false, 0, null);
            }
        }
        catch (Exception e) {
            log.error("Failed to xa end", e);
            response = e instanceof HornetQException ? new HornetQExceptionMessage((HornetQException)e) : new HornetQExceptionMessage(new HornetQException(0));
        }
        this.sendResponse(packet, response, false, false);
    }

    public void handleXAForget(SessionXAForgetMessage packet) {
        long id = this.resourceManager.removeHeuristicCompletion(packet.getXid());
        int code = 0;
        if (id != -1L) {
            try {
                this.storageManager.deleteHeuristicCompletion(id);
            }
            catch (Exception e) {
                e.printStackTrace();
                code = -3;
            }
        } else {
            code = -4;
        }
        SessionXAResponseMessage response = new SessionXAResponseMessage(code != 0, code, null);
        this.sendResponse(packet, response, false, false);
    }

    public void handleXAJoin(SessionXAJoinMessage packet) {
        PacketImpl response = null;
        Xid xid = packet.getXid();
        try {
            Transaction theTx = this.resourceManager.getTransaction(xid);
            if (theTx == null) {
                String msg = "Cannot find xid in resource manager: " + xid;
                response = new SessionXAResponseMessage(true, -4, msg);
            } else if (theTx.getState() == Transaction.State.SUSPENDED) {
                response = new SessionXAResponseMessage(true, -6, "Cannot join tx, it is suspended " + xid);
            } else {
                this.tx = theTx;
                response = new SessionXAResponseMessage(false, 0, null);
            }
        }
        catch (Exception e) {
            log.error("Failed to xa join", e);
            response = e instanceof HornetQException ? new HornetQExceptionMessage((HornetQException)e) : new HornetQExceptionMessage(new HornetQException(0));
        }
        this.sendResponse(packet, response, false, false);
    }

    public void handleXAResume(SessionXAResumeMessage packet) {
        PacketImpl response = null;
        Xid xid = packet.getXid();
        try {
            if (this.tx != null) {
                String msg = "Cannot resume, session is currently doing work in a transaction " + this.tx.getXid();
                response = new SessionXAResponseMessage(true, -6, msg);
            } else {
                Transaction theTx = this.resourceManager.getTransaction(xid);
                if (theTx == null) {
                    String msg = "Cannot find xid in resource manager: " + xid;
                    response = new SessionXAResponseMessage(true, -4, msg);
                } else if (theTx.getState() != Transaction.State.SUSPENDED) {
                    response = new SessionXAResponseMessage(true, -6, "Cannot resume transaction, it is not suspended " + xid);
                } else {
                    this.tx = theTx;
                    this.tx.resume();
                    response = new SessionXAResponseMessage(false, 0, null);
                }
            }
        }
        catch (Exception e) {
            log.error("Failed to xa resume", e);
            response = e instanceof HornetQException ? new HornetQExceptionMessage((HornetQException)e) : new HornetQExceptionMessage(new HornetQException(0));
        }
        this.sendResponse(packet, response, false, false);
    }

    public void handleXARollback(SessionXARollbackMessage packet) {
        PacketImpl response = null;
        Xid xid = packet.getXid();
        try {
            if (this.tx != null) {
                String msg = "Cannot roll back, session is currently doing work in a transaction " + this.tx.getXid();
                response = new SessionXAResponseMessage(true, -6, msg);
            } else {
                Transaction theTx = this.resourceManager.removeTransaction(xid);
                if (theTx == null) {
                    response = this.resourceManager.getHeuristicCommittedTransactions().contains(xid) ? new SessionXAResponseMessage(true, 7, "transaction has ben heuristically committed: " + xid) : (this.resourceManager.getHeuristicRolledbackTransactions().contains(xid) ? new SessionXAResponseMessage(true, 6, "transaction has ben heuristically rolled back: " + xid) : new SessionXAResponseMessage(true, -4, "Cannot find xid in resource manager: " + xid));
                } else if (theTx.getState() == Transaction.State.SUSPENDED) {
                    this.resourceManager.putTransaction(xid, this.tx);
                    response = new SessionXAResponseMessage(true, -6, "Cannot rollback transaction, it is suspended " + xid);
                } else {
                    this.doRollback(false, theTx);
                    response = new SessionXAResponseMessage(false, 0, null);
                }
            }
        }
        catch (Exception e) {
            log.error("Failed to xa rollback", e);
            response = e instanceof HornetQException ? new HornetQExceptionMessage((HornetQException)e) : new HornetQExceptionMessage(new HornetQException(0));
        }
        this.sendResponse(packet, response, false, false);
    }

    public void handleXAStart(SessionXAStartMessage packet) {
        PacketImpl response = null;
        Xid xid = packet.getXid();
        try {
            if (this.tx != null) {
                String msg = "Cannot start, session is already doing work in a transaction " + this.tx.getXid();
                response = new SessionXAResponseMessage(true, -6, msg);
            } else {
                this.tx = new TransactionImpl(xid, this.storageManager, this.postOffice);
                boolean added = this.resourceManager.putTransaction(xid, this.tx);
                if (!added) {
                    String msg = "Cannot start, there is already a xid " + this.tx.getXid();
                    response = new SessionXAResponseMessage(true, -8, msg);
                } else {
                    response = new SessionXAResponseMessage(false, 0, null);
                }
            }
        }
        catch (Exception e) {
            log.error("Failed to xa start", e);
            response = e instanceof HornetQException ? new HornetQExceptionMessage((HornetQException)e) : new HornetQExceptionMessage(new HornetQException(0));
        }
        this.sendResponse(packet, response, false, false);
    }

    public void handleXASuspend(Packet packet) {
        PacketImpl response = null;
        try {
            if (this.tx == null) {
                String msg = "Cannot suspend, session is not doing work in a transaction ";
                response = new SessionXAResponseMessage(true, -6, "Cannot suspend, session is not doing work in a transaction ");
            } else if (this.tx.getState() == Transaction.State.SUSPENDED) {
                String msg = "Cannot suspend, transaction is already suspended " + this.tx.getXid();
                response = new SessionXAResponseMessage(true, -6, msg);
            } else {
                this.tx.suspend();
                this.tx = null;
                response = new SessionXAResponseMessage(false, 0, null);
            }
        }
        catch (Exception e) {
            log.error("Failed to xa suspend", e);
            response = e instanceof HornetQException ? new HornetQExceptionMessage((HornetQException)e) : new HornetQExceptionMessage(new HornetQException(0));
        }
        this.sendResponse(packet, response, false, false);
    }

    public void handleXAPrepare(SessionXAPrepareMessage packet) {
        PacketImpl response = null;
        Xid xid = packet.getXid();
        try {
            if (this.tx != null) {
                String msg = "Cannot commit, session is currently doing work in a transaction " + this.tx.getXid();
                response = new SessionXAResponseMessage(true, -6, msg);
            } else {
                Transaction theTx = this.resourceManager.getTransaction(xid);
                if (theTx == null) {
                    String msg = "Cannot find xid in resource manager: " + xid;
                    response = new SessionXAResponseMessage(true, -4, msg);
                } else if (theTx.getState() == Transaction.State.SUSPENDED) {
                    response = new SessionXAResponseMessage(true, -6, "Cannot prepare transaction, it is suspended " + xid);
                } else {
                    theTx.prepare();
                    response = new SessionXAResponseMessage(false, 0, null);
                }
            }
        }
        catch (Exception e) {
            log.error("Failed to xa prepare", e);
            response = e instanceof HornetQException ? new HornetQExceptionMessage((HornetQException)e) : new HornetQExceptionMessage(new HornetQException(0));
        }
        this.sendResponse(packet, response, false, false);
    }

    public void handleGetInDoubtXids(Packet packet) {
        ArrayList<Xid> indoubtsXids = new ArrayList<Xid>();
        indoubtsXids.addAll(this.resourceManager.getPreparedTransactions());
        indoubtsXids.addAll(this.resourceManager.getHeuristicCommittedTransactions());
        indoubtsXids.addAll(this.resourceManager.getHeuristicRolledbackTransactions());
        SessionXAGetInDoubtXidsResponseMessage response = new SessionXAGetInDoubtXidsResponseMessage(indoubtsXids);
        this.sendResponse(packet, response, false, false);
    }

    public void handleGetXATimeout(Packet packet) {
        SessionXAGetTimeoutResponseMessage response = new SessionXAGetTimeoutResponseMessage(this.resourceManager.getTimeoutSeconds());
        this.sendResponse(packet, response, false, false);
    }

    public void handleSetXATimeout(SessionXASetTimeoutMessage packet) {
        SessionXASetTimeoutResponseMessage response = new SessionXASetTimeoutResponseMessage(this.resourceManager.setTimeoutSeconds(packet.getTimeoutSeconds()));
        this.sendResponse(packet, response, false, false);
    }

    public void handleStart(Packet packet) {
        this.setStarted(true);
        this.sendResponse(packet, null, false, false);
    }

    public void handleStop(Packet packet) {
        NullResponseMessage response = new NullResponseMessage();
        this.setStarted(false);
        this.sendResponse(packet, response, false, false);
    }

    public void handleClose(final Packet packet) {
        this.storageManager.afterCompleteOperations(new IOAsyncTask(){

            public void onError(int errorCode, String errorMessage) {
            }

            public void done() {
                ServerSessionImpl.this.doClose(packet);
            }
        });
    }

    public void handleCloseConsumer(SessionConsumerCloseMessage packet) {
        PacketImpl response;
        ServerConsumer consumer = this.consumers.get(packet.getConsumerID());
        try {
            if (consumer != null) {
                consumer.close();
            } else {
                log.error("Cannot find consumer with id " + packet.getConsumerID());
            }
            response = new NullResponseMessage();
        }
        catch (Exception e) {
            log.error("Failed to close consumer", e);
            response = e instanceof HornetQException ? new HornetQExceptionMessage((HornetQException)e) : new HornetQExceptionMessage(new HornetQException(0));
        }
        this.sendResponse(packet, response, false, false);
    }

    public void handleReceiveConsumerCredits(SessionConsumerFlowCreditMessage packet) {
        ServerConsumer consumer = this.consumers.get(packet.getConsumerID());
        if (consumer == null) {
            log.error("There is no consumer with id " + packet.getConsumerID());
            return;
        }
        try {
            consumer.receiveCredits(packet.getCredits());
        }
        catch (Exception e) {
            log.error("Failed to receive credits " + this.server.getConfiguration().isBackup(), e);
        }
        this.sendResponse(packet, null, false, false);
    }

    public void handleSendLargeMessage(SessionSendLargeMessage packet) {
        long id = this.storageManager.generateUniqueID();
        LargeServerMessage msg = this.doCreateLargeMessage(id, packet);
        if (msg != null) {
            if (this.currentLargeMessage != null) {
                log.warn("Replacing incomplete LargeMessage with ID=" + this.currentLargeMessage.getMessageID());
            }
            this.currentLargeMessage = msg;
            this.sendResponse(packet, null, false, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleSend(SessionSendMessage packet) {
        PacketImpl response = null;
        ServerMessage message = (ServerMessage)packet.getMessage();
        try {
            long id = this.storageManager.generateUniqueID();
            message.setMessageID(id);
            message.encodeMessageIDToBuffer();
            if (message.getAddress().equals(this.managementAddress)) {
                this.handleManagementMessage(message);
            } else {
                this.send(message);
            }
            if (packet.isRequiresResponse()) {
                response = new NullResponseMessage();
            }
        }
        catch (Exception e) {
            log.error("Failed to send message", e);
            if (packet.isRequiresResponse()) {
                response = e instanceof HornetQException ? new HornetQExceptionMessage((HornetQException)e) : new HornetQExceptionMessage(new HornetQException(0));
            }
        }
        finally {
            try {
                this.releaseOutStanding(message, message.getEncodeSize());
            }
            catch (Exception e) {
                log.error("Failed to release outstanding credits", e);
            }
        }
        this.sendResponse(packet, response, false, false);
    }

    public void handleSendContinuations(SessionSendContinuationMessage packet) {
        PacketImpl response;
        block6: {
            response = null;
            try {
                if (this.currentLargeMessage == null) {
                    throw new HornetQException(104, "large-message not initialized on server");
                }
                this.releaseOutStanding(this.currentLargeMessage, packet.getPacketSize());
                this.currentLargeMessage.addBytes(packet.getBody());
                if (!packet.isContinues()) {
                    this.currentLargeMessage.releaseResources();
                    this.send(this.currentLargeMessage);
                    this.releaseOutStanding(this.currentLargeMessage, this.currentLargeMessage.getEncodeSize());
                    this.currentLargeMessage = null;
                }
                if (packet.isRequiresResponse()) {
                    response = new NullResponseMessage();
                }
            }
            catch (Exception e) {
                if (!packet.isRequiresResponse()) break block6;
                if (e instanceof HornetQException) {
                    response = new HornetQExceptionMessage((HornetQException)e);
                }
                log.error("Failed to send message", e);
                response = new HornetQExceptionMessage(new HornetQException(0));
            }
        }
        this.sendResponse(packet, response, false, false);
    }

    public void handleRequestProducerCredits(SessionRequestProducerCreditsMessage packet) throws Exception {
        final SimpleString address = packet.getAddress();
        final CreditManagerHolder holder = this.getCreditManagerHolder(address);
        int credits = packet.getCredits();
        if (credits < 0) {
            this.releaseOutStanding(address, -credits);
        } else {
            int gotCredits = holder.manager.acquireCredits(credits, new CreditsAvailableRunnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public boolean run(int credits) {
                    ServerSessionImpl serverSessionImpl = ServerSessionImpl.this;
                    synchronized (serverSessionImpl) {
                        if (!ServerSessionImpl.this.closed) {
                            ServerSessionImpl.this.sendProducerCredits(holder, credits, address);
                            return true;
                        }
                        return false;
                    }
                }
            });
            if (gotCredits > 0) {
                this.sendProducerCredits(holder, gotCredits, address);
            }
        }
        this.sendResponse(packet, null, false, false);
    }

    public int transferConnection(RemotingConnection newConnection, int lastReceivedCommandID) {
        this.setTransferring(true);
        this.remotingConnection.removeFailureListener(this);
        this.remotingConnection.removeCloseListener(this);
        this.channel.transferConnection(newConnection);
        newConnection.syncIDGeneratorSequence(this.remotingConnection.getIDGeneratorSequence());
        this.remotingConnection = newConnection;
        this.remotingConnection.addFailureListener(this);
        this.remotingConnection.addCloseListener(this);
        int serverLastReceivedCommandID = this.channel.getLastConfirmedCommandID();
        this.channel.replayCommands(lastReceivedCommandID, this.id);
        this.channel.setTransferring(false);
        this.setTransferring(false);
        return serverLastReceivedCommandID;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public void connectionFailed(HornetQException me) {
        try {
            log.warn("Client connection failed, clearing up resources for session " + this.name);
            for (Runnable runner : this.failureRunners.values()) {
                try {
                    runner.run();
                }
                catch (Throwable t) {
                    log.error("Failed to execute failure runner", t);
                }
            }
            this.handleClose(new PacketImpl(69));
            log.warn("Cleared up resources for session " + this.name);
        }
        catch (Throwable t) {
            log.error("Failed to close connection " + this);
        }
    }

    public void connectionClosed() {
        try {
            for (Runnable runner : this.failureRunners.values()) {
                try {
                    runner.run();
                }
                catch (Throwable t) {
                    log.error("Failed to execute failure runner", t);
                }
            }
        }
        catch (Throwable t) {
            log.error("Failed fire listeners " + this);
        }
    }

    private SessionQueueQueryResponseMessage doExecuteQueueQuery(SimpleString name) throws Exception {
        SessionQueueQueryResponseMessage response;
        if (name == null) {
            throw new IllegalArgumentException("Queue name is null");
        }
        Binding binding = this.postOffice.getBinding(name);
        if (binding != null && binding.getType() == BindingType.LOCAL_QUEUE) {
            Queue queue = (Queue)binding.getBindable();
            Filter filter = queue.getFilter();
            SimpleString filterString = filter == null ? null : filter.getFilterString();
            response = new SessionQueueQueryResponseMessage(name, binding.getAddress(), queue.isDurable(), queue.isTemporary(), filterString, queue.getConsumerCount(), queue.getMessageCount());
        } else {
            response = name.equals(this.managementAddress) ? new SessionQueueQueryResponseMessage(name, this.managementAddress, true, false, null, -1, -1) : new SessionQueueQueryResponseMessage();
        }
        return response;
    }

    private void sendResponse(final Packet confirmPacket, final Packet response, final boolean flush, final boolean closeChannel) {
        this.storageManager.afterCompleteOperations(new IOAsyncTask(){

            public void onError(int errorCode, String errorMessage) {
                log.warn("Error processing IOCallback code = " + errorCode + " message = " + errorMessage);
                HornetQExceptionMessage exceptionMessage = new HornetQExceptionMessage(new HornetQException(errorCode, errorMessage));
                ServerSessionImpl.this.doConfirmAndResponse(confirmPacket, exceptionMessage, flush, closeChannel);
            }

            public void done() {
                ServerSessionImpl.this.doConfirmAndResponse(confirmPacket, response, flush, closeChannel);
            }
        });
    }

    private void doConfirmAndResponse(Packet confirmPacket, Packet response, boolean flush, boolean closeChannel) {
        if (confirmPacket != null) {
            this.channel.confirm(confirmPacket);
            if (flush) {
                this.channel.flushConfirmations();
            }
        }
        if (response != null) {
            this.channel.send(response);
        }
        if (closeChannel) {
            this.channel.close();
        }
    }

    private void doClose(Packet packet) {
        PacketImpl response = null;
        try {
            this.close();
            response = new NullResponseMessage();
        }
        catch (Exception e) {
            log.error("Failed to close", e);
            response = e instanceof HornetQException ? new HornetQExceptionMessage((HornetQException)e) : new HornetQExceptionMessage(new HornetQException(0));
        }
        this.sendResponse(packet, response, true, true);
    }

    private void setStarted(boolean s) {
        HashSet<ServerConsumer> consumersClone = new HashSet<ServerConsumer>(this.consumers.values());
        for (ServerConsumer consumer : consumersClone) {
            consumer.setStarted(s);
        }
        this.started = s;
    }

    private void setTransferring(boolean transferring) {
        HashSet<ServerConsumer> consumersClone = new HashSet<ServerConsumer>(this.consumers.values());
        for (ServerConsumer consumer : consumersClone) {
            consumer.setTransferring(transferring);
        }
    }

    private LargeServerMessage doCreateLargeMessage(long id, SessionSendLargeMessage packet) {
        try {
            LargeServerMessage msg = this.createLargeMessageStorage(id, packet.getLargeMessageHeader());
            return msg;
        }
        catch (Exception e) {
            log.error("Failed to create large message", e);
            Packet response = null;
            this.channel.confirm(packet);
            if (response != null) {
                this.channel.send(response);
            }
            return null;
        }
    }

    private void handleManagementMessage(ServerMessage message) throws Exception {
        try {
            this.securityStore.check(message.getAddress(), CheckType.MANAGE, this);
        }
        catch (HornetQException e) {
            if (!this.autoCommitSends) {
                this.tx.markAsRollbackOnly(e);
            }
            throw e;
        }
        ServerMessage reply = this.managementService.handleMessage(message);
        SimpleString replyTo = message.getSimpleStringProperty(ClientMessageImpl.REPLYTO_HEADER_NAME);
        if (replyTo != null) {
            reply.setAddress(replyTo);
            this.send(reply);
        }
    }

    private LargeServerMessage createLargeMessageStorage(long id, byte[] header) throws Exception {
        return this.storageManager.createLargeMessage(id, header);
    }

    private void doRollback(boolean lastMessageAsDelived, Transaction theTx) throws Exception {
        boolean wasStarted = this.started;
        ArrayList<MessageReference> toCancel = new ArrayList<MessageReference>();
        for (ServerConsumer consumer : this.consumers.values()) {
            if (wasStarted) {
                consumer.setStarted(false);
            }
            toCancel.addAll(consumer.cancelRefs(lastMessageAsDelived, theTx));
        }
        for (MessageReference ref : toCancel) {
            ref.getQueue().cancel(theTx, ref);
        }
        theTx.rollback();
        if (wasStarted) {
            for (ServerConsumer consumer : this.consumers.values()) {
                consumer.setStarted(true);
            }
        }
    }

    private void rollback(boolean lastMessageAsDelived) throws Exception {
        if (this.tx == null) {
            this.tx = new TransactionImpl(this.storageManager);
        }
        this.doRollback(lastMessageAsDelived, this.tx);
        this.tx = new TransactionImpl(this.storageManager);
    }

    private void releaseOutStanding(ServerMessage message, int credits) throws Exception {
        this.releaseOutStanding(message.getAddress(), credits);
    }

    private void releaseOutStanding(SimpleString address, int credits) throws Exception {
        CreditManagerHolder holder = this.getCreditManagerHolder(address);
        holder.outstandingCredits -= credits;
        holder.store.returnProducerCredits(credits);
    }

    private CreditManagerHolder getCreditManagerHolder(SimpleString address) throws Exception {
        CreditManagerHolder holder = this.creditManagerHolders.get(address);
        if (holder == null) {
            PagingStore store = this.postOffice.getPagingManager().getPageStore(address);
            holder = new CreditManagerHolder(store);
            this.creditManagerHolders.put(address, holder);
        }
        return holder;
    }

    private void sendProducerCredits(CreditManagerHolder holder, int credits, SimpleString address) {
        holder.outstandingCredits += credits;
        SessionProducerCreditsMessage packet = new SessionProducerCreditsMessage(credits, address, -1);
        this.channel.send(packet);
    }

    private void send(ServerMessage msg) throws Exception {
        try {
            this.securityStore.check(msg.getAddress(), CheckType.SEND, this);
        }
        catch (HornetQException e) {
            if (!this.autoCommitSends) {
                this.tx.markAsRollbackOnly(e);
            }
            throw e;
        }
        if (this.tx != null && !this.autoCommitSends) {
            this.routingContext.setTransaction(this.tx);
        }
        this.postOffice.route(msg, this.routingContext);
        this.routingContext.clear();
    }

    private static final class CreditManagerHolder {
        final PagingStore store;
        final ServerProducerCreditManager manager;
        volatile int outstandingCredits;

        CreditManagerHolder(PagingStore store) {
            this.store = store;
            this.manager = store.getProducerCreditManager();
        }
    }
}

