/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.settings.impl;

import org.hornetq.api.core.SimpleString;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.settings.Mergeable;
import org.hornetq.core.settings.impl.AddressFullMessagePolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddressSettings
implements Mergeable<AddressSettings> {
    private static Logger log = Logger.getLogger(AddressSettings.class);
    public static final int DEFAULT_MAX_SIZE_BYTES = -1;
    public static final AddressFullMessagePolicy DEFAULT_ADDRESS_FULL_MESSAGE_POLICY = AddressFullMessagePolicy.PAGE;
    public static final int DEFAULT_PAGE_SIZE = 0xA00000;
    public static final int DEFAULT_MAX_DELIVERY_ATTEMPTS = 10;
    public static final int DEFAULT_MESSAGE_COUNTER_HISTORY_DAY_LIMIT = 0;
    public static final long DEFAULT_REDELIVER_DELAY = 0L;
    public static final boolean DEFAULT_LAST_VALUE_QUEUE = false;
    public static final long DEFAULT_REDISTRIBUTION_DELAY = -1L;
    public static final boolean DEFAULT_SEND_TO_DLA_ON_NO_ROUTE = false;
    private AddressFullMessagePolicy addressFullMessagePolicy = null;
    private Long maxSizeBytes = null;
    private Integer pageSizeBytes = null;
    private Boolean dropMessagesWhenFull = null;
    private Integer maxDeliveryAttempts = null;
    private Integer messageCounterHistoryDayLimit = null;
    private Long redeliveryDelay = null;
    private SimpleString deadLetterAddress = null;
    private SimpleString expiryAddress = null;
    private Boolean lastValueQueue = null;
    private Long redistributionDelay = null;
    private Boolean sendToDLAOnNoRoute = null;

    public boolean isLastValueQueue() {
        return this.lastValueQueue != null ? this.lastValueQueue : false;
    }

    public void setLastValueQueue(boolean lastValueQueue) {
        this.lastValueQueue = lastValueQueue;
    }

    public AddressFullMessagePolicy getAddressFullMessagePolicy() {
        return this.addressFullMessagePolicy != null ? this.addressFullMessagePolicy : DEFAULT_ADDRESS_FULL_MESSAGE_POLICY;
    }

    public void setAddressFullMessagePolicy(AddressFullMessagePolicy addressFullMessagePolicy) {
        this.addressFullMessagePolicy = addressFullMessagePolicy;
    }

    public int getPageSizeBytes() {
        return this.pageSizeBytes != null ? this.pageSizeBytes : 0xA00000;
    }

    public void setPageSizeBytes(int pageSize) {
        this.pageSizeBytes = pageSize;
    }

    public long getMaxSizeBytes() {
        return this.maxSizeBytes != null ? this.maxSizeBytes : -1L;
    }

    public void setMaxSizeBytes(long maxSizeBytes) {
        this.maxSizeBytes = maxSizeBytes;
    }

    public int getMaxDeliveryAttempts() {
        return this.maxDeliveryAttempts != null ? this.maxDeliveryAttempts : 10;
    }

    public void setMaxDeliveryAttempts(int maxDeliveryAttempts) {
        this.maxDeliveryAttempts = maxDeliveryAttempts;
    }

    public int getMessageCounterHistoryDayLimit() {
        return this.messageCounterHistoryDayLimit != null ? this.messageCounterHistoryDayLimit : 0;
    }

    public void setMessageCounterHistoryDayLimit(int messageCounterHistoryDayLimit) {
        this.messageCounterHistoryDayLimit = messageCounterHistoryDayLimit;
    }

    public long getRedeliveryDelay() {
        return this.redeliveryDelay != null ? this.redeliveryDelay : 0L;
    }

    public void setRedeliveryDelay(long redeliveryDelay) {
        this.redeliveryDelay = redeliveryDelay;
    }

    public SimpleString getDeadLetterAddress() {
        return this.deadLetterAddress;
    }

    public void setDeadLetterAddress(SimpleString deadLetterAddress) {
        this.deadLetterAddress = deadLetterAddress;
    }

    public SimpleString getExpiryAddress() {
        return this.expiryAddress;
    }

    public void setExpiryAddress(SimpleString expiryAddress) {
        this.expiryAddress = expiryAddress;
    }

    public boolean isSendToDLAOnNoRoute() {
        return this.sendToDLAOnNoRoute != null ? this.sendToDLAOnNoRoute : false;
    }

    public void setSendToDLAOnNoRoute(boolean value) {
        this.sendToDLAOnNoRoute = value;
    }

    public long getRedistributionDelay() {
        return this.redistributionDelay != null ? this.redistributionDelay : -1L;
    }

    public void setRedistributionDelay(long redistributionDelay) {
        this.redistributionDelay = redistributionDelay;
    }

    @Override
    public void merge(AddressSettings merged) {
        if (this.maxDeliveryAttempts == null) {
            this.maxDeliveryAttempts = merged.maxDeliveryAttempts;
        }
        if (this.dropMessagesWhenFull == null) {
            this.dropMessagesWhenFull = merged.dropMessagesWhenFull;
        }
        if (this.maxSizeBytes == null) {
            this.maxSizeBytes = merged.maxSizeBytes;
        }
        if (this.pageSizeBytes == null) {
            this.pageSizeBytes = merged.getPageSizeBytes();
        }
        if (this.messageCounterHistoryDayLimit == null) {
            this.messageCounterHistoryDayLimit = merged.messageCounterHistoryDayLimit;
        }
        if (this.redeliveryDelay == null) {
            this.redeliveryDelay = merged.redeliveryDelay;
        }
        if (this.deadLetterAddress == null) {
            this.deadLetterAddress = merged.deadLetterAddress;
        }
        if (this.expiryAddress == null) {
            this.expiryAddress = merged.expiryAddress;
        }
        if (this.redistributionDelay == null) {
            this.redistributionDelay = merged.redistributionDelay;
        }
        if (this.sendToDLAOnNoRoute == null) {
            this.sendToDLAOnNoRoute = merged.sendToDLAOnNoRoute;
        }
        if (this.addressFullMessagePolicy == null) {
            this.addressFullMessagePolicy = merged.addressFullMessagePolicy;
        }
    }
}

