/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.transaction.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.transaction.xa.Xid;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.server.HornetQComponent;
import org.hornetq.core.transaction.ResourceManager;
import org.hornetq.core.transaction.Transaction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceManagerImpl
implements ResourceManager,
HornetQComponent {
    private static final Logger log = Logger.getLogger(ResourceManagerImpl.class);
    private final ConcurrentMap<Xid, Transaction> transactions = new ConcurrentHashMap<Xid, Transaction>();
    private final List<HeuristicCompletionHolder> heuristicCompletions = new ArrayList<HeuristicCompletionHolder>();
    private final int defaultTimeoutSeconds;
    private volatile int timeoutSeconds;
    private boolean started = false;
    private TxTimeoutHandler task;
    private final long txTimeoutScanPeriod;
    private final ScheduledExecutorService scheduledThreadPool;

    public ResourceManagerImpl(int defaultTimeoutSeconds, long txTimeoutScanPeriod, ScheduledExecutorService scheduledThreadPool) {
        this.defaultTimeoutSeconds = defaultTimeoutSeconds;
        this.timeoutSeconds = defaultTimeoutSeconds;
        this.txTimeoutScanPeriod = txTimeoutScanPeriod;
        this.scheduledThreadPool = scheduledThreadPool;
    }

    @Override
    public void start() throws Exception {
        if (this.started) {
            return;
        }
        this.task = new TxTimeoutHandler();
        ScheduledFuture<?> future = this.scheduledThreadPool.scheduleAtFixedRate(this.task, this.txTimeoutScanPeriod, this.txTimeoutScanPeriod, TimeUnit.MILLISECONDS);
        this.task.setFuture(future);
        this.started = true;
    }

    @Override
    public void stop() throws Exception {
        if (!this.started) {
            return;
        }
        if (this.task != null) {
            this.task.close();
        }
        this.started = false;
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    @Override
    public Transaction getTransaction(Xid xid) {
        return (Transaction)this.transactions.get(xid);
    }

    @Override
    public boolean putTransaction(Xid xid, Transaction tx) {
        return this.transactions.putIfAbsent(xid, tx) == null;
    }

    @Override
    public Transaction removeTransaction(Xid xid) {
        return (Transaction)this.transactions.remove(xid);
    }

    @Override
    public int getTimeoutSeconds() {
        return this.timeoutSeconds;
    }

    @Override
    public boolean setTimeoutSeconds(int timeoutSeconds) {
        this.timeoutSeconds = timeoutSeconds == 0 ? this.defaultTimeoutSeconds : timeoutSeconds;
        return true;
    }

    @Override
    public List<Xid> getPreparedTransactions() {
        ArrayList<Xid> xids = new ArrayList<Xid>();
        for (Xid xid : this.transactions.keySet()) {
            if (((Transaction)this.transactions.get(xid)).getState() != Transaction.State.PREPARED) continue;
            xids.add(xid);
        }
        return xids;
    }

    @Override
    public Map<Xid, Long> getPreparedTransactionsWithCreationTime() {
        List<Xid> xids = this.getPreparedTransactions();
        HashMap<Xid, Long> xidsWithCreationTime = new HashMap<Xid, Long>();
        for (Xid xid : xids) {
            xidsWithCreationTime.put(xid, ((Transaction)this.transactions.get(xid)).getCreateTime());
        }
        return xidsWithCreationTime;
    }

    @Override
    public void putHeuristicCompletion(long recordID, Xid xid, boolean isCommit) {
        this.heuristicCompletions.add(new HeuristicCompletionHolder(recordID, xid, isCommit));
    }

    @Override
    public List<Xid> getHeuristicCommittedTransactions() {
        return this.getHeuristicCompletedTransactions(true);
    }

    @Override
    public List<Xid> getHeuristicRolledbackTransactions() {
        return this.getHeuristicCompletedTransactions(false);
    }

    @Override
    public long removeHeuristicCompletion(Xid xid) {
        Iterator<HeuristicCompletionHolder> iterator = this.heuristicCompletions.iterator();
        while (iterator.hasNext()) {
            HeuristicCompletionHolder holder = iterator.next();
            if (!holder.xid.equals(xid)) continue;
            iterator.remove();
            return holder.recordID;
        }
        return -1L;
    }

    private List<Xid> getHeuristicCompletedTransactions(boolean isCommit) {
        ArrayList<Xid> xids = new ArrayList<Xid>();
        for (HeuristicCompletionHolder holder : this.heuristicCompletions) {
            if (holder.isCommit != isCommit) continue;
            xids.add(holder.xid);
        }
        return xids;
    }

    private class HeuristicCompletionHolder {
        public final boolean isCommit;
        public final Xid xid;
        public final long recordID;

        public HeuristicCompletionHolder(long recordID, Xid xid, boolean isCommit) {
            this.recordID = recordID;
            this.xid = xid;
            this.isCommit = isCommit;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TxTimeoutHandler
    implements Runnable {
        private boolean closed = false;
        private Future<?> future;

        private TxTimeoutHandler() {
        }

        @Override
        public void run() {
            if (this.closed) {
                return;
            }
            HashSet<Transaction> timedoutTransactions = new HashSet<Transaction>();
            long now = System.currentTimeMillis();
            for (Transaction tx : ResourceManagerImpl.this.transactions.values()) {
                if (tx.getState() == Transaction.State.PREPARED || now <= tx.getCreateTime() + (long)(ResourceManagerImpl.this.timeoutSeconds * 1000)) continue;
                ResourceManagerImpl.this.transactions.remove(tx.getXid());
                log.warn("transaction with xid " + tx.getXid() + " timed out");
                timedoutTransactions.add(tx);
            }
            for (Transaction failedTransaction : timedoutTransactions) {
                try {
                    failedTransaction.rollback();
                }
                catch (Exception e) {
                    log.error("failed to timeout transaction, xid:" + failedTransaction.getXid(), e);
                }
            }
        }

        synchronized void setFuture(Future<?> future) {
            this.future = future;
        }

        void close() {
            if (this.future != null) {
                this.future.cancel(false);
            }
            this.closed = true;
        }
    }
}

