/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.spi.core.security;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.security.CheckType;
import org.hornetq.core.security.Role;
import org.hornetq.spi.core.security.HornetQSecurityManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HornetQSecurityManagerImpl
implements HornetQSecurityManager {
    private static final Logger log = Logger.getLogger(HornetQSecurityManagerImpl.class);
    private final Map<String, User> users = new HashMap<String, User>();
    private String defaultUser = null;
    private final Map<String, List<String>> roles = new HashMap<String, List<String>>();

    @Override
    public void start() {
    }

    @Override
    public void stop() {
        this.users.clear();
        this.roles.clear();
        this.defaultUser = null;
    }

    @Override
    public boolean isStarted() {
        return true;
    }

    @Override
    public boolean validateUser(String user, String password) {
        if (user == null && this.defaultUser == null) {
            return false;
        }
        User theUser = this.users.get(user == null ? this.defaultUser : user);
        boolean ok = theUser != null && theUser.isValid(user == null ? this.defaultUser : user, password == null ? this.defaultUser : password);
        return ok;
    }

    @Override
    public boolean validateUserAndRole(String user, String password, Set<Role> roles, CheckType checkType) {
        if (this.validateUser(user, password)) {
            List<String> availableRoles = this.roles.get(user == null ? this.defaultUser : user);
            if (availableRoles == null) {
                return false;
            }
            for (String availableRole : availableRoles) {
                if (roles == null) continue;
                for (Role role : roles) {
                    if (!role.getName().equals(availableRole) || !checkType.hasRole(role)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public void addUser(String user, String password) {
        if (user == null) {
            throw new IllegalArgumentException("User cannot be null");
        }
        if (password == null) {
            throw new IllegalArgumentException("password cannot be null");
        }
        this.users.put(user, new User(user, password));
    }

    @Override
    public void removeUser(String user) {
        this.users.remove(user);
        this.roles.remove(user);
    }

    @Override
    public void addRole(String user, String role) {
        if (this.roles.get(user) == null) {
            this.roles.put(user, new ArrayList());
        }
        this.roles.get(user).add(role);
    }

    @Override
    public void removeRole(String user, String role) {
        if (this.roles.get(user) == null) {
            return;
        }
        this.roles.get(user).remove(role);
    }

    @Override
    public void setDefaultUser(String username) {
        this.defaultUser = username;
    }

    static class User {
        final String user;
        final String password;

        User(String user, String password) {
            this.user = user;
            this.password = password;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            User user1 = (User)o;
            return this.user.equals(user1.user);
        }

        public int hashCode() {
            return this.user.hashCode();
        }

        public boolean isValid(String user, String password) {
            if (user == null) {
                return false;
            }
            return this.user.equals(user) && this.password.equals(password);
        }
    }
}

