/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.utils;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class HornetQThreadFactory
implements ThreadFactory {
    private final ThreadGroup group;
    private final AtomicInteger threadCount = new AtomicInteger(0);
    private final int threadPriority;
    private final boolean daemon;

    public HornetQThreadFactory(String groupName, boolean daemon) {
        this(groupName, 5, daemon);
    }

    public HornetQThreadFactory(String groupName, int threadPriority, boolean daemon) {
        this.group = new ThreadGroup(groupName + "-" + System.identityHashCode(this));
        this.threadPriority = threadPriority;
        this.daemon = daemon;
    }

    public Thread newThread(Runnable command) {
        Thread t = null;
        t = System.getSecurityManager() == null ? new Thread(this.group, command, "Thread-" + this.threadCount.getAndIncrement() + " (group:" + this.group.getName() + ")") : new Thread(command, "Thread-" + this.threadCount.getAndIncrement());
        t.setDaemon(this.daemon);
        t.setPriority(this.threadPriority);
        return t;
    }
}

