/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formbuilder.server.trans.ftl;

import org.jbpm.formapi.server.trans.ScriptingTranslator;
import org.jbpm.formapi.server.trans.TranslatorException;
import org.jbpm.formapi.server.trans.TranslatorFactory;
import org.jbpm.formapi.shared.api.FBScript;

public class Translator
extends ScriptingTranslator {
    private static final String LANG = "ftl";

    public Translator() {
        super(LANG, "/langs/freemarker/");
    }

    public String toServerScript(FBScript script) throws TranslatorException {
        if (this.isValidScript(script)) {
            return this.asFtlScript(script);
        }
        throw new TranslatorException(script.getType() + " is not a supported language");
    }

    public String asFtlVar(String varName) {
        return varName == null ? "" : "${" + varName + "}";
    }

    private String asFtlScript(FBScript script) {
        StringBuilder builder = new StringBuilder();
        if (script.getContent() != null && !"".equals(script.getContent())) {
            builder.append(script.getContent());
        } else if (script.getSrc() != null && !"".equals(script.getSrc())) {
            builder.append("<#include '").append(script.getSrc()).append("'>\n");
        }
        return builder.toString();
    }

    private boolean isValidScript(FBScript script) {
        return script != null && script.getType() != null && (script.getType().contains(LANG) || script.getType().contains("freemarker"));
    }

    public boolean isClientScript(FBScript script) {
        return TranslatorFactory.getInstance().isClientSide(script.getType());
    }
}

