/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formbuilder.server.render.gwt;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.io.IOUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.resource.loader.URLResourceLoader;
import org.jbpm.formapi.server.render.RendererException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Renderer
implements org.jbpm.formapi.server.render.Renderer {
    private final VelocityEngine engine = new VelocityEngine();
    private final URL velocityTemplate = this.getClass().getResource("/langs/gwt/index.vm");
    private Template template = null;

    public Renderer() {
        String folderFileLocation = this.velocityTemplate.toExternalForm().replace("index.vm", "");
        this.engine.setProperty("resource.loader", (Object)"url");
        this.engine.setProperty("url.resource.loader.class", (Object)URLResourceLoader.class.getName());
        this.engine.setProperty("url.resource.loader.root", (Object)folderFileLocation);
        this.engine.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object render(URL url, Map<String, Object> inputData) throws RendererException {
        if (this.velocityTemplate == null) {
            throw new RendererException("Couldn't find index.vm");
        }
        Renderer renderer = this;
        synchronized (renderer) {
            if (this.template == null) {
                this.template = this.engine.getTemplate("index.vm");
            }
        }
        try {
            String formContent = IOUtils.toString((InputStream)url.openStream());
            JsonObject json = new JsonObject();
            json.addProperty("formjson", formContent);
            String contextPath = (String)inputData.remove(BASE_CONTEXT_PATH);
            json.add("formData", (JsonElement)this.toJsonObject(inputData));
            json.addProperty("contextPath", contextPath);
            VelocityContext context = new VelocityContext();
            context.put("contextPath", (Object)contextPath);
            context.put("formContent", (Object)json.toString());
            StringWriter writer = new StringWriter();
            this.template.merge((Context)context, (Writer)writer);
            return writer.toString();
        }
        catch (IOException e) {
            throw new RendererException("Problem reading index.vm", (Throwable)e);
        }
    }

    protected JsonObject toJsonObject(Map<String, Object> inputData) {
        JsonObject retval = new JsonObject();
        if (inputData != null) {
            for (String key : inputData.keySet()) {
                Object value = inputData.get(key);
                retval.add(key, this.asJsonValue(value));
            }
        }
        return retval;
    }

    private JsonElement asJsonValue(Object value) {
        Field[] fields;
        if (value == null) {
            return new JsonNull();
        }
        if (value.getClass().isArray()) {
            Object[] arr = (Object[])value;
            JsonArray retval = new JsonArray();
            for (Object sub : arr) {
                retval.add(this.asJsonValue(sub));
            }
            return retval;
        }
        if (value instanceof Boolean) {
            return new JsonPrimitive((Boolean)value);
        }
        if (value instanceof Number) {
            return new JsonPrimitive((Number)value);
        }
        if (value instanceof String) {
            return new JsonPrimitive((String)value);
        }
        HashMap<String, Object> retval = new HashMap<String, Object>();
        for (Field field : fields = value.getClass().getFields()) {
            try {
                Object subVal = PropertyUtils.getProperty((Object)value, (String)field.getName());
                retval.put(field.getName(), subVal);
            }
            catch (Exception e) {
                retval.put(field.getName(), null);
            }
        }
        return this.toJsonObject(retval);
    }
}

