/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.persistence.processinstance;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import org.hibernate.HibernateException;
import org.hibernate.usertype.UserType;

public class BlobUserType
implements UserType {
    public int[] sqlTypes() {
        return new int[]{2004};
    }

    public Class returnedClass() {
        return byte[].class;
    }

    public boolean equals(Object x, Object y) throws HibernateException {
        return x == y || x != null && Arrays.equals((byte[])x, (byte[])y);
    }

    public int hashCode(Object x) throws HibernateException {
        if (x == null) {
            return 0;
        }
        if (x instanceof byte[]) {
            byte[] xArr = (byte[])x;
            return Arrays.hashCode(xArr);
        }
        return x.hashCode();
    }

    public Object nullSafeGet(ResultSet resultSet, String[] names, Object owner) throws HibernateException, SQLException {
        Blob blob = resultSet.getBlob(names[0]);
        if (blob == null) {
            return null;
        }
        return blob.getBytes(1L, (int)blob.length());
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index) throws HibernateException, SQLException {
        if (value != null) {
            byte[] valueByteArr = (byte[])value;
            ByteArrayInputStream bais = new ByteArrayInputStream(valueByteArr);
            st.setBinaryStream(index, (InputStream)bais, valueByteArr.length);
        } else {
            st.setNull(index, this.sqlTypes()[0]);
        }
    }

    public Object deepCopy(Object value) {
        if (value == null) {
            return null;
        }
        byte[] bytes = (byte[])value;
        byte[] result = new byte[bytes.length];
        System.arraycopy(bytes, 0, result, 0, bytes.length);
        return result;
    }

    public boolean isMutable() {
        return true;
    }

    public Serializable disassemble(Object value) throws HibernateException {
        return (Serializable)this.deepCopy(value);
    }

    public Object assemble(Serializable cached, Object owner) throws HibernateException {
        return this.deepCopy(cached);
    }

    public Object replace(Object original, Object target, Object owner) throws HibernateException {
        return original;
    }
}

