/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.admin;

import java.util.Date;
import java.util.List;
import org.jbpm.task.Status;
import org.jbpm.task.Task;
import org.jbpm.task.admin.TasksAdmin;
import org.jbpm.task.query.TaskSummary;
import org.jbpm.task.service.TaskServiceSession;
import org.jbpm.task.service.persistence.TaskPersistenceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TasksAdminImpl
implements TasksAdmin {
    protected TaskPersistenceManager tpm;
    private static final Logger logger = LoggerFactory.getLogger(TaskServiceSession.class);

    public TasksAdminImpl(TaskPersistenceManager tpm) {
        this.tpm = tpm;
    }

    @Override
    public List<TaskSummary> getActiveTasks() {
        return this.tpm.createQuery("TasksByStatus").setParameter("status", (Object)Status.InProgress).setParameter("language", (Object)"en-UK").getResultList();
    }

    @Override
    public List<TaskSummary> getActiveTasks(Date since) {
        return this.tpm.createQuery("TasksByStatus").setParameter("status", (Object)Status.InProgress).setParameter("language", (Object)"en-UK").setParameter("since", (Object)since).getResultList();
    }

    @Override
    public List<TaskSummary> getCompletedTasks() {
        return this.tpm.createQuery("TasksByStatus").setParameter("status", (Object)Status.Completed).setParameter("language", (Object)"en-UK").getResultList();
    }

    @Override
    public List<TaskSummary> getCompletedTasks(Date since) {
        return this.tpm.createQuery("TasksByStatusSince").setParameter("status", (Object)Status.Completed).setParameter("language", (Object)"en-UK").setParameter("since", (Object)since).getResultList();
    }

    @Override
    public List<TaskSummary> getCompletedTasksByProcessId(Long processId) {
        return this.tpm.createQuery("TasksByStatusByProcessId").setParameter("status", (Object)Status.Completed).setParameter("language", (Object)"en-UK").setParameter("processId", (Object)processId).getResultList();
    }

    @Override
    public int archiveTasks(List<TaskSummary> tasks) {
        int archivedTasks = 0;
        this.tpm.beginTransaction();
        for (TaskSummary sum : tasks) {
            long taskId = sum.getId();
            Task task = (Task)this.tpm.findEntity(Task.class, taskId);
            task.setArchived(true);
            this.tpm.saveEntity(task);
            ++archivedTasks;
        }
        this.tpm.endTransaction(true);
        return archivedTasks;
    }

    @Override
    public int removeTasks(List<TaskSummary> tasks) {
        int removedTasks = 0;
        this.tpm.beginTransaction();
        for (TaskSummary sum : tasks) {
            long taskId = sum.getId();
            Task task = (Task)this.tpm.findEntity(Task.class, taskId);
            if (task.isArchived().booleanValue()) {
                this.tpm.deleteEntity(task);
                ++removedTasks;
                continue;
            }
            logger.error(" The Task cannot be removed if it wasn't archived first !!");
        }
        this.tpm.endTransaction(true);
        return removedTasks;
    }

    @Override
    public List<TaskSummary> getArchivedTasks() {
        return this.tpm.createQuery("ArchivedTasks").setParameter("language", (Object)"en-UK").getResultList();
    }

    @Override
    public void dispose() {
        this.tpm.endPersistenceContext();
    }
}

