/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jbpm.task.Group;
import org.jbpm.task.OrganizationalEntity;
import org.jbpm.task.User;
import org.jbpm.task.UserInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultUserInfo
implements UserInfo {
    protected Map<String, Map<String, Object>> registry = new HashMap<String, Map<String, Object>>();

    public DefaultUserInfo(Properties registryProps) {
        this.buildRegistry(registryProps);
    }

    @Override
    public String getDisplayName(OrganizationalEntity entity) {
        Map<String, Object> entityInfo = this.registry.get(entity.getId());
        if (entityInfo != null) {
            return (String)entityInfo.get("name");
        }
        return null;
    }

    @Override
    public Iterator<OrganizationalEntity> getMembersForGroup(Group group) {
        Map<String, Object> entityInfo = this.registry.get(group.getId());
        if (entityInfo != null) {
            return ((List)entityInfo.get("members")).iterator();
        }
        return null;
    }

    @Override
    public boolean hasEmail(Group group) {
        Map<String, Object> entityInfo = this.registry.get(group.getId());
        if (entityInfo != null) {
            return entityInfo.containsKey("email");
        }
        return false;
    }

    @Override
    public String getEmailForEntity(OrganizationalEntity entity) {
        Map<String, Object> entityInfo = this.registry.get(entity.getId());
        if (entityInfo != null) {
            return (String)entityInfo.get("email");
        }
        throw new IllegalStateException("No EMail address found for " + entity.getId());
    }

    @Override
    public String getLanguageForEntity(OrganizationalEntity entity) {
        Map<String, Object> entityInfo = this.registry.get(entity.getId());
        if (entityInfo != null) {
            return (String)entityInfo.get("locale");
        }
        return null;
    }

    protected void buildRegistry(Properties registryProps) {
        if (registryProps != null) {
            for (String string : registryProps.keySet()) {
                String propertyValue = registryProps.getProperty(string);
                String[] elems = propertyValue.split(":");
                HashMap<String, Object> entityInfo = new HashMap<String, Object>();
                entityInfo.put("email", elems[0]);
                entityInfo.put("locale", elems[1]);
                entityInfo.put("name", elems[2]);
                if (elems.length == 4 && elems[3] != null) {
                    String memberList = elems[3];
                    if (memberList.startsWith("[")) {
                        memberList = memberList.substring(1);
                    }
                    if (memberList.endsWith("]")) {
                        memberList = memberList.substring(0, memberList.length() - 1);
                    }
                    String[] members = memberList.split(",");
                    ArrayList<User> membersList = new ArrayList<User>();
                    for (String member : members) {
                        membersList.add(new User(member));
                    }
                    entityInfo.put("members", membersList);
                }
                this.registry.put(string, entityInfo);
            }
        }
    }
}

