/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.service.persistence;

import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import org.jbpm.task.service.persistence.TaskTransactionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TaskLocalTransactionManager
implements TaskTransactionManager {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    TaskLocalTransactionManager() {
    }

    public void attachPersistenceContext(EntityManager em) {
    }

    public boolean begin(EntityManager em) {
        boolean begun = false;
        if (this.getStatus(em) == 3) {
            try {
                em.getTransaction().begin();
                begun = true;
            }
            catch (Exception e) {
                this.logger.warn("Unable to begin transaction", (Throwable)e);
                throw new RuntimeException("Unable to begin transaction", e);
            }
        }
        return begun;
    }

    public void commit(EntityManager em, boolean txOwner) {
        try {
            if (txOwner) {
                em.getTransaction().commit();
            }
        }
        catch (Exception e) {
            this.logger.warn("Unable to begin transaction", (Throwable)e);
            throw new RuntimeException("Unable to commit transaction", e);
        }
    }

    public void rollback(EntityManager em, boolean txOwner) {
        if (this.getStatus(em) == 6) {
            return;
        }
        try {
            if (txOwner) {
                em.getTransaction().rollback();
            } else {
                em.getTransaction().setRollbackOnly();
            }
        }
        catch (Exception e) {
            this.logger.warn("Unable to rollback transaction", (Throwable)e);
            throw new RuntimeException("Unable to rollback transaction", e);
        }
    }

    public int getStatus(EntityManager em) {
        EntityTransaction tx = em.getTransaction();
        if (tx.isActive()) {
            return 4;
        }
        return 3;
    }

    public void dispose() {
    }
}

