/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Map;
import org.drools.marshalling.ObjectMarshallingStrategy;
import org.drools.marshalling.ObjectMarshallingStrategyAcceptor;
import org.drools.marshalling.impl.ClassObjectMarshallingStrategyAcceptor;
import org.drools.marshalling.impl.SerializablePlaceholderResolverStrategy;
import org.drools.runtime.Environment;
import org.jbpm.task.AccessType;
import org.jbpm.task.service.ContentData;
import org.jbpm.task.utils.ContentMarshallerContext;
import org.jbpm.task.utils.MarshalledContentWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentMarshallerHelper {
    private static final Logger logger = LoggerFactory.getLogger(ContentMarshallerHelper.class);

    public static ContentData marshal(Object o, ContentMarshallerContext marshallerContext, Environment env) {
        ObjectMarshallingStrategy[] strats = null;
        strats = env != null && env.get("drools.marshalling.ObjectMarshallingStrategies") != null ? (ObjectMarshallingStrategy[])env.get("drools.marshalling.ObjectMarshallingStrategies") : new ObjectMarshallingStrategy[]{new SerializablePlaceholderResolverStrategy((ObjectMarshallingStrategyAcceptor)ClassObjectMarshallingStrategyAcceptor.DEFAULT)};
        ContentData content = null;
        if (o instanceof Map) {
            for (Object key : ((Map)o).keySet()) {
                Object value = ((Map)o).get(key);
                if (value == null) continue;
                MarshalledContentWrapper marshalledValue = null;
                for (ObjectMarshallingStrategy strat : strats) {
                    if (!strat.accept(value)) continue;
                    marshalledValue = ContentMarshallerHelper.marshalSingle(strat, marshallerContext, value);
                    break;
                }
                ((Map)o).put(key, marshalledValue);
            }
        }
        MarshalledContentWrapper marshalled = null;
        for (ObjectMarshallingStrategy strat : strats) {
            if (!strat.accept(o)) continue;
            marshalled = ContentMarshallerHelper.marshalSingle(strat, marshallerContext, o);
            break;
        }
        content = new ContentData();
        content.setContent(marshalled.getContent());
        content.setType(marshalled.getMarshaller());
        content.setAccessType(AccessType.Inline);
        return content;
    }

    private static MarshalledContentWrapper marshalSingle(ObjectMarshallingStrategy strat, ContentMarshallerContext marshallerContext, Object o) {
        MarshalledContentWrapper contentWrap = null;
        try {
            ObjectMarshallingStrategy.Context context = null;
            if (marshallerContext != null) {
                if (marshallerContext.strategyContext.get(strat.getClass()) == null) {
                    context = strat.createContext();
                    marshallerContext.strategyContext.put(strat.getClass(), context);
                } else {
                    context = marshallerContext.strategyContext.get(strat.getClass());
                }
            } else {
                throw new IllegalStateException(" The Marshaller Context Needs to be Provided");
            }
            byte[] marshalled = null;
            if (marshallerContext.isUseMarshal()) {
                marshalled = strat.marshal(context, null, o);
            } else {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ObjectOutputStream out = new ObjectOutputStream(baos);
                strat.write(out, o);
                marshalled = baos.toByteArray();
                out.close();
                baos.close();
            }
            contentWrap = new MarshalledContentWrapper(marshalled, strat.getClass().getCanonicalName(), o.getClass());
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return contentWrap;
    }

    public static Object unmarshall(String type, byte[] content, ContentMarshallerContext marshallerContext, Environment env) {
        ObjectMarshallingStrategy[] strats = null;
        strats = env != null && env.get("drools.marshalling.ObjectMarshallingStrategies") != null ? (ObjectMarshallingStrategy[])env.get("drools.marshalling.ObjectMarshallingStrategies") : (!marshallerContext.getStrategies().isEmpty() ? (ObjectMarshallingStrategy[])marshallerContext.getStrategies().toArray() : new ObjectMarshallingStrategy[]{new SerializablePlaceholderResolverStrategy((ObjectMarshallingStrategyAcceptor)ClassObjectMarshallingStrategyAcceptor.DEFAULT)});
        HashMap data = null;
        Object selectedStrat = null;
        for (ObjectMarshallingStrategy strat : strats) {
            if (!strat.getClass().getCanonicalName().equals(type)) continue;
            selectedStrat = strat;
        }
        ObjectMarshallingStrategy.Context context = marshallerContext.strategyContext.get(selectedStrat.getClass());
        try {
            if (marshallerContext.isUseMarshal()) {
                data = selectedStrat.unmarshal(context, null, content, ContentMarshallerHelper.class.getClassLoader());
            } else {
                ByteArrayInputStream bs = new ByteArrayInputStream(content);
                ObjectInputStream oIn = new ObjectInputStream(bs);
                data = selectedStrat.read(oIn);
                oIn.close();
                bs.close();
            }
            if (data instanceof Map) {
                ByteArrayInputStream bs = null;
                ObjectInputStream oIn = null;
                HashMap localData = new HashMap();
                for (Object key : ((Map)data).keySet()) {
                    MarshalledContentWrapper value = (MarshalledContentWrapper)((Map)data).get(key);
                    Object unmarshalledObj = null;
                    for (ObjectMarshallingStrategy strat : strats) {
                        if (!strat.getClass().getCanonicalName().equals(value.getMarshaller())) continue;
                        selectedStrat = strat;
                    }
                    context = marshallerContext.strategyContext.get(selectedStrat.getClass());
                    if (marshallerContext.isUseMarshal()) {
                        unmarshalledObj = selectedStrat.unmarshal(context, null, value.getContent(), ContentMarshallerHelper.class.getClassLoader());
                    } else {
                        bs = new ByteArrayInputStream(value.getContent());
                        oIn = new ObjectInputStream(bs);
                        unmarshalledObj = selectedStrat.read(oIn);
                        oIn.close();
                        bs.close();
                    }
                    localData.put(key, unmarshalledObj);
                }
                data = localData;
            }
        }
        catch (IOException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        catch (ClassNotFoundException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        return data;
    }
}

