/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.replication.impl;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.SimpleString;
import org.hornetq.core.config.Configuration;
import org.hornetq.core.journal.IOCriticalErrorListener;
import org.hornetq.core.journal.Journal;
import org.hornetq.core.journal.JournalLoadInformation;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.paging.Page;
import org.hornetq.core.paging.PagedMessage;
import org.hornetq.core.paging.PagingManager;
import org.hornetq.core.paging.impl.PagingManagerImpl;
import org.hornetq.core.paging.impl.PagingStoreFactoryNIO;
import org.hornetq.core.persistence.impl.journal.JournalStorageManager;
import org.hornetq.core.protocol.core.Channel;
import org.hornetq.core.protocol.core.Packet;
import org.hornetq.core.protocol.core.impl.PacketImpl;
import org.hornetq.core.protocol.core.impl.wireformat.HornetQExceptionMessage;
import org.hornetq.core.protocol.core.impl.wireformat.NullResponseMessage;
import org.hornetq.core.protocol.core.impl.wireformat.ReplicationAddMessage;
import org.hornetq.core.protocol.core.impl.wireformat.ReplicationAddTXMessage;
import org.hornetq.core.protocol.core.impl.wireformat.ReplicationCommitMessage;
import org.hornetq.core.protocol.core.impl.wireformat.ReplicationCompareDataMessage;
import org.hornetq.core.protocol.core.impl.wireformat.ReplicationDeleteMessage;
import org.hornetq.core.protocol.core.impl.wireformat.ReplicationDeleteTXMessage;
import org.hornetq.core.protocol.core.impl.wireformat.ReplicationLargeMessageBeingMessage;
import org.hornetq.core.protocol.core.impl.wireformat.ReplicationLargeMessageWriteMessage;
import org.hornetq.core.protocol.core.impl.wireformat.ReplicationLargemessageEndMessage;
import org.hornetq.core.protocol.core.impl.wireformat.ReplicationPageEventMessage;
import org.hornetq.core.protocol.core.impl.wireformat.ReplicationPageWriteMessage;
import org.hornetq.core.protocol.core.impl.wireformat.ReplicationPrepareMessage;
import org.hornetq.core.protocol.core.impl.wireformat.ReplicationResponseMessage;
import org.hornetq.core.replication.ReplicationEndpoint;
import org.hornetq.core.server.HornetQServer;
import org.hornetq.core.server.LargeServerMessage;
import org.hornetq.core.server.ServerMessage;

public class ReplicationEndpointImpl
implements ReplicationEndpoint {
    private static final Logger log = Logger.getLogger(ReplicationEndpointImpl.class);
    private static final boolean trace = log.isTraceEnabled();
    private final IOCriticalErrorListener criticalErrorListener;
    private final HornetQServer server;
    private Channel channel;
    private Journal[] journals;
    private JournalStorageManager storage;
    private PagingManager pageManager;
    private JournalLoadInformation[] journalLoadInformation;
    private final ConcurrentMap<SimpleString, ConcurrentMap<Integer, Page>> pageIndex = new ConcurrentHashMap<SimpleString, ConcurrentMap<Integer, Page>>();
    private final ConcurrentMap<Long, LargeServerMessage> largeMessages = new ConcurrentHashMap<Long, LargeServerMessage>();
    private boolean deletePages = true;

    private static void trace(String msg) {
        log.trace(msg);
    }

    public ReplicationEndpointImpl(HornetQServer server, IOCriticalErrorListener criticalErrorListener) {
        this.server = server;
        this.criticalErrorListener = criticalErrorListener;
    }

    @Override
    public void registerJournal(byte id, Journal journal) {
        if (this.journals == null || id >= this.journals.length) {
            Journal[] oldJournals = this.journals;
            this.journals = new Journal[id + 1];
            if (oldJournals != null) {
                for (int i = 0; i < oldJournals.length; ++i) {
                    this.journals[i] = oldJournals[i];
                }
            }
        }
        this.journals[id] = journal;
    }

    @Override
    public void handlePacket(Packet packet) {
        PacketImpl response = new ReplicationResponseMessage();
        try {
            if (packet.getType() == 91) {
                this.handleAppendAddRecord((ReplicationAddMessage)packet);
            } else if (packet.getType() == 92) {
                this.handleAppendAddTXRecord((ReplicationAddTXMessage)packet);
            } else if (packet.getType() == 93) {
                this.handleAppendDelete((ReplicationDeleteMessage)packet);
            } else if (packet.getType() == 94) {
                this.handleAppendDeleteTX((ReplicationDeleteTXMessage)packet);
            } else if (packet.getType() == 95) {
                this.handlePrepare((ReplicationPrepareMessage)packet);
            } else if (packet.getType() == 96) {
                this.handleCommitRollback((ReplicationCommitMessage)packet);
            } else if (packet.getType() == 97) {
                this.handlePageWrite((ReplicationPageWriteMessage)packet);
            } else if (packet.getType() == 98) {
                this.handlePageEvent((ReplicationPageEventMessage)packet);
            } else if (packet.getType() == 99) {
                this.handleLargeMessageBegin((ReplicationLargeMessageBeingMessage)packet);
            } else if (packet.getType() == 101) {
                this.handleLargeMessageWrite((ReplicationLargeMessageWriteMessage)packet);
            } else if (packet.getType() == 100) {
                this.handleLargeMessageEnd((ReplicationLargemessageEndMessage)packet);
            } else if (packet.getType() == 102) {
                this.handleCompareDataMessage((ReplicationCompareDataMessage)packet);
                response = new NullResponseMessage();
            } else {
                log.warn("Packet " + packet + " can't be processed by the ReplicationEndpoint");
            }
        }
        catch (Exception e) {
            log.warn(e.getMessage(), e);
            response = new HornetQExceptionMessage((HornetQException)e);
        }
        this.channel.send(response);
    }

    @Override
    public boolean isStarted() {
        return true;
    }

    @Override
    public void start() throws Exception {
        Configuration config = this.server.getConfiguration();
        this.storage = new JournalStorageManager(config, this.server.getExecutorFactory(), this.criticalErrorListener);
        this.storage.start();
        this.server.getManagementService().setStorageManager(this.storage);
        this.registerJournal((byte)1, this.storage.getMessageJournal());
        this.registerJournal((byte)0, this.storage.getBindingsJournal());
        this.journalLoadInformation = this.storage.loadInternalOnly();
        this.pageManager = new PagingManagerImpl(new PagingStoreFactoryNIO(config.getPagingDirectory(), config.getJournalBufferSize_NIO(), this.server.getScheduledPool(), this.server.getExecutorFactory(), config.isJournalSyncNonTransactional(), this.criticalErrorListener), this.storage, this.server.getAddressSettingsRepository());
        this.pageManager.start();
    }

    @Override
    public void stop() throws Exception {
        if (this.channel != null) {
            this.channel.close();
        }
        this.storage.stop();
        for (ConcurrentMap map : this.pageIndex.values()) {
            for (Page page : map.values()) {
                try {
                    page.close();
                }
                catch (Exception e) {
                    log.warn("Error while closing the page on backup", e);
                }
            }
        }
        this.pageIndex.clear();
        for (LargeServerMessage largeMessage : this.largeMessages.values()) {
            largeMessage.releaseResources();
        }
        this.largeMessages.clear();
        this.pageManager.stop();
    }

    @Override
    public Channel getChannel() {
        return this.channel;
    }

    @Override
    public void setChannel(Channel channel) {
        this.channel = channel;
    }

    @Override
    public void compareJournalInformation(JournalLoadInformation[] journalInformation) throws HornetQException {
        if (this.journalLoadInformation == null || this.journalLoadInformation.length != journalInformation.length) {
            throw new HornetQException(0, "Live Node contains more journals than the backup node. Probably a version match error");
        }
        for (int i = 0; i < journalInformation.length; ++i) {
            if (journalInformation[i].equals(this.journalLoadInformation[i])) continue;
            log.warn("Journal comparisson mismatch:\n" + this.journalParametersToString(journalInformation));
            throw new HornetQException(104, "Backup node can't connect to the live node as the data differs");
        }
    }

    public void setDeletePages(boolean deletePages) {
        this.deletePages = deletePages;
    }

    private String journalParametersToString(JournalLoadInformation[] journalInformation) {
        return "**********************************************************\nparameters:\nBindings = " + journalInformation[0] + "\n" + "Messaging = " + journalInformation[1] + "\n" + "**********************************************************" + "\n" + "Expected:" + "\n" + "Bindings = " + this.journalLoadInformation[0] + "\n" + "Messaging = " + this.journalLoadInformation[1] + "\n" + "**********************************************************";
    }

    private void handleLargeMessageEnd(ReplicationLargemessageEndMessage packet) {
        LargeServerMessage message = this.lookupLargeMessage(packet.getMessageId(), true);
        if (message != null) {
            try {
                message.deleteFile();
            }
            catch (Exception e) {
                log.warn("Error deleting large message ID = " + packet.getMessageId(), e);
            }
        }
    }

    private void handleLargeMessageWrite(ReplicationLargeMessageWriteMessage packet) throws Exception {
        LargeServerMessage message = this.lookupLargeMessage(packet.getMessageId(), false);
        if (message != null) {
            message.addBytes(packet.getBody());
        }
    }

    private void handleCompareDataMessage(ReplicationCompareDataMessage request) throws HornetQException {
        this.compareJournalInformation(request.getJournalInformation());
    }

    private LargeServerMessage lookupLargeMessage(long messageId, boolean delete) {
        LargeServerMessage message = delete ? (LargeServerMessage)this.largeMessages.remove(messageId) : (LargeServerMessage)this.largeMessages.get(messageId);
        if (message == null) {
            log.warn("Large MessageID " + messageId + "  is not available on backup server. Ignoring replication message");
        }
        return message;
    }

    private void handleLargeMessageBegin(ReplicationLargeMessageBeingMessage packet) {
        LargeServerMessage largeMessage = this.storage.createLargeMessage();
        largeMessage.setDurable(true);
        largeMessage.setMessageID(packet.getMessageId());
        ReplicationEndpointImpl.trace("Receiving Large Message " + largeMessage.getMessageID() + " on backup");
        this.largeMessages.put(largeMessage.getMessageID(), largeMessage);
    }

    private void handleCommitRollback(ReplicationCommitMessage packet) throws Exception {
        Journal journalToUse = this.getJournal(packet.getJournalID());
        if (packet.isRollback()) {
            journalToUse.appendRollbackRecord(packet.getTxId(), false);
        } else {
            journalToUse.appendCommitRecord(packet.getTxId(), false);
        }
    }

    private void handlePrepare(ReplicationPrepareMessage packet) throws Exception {
        Journal journalToUse = this.getJournal(packet.getJournalID());
        journalToUse.appendPrepareRecord(packet.getTxId(), packet.getRecordData(), false);
    }

    private void handleAppendDeleteTX(ReplicationDeleteTXMessage packet) throws Exception {
        Journal journalToUse = this.getJournal(packet.getJournalID());
        journalToUse.appendDeleteRecordTransactional(packet.getTxId(), packet.getId(), packet.getRecordData());
    }

    private void handleAppendDelete(ReplicationDeleteMessage packet) throws Exception {
        Journal journalToUse = this.getJournal(packet.getJournalID());
        journalToUse.appendDeleteRecord(packet.getId(), false);
    }

    private void handleAppendAddTXRecord(ReplicationAddTXMessage packet) throws Exception {
        Journal journalToUse = this.getJournal(packet.getJournalID());
        if (packet.isUpdate()) {
            journalToUse.appendUpdateRecordTransactional(packet.getTxId(), packet.getId(), packet.getRecordType(), packet.getRecordData());
        } else {
            journalToUse.appendAddRecordTransactional(packet.getTxId(), packet.getId(), packet.getRecordType(), packet.getRecordData());
        }
    }

    private void handleAppendAddRecord(ReplicationAddMessage packet) throws Exception {
        Journal journalToUse = this.getJournal(packet.getJournalID());
        if (packet.isUpdate()) {
            if (trace) {
                ReplicationEndpointImpl.trace("Endpoint appendUpdate id = " + packet.getId());
            }
            journalToUse.appendUpdateRecord(packet.getId(), packet.getRecordType(), packet.getRecordData(), false);
        } else {
            if (trace) {
                ReplicationEndpointImpl.trace("Endpoint append id = " + packet.getId());
            }
            journalToUse.appendAddRecord(packet.getId(), packet.getRecordType(), packet.getRecordData(), false);
        }
    }

    private void handlePageEvent(ReplicationPageEventMessage packet) throws Exception {
        ConcurrentMap<Integer, Page> pages = this.getPageMap(packet.getStoreName());
        Page page = (Page)pages.remove(packet.getPageNumber());
        if (page == null) {
            page = this.getPage(packet.getStoreName(), packet.getPageNumber());
        }
        if (page != null) {
            if (packet.isDelete()) {
                if (this.deletePages) {
                    page.delete(null);
                }
            } else {
                page.close();
            }
        }
    }

    private void handlePageWrite(ReplicationPageWriteMessage packet) throws Exception {
        PagedMessage pgdMessage = packet.getPagedMessage();
        pgdMessage.initMessage(this.storage);
        ServerMessage msg = pgdMessage.getMessage();
        Page page = this.getPage(msg.getAddress(), packet.getPageNumber());
        page.write(pgdMessage);
    }

    private ConcurrentMap<Integer, Page> getPageMap(SimpleString storeName) {
        ConcurrentMap mapResult;
        ConcurrentMap resultIndex = (ConcurrentHashMap)this.pageIndex.get(storeName);
        if (resultIndex == null && (mapResult = (ConcurrentMap)this.pageIndex.putIfAbsent(storeName, resultIndex = new ConcurrentHashMap())) != null) {
            resultIndex = mapResult;
        }
        return resultIndex;
    }

    private Page getPage(SimpleString storeName, int pageId) throws Exception {
        ConcurrentMap<Integer, Page> map = this.getPageMap(storeName);
        Page page = (Page)map.get(pageId);
        if (page == null) {
            page = this.newPage(pageId, storeName, map);
        }
        return page;
    }

    private synchronized Page newPage(int pageId, SimpleString storeName, ConcurrentMap<Integer, Page> map) throws Exception {
        Page page = (Page)map.get(pageId);
        if (page == null) {
            page = this.pageManager.getPageStore(storeName).createPage(pageId);
            page.open();
            map.put(pageId, page);
        }
        return page;
    }

    private Journal getJournal(byte journalID) {
        return this.journals[journalID];
    }
}

