/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.resource;

import bitronix.tm.TransactionManagerServices;
import bitronix.tm.recovery.IncrementalRecoverer;
import bitronix.tm.recovery.RecoveryException;
import bitronix.tm.resource.common.XAResourceHolder;
import bitronix.tm.resource.common.XAResourceProducer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.transaction.xa.XAResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceRegistrar {
    private static final Logger log = LoggerFactory.getLogger(ResourceRegistrar.class);
    private static Map resources = new HashMap();

    public static synchronized XAResourceProducer get(String uniqueName) {
        return (XAResourceProducer)resources.get(uniqueName);
    }

    public static synchronized Set getResourcesUniqueNames() {
        return new HashSet(resources.keySet());
    }

    public static synchronized void register(XAResourceProducer producer) throws RecoveryException {
        String uniqueName = producer.getUniqueName();
        if (producer.getUniqueName() == null) {
            throw new IllegalArgumentException("invalid resource with null uniqueName");
        }
        if (resources.containsKey(uniqueName)) {
            throw new IllegalArgumentException("resource with uniqueName '" + producer.getUniqueName() + "' has already been registered");
        }
        if (TransactionManagerServices.isTransactionManagerRunning()) {
            if (log.isDebugEnabled()) {
                log.debug("transaction manager is running, recovering resource " + uniqueName);
            }
            IncrementalRecoverer.recover(producer);
        }
        resources.put(uniqueName, producer);
    }

    public static synchronized void unregister(XAResourceProducer producer) {
        String uniqueName = producer.getUniqueName();
        if (producer.getUniqueName() == null) {
            throw new IllegalArgumentException("invalid resource with null uniqueName");
        }
        if (!resources.containsKey(uniqueName)) {
            if (log.isDebugEnabled()) {
                log.debug("resource with uniqueName '" + producer.getUniqueName() + "' has not been registered");
            }
            return;
        }
        resources.remove(uniqueName);
    }

    public static synchronized XAResourceHolder findXAResourceHolder(XAResource xaResource) {
        for (Map.Entry entry : resources.entrySet()) {
            XAResourceProducer producer = (XAResourceProducer)entry.getValue();
            XAResourceHolder resourceHolder = producer.findXAResourceHolder(xaResource);
            if (resourceHolder != null) {
                if (log.isDebugEnabled()) {
                    log.debug("XAResource " + xaResource + " belongs to " + resourceHolder + " that itself belongs to " + producer);
                }
                return resourceHolder;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug("XAResource " + xaResource + " does not belong to any resource of " + producer);
        }
        return null;
    }
}

