/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.resource.jdbc.lrc;

import bitronix.tm.resource.jdbc.BaseProxyHandlerClass;
import bitronix.tm.resource.jdbc.lrc.LrcXAResource;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Savepoint;

public class LrcConnectionHandle
extends BaseProxyHandlerClass {
    private Connection delegate;
    private LrcXAResource xaResource;

    public LrcConnectionHandle(LrcXAResource xaResource, Connection delegate) {
        this.delegate = delegate;
        this.xaResource = xaResource;
    }

    public Connection getConnection() {
        return this.delegate;
    }

    private Connection getDelegate() throws SQLException {
        if (this.delegate == null) {
            throw new SQLException("connection is closed");
        }
        return this.delegate;
    }

    public void close() throws SQLException {
        this.delegate = null;
    }

    public boolean isClosed() throws SQLException {
        return this.delegate == null;
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        if (this.xaResource.getState() != 0 && autoCommit) {
            throw new SQLException("XA transaction started, cannot enable autocommit mode");
        }
        this.getDelegate().setAutoCommit(autoCommit);
    }

    public void commit() throws SQLException {
        if (this.xaResource.getState() != 0) {
            throw new SQLException("XA transaction started, cannot call commit directly on connection");
        }
        this.getDelegate().commit();
    }

    public void rollback() throws SQLException {
        if (this.xaResource.getState() != 0) {
            throw new SQLException("XA transaction started, cannot call rollback directly on connection");
        }
        this.getDelegate().rollback();
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        if (this.xaResource.getState() != 0) {
            throw new SQLException("XA transaction started, cannot call rollback directly on connection");
        }
        this.getDelegate().rollback(savepoint);
    }

    public String toString() {
        return "a JDBC LrcConnectionHandle on " + this.xaResource;
    }

    public Object getProxiedDelegate() throws Exception {
        return this.getDelegate();
    }
}

